/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.filter.remote;

import ch.vd.shared.iam.web.filter.remote.RemoteHostHelper;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteHostPureServletFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Pattern[] allowed;
    private Pattern[] denied;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String clientAddr = request.getRemoteAddr();
        if (this.isInvalidAddress(clientAddr)) {
            this.logger.debug("Denied access to ip {}", (Object)clientAddr);
            RemoteHostHelper.handleInvalidAccess(request, response, clientAddr);
            return;
        }
        this.logger.debug("Access granted to ip {}", (Object)clientAddr);
        chain.doFilter(request, response);
    }

    boolean isInvalidAddress(String address) {
        return this.denied.length > 0 && RemoteHostHelper.hasMatch(address, this.denied) || this.allowed.length > 0 && !RemoteHostHelper.hasMatch(address, this.allowed);
    }

    public void destroy() {
        this.allowed = null;
        this.denied = null;
    }

    public void init(FilterConfig filterConfig) {
        String allowedIps = filterConfig.getInitParameter("allowed");
        this.logger.debug("allowed='{}'", (Object)allowedIps);
        String denyStr = filterConfig.getInitParameter("denied");
        this.logger.debug("denied='{}'", (Object)denyStr);
        this.allowed = RemoteHostHelper.parseParam(allowedIps, true);
        this.denied = RemoteHostHelper.parseParam(denyStr, true);
        if (this.allowed.length == 0 && this.denied.length == 0) {
            throw new IllegalArgumentException("Au moins une des deux valeurs [denied/allowed] doit \u00eatre configur\u00e9e");
        }
    }
}

