/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.filter.remote;

import ch.vd.shared.iam.web.filter.remote.RemoteHostHelper;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.GenericFilterBean;

public class RemoteHostSpringFilter
extends GenericFilterBean {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Pattern[] allowed;
    private Pattern[] denied;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String clientAddr = request.getRemoteAddr();
        if (this.isInvalidAddress(clientAddr)) {
            RemoteHostHelper.handleInvalidAccess(request, response, clientAddr);
            return;
        }
        chain.doFilter(request, response);
    }

    protected boolean isInvalidAddress(String address) {
        return this.denied.length > 0 && RemoteHostHelper.hasMatch(address, this.denied) || this.allowed.length > 0 && !RemoteHostHelper.hasMatch(address, this.allowed);
    }

    public void destroy() {
        this.allowed = null;
        this.denied = null;
    }

    public void setAllowed(String allowed) {
        this.logger.debug("allowed='{}'", (Object)StringUtils.trimToEmpty((String)allowed));
        this.allowed = RemoteHostHelper.parseParam(allowed, false);
    }

    public void setDenied(String denied) {
        this.logger.debug("denied='{}'", (Object)StringUtils.trimToEmpty((String)denied));
        this.denied = RemoteHostHelper.parseParam(denied, false);
    }

    public void setAllowedRegex(String allowed) {
        this.logger.debug("allowed='{}'", (Object)StringUtils.trimToEmpty((String)allowed));
        this.allowed = RemoteHostHelper.parseParam(allowed, true);
    }

    public void setDeniedRegex(String denied) {
        this.logger.debug("denied='{}'", (Object)StringUtils.trimToEmpty((String)denied));
        this.denied = RemoteHostHelper.parseParam(denied, true);
    }
}

