/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.filter.session;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class HttpSessionInvalidatorSpringFilter
extends GenericFilterBean {
    private boolean clearSecurityContext = true;
    private boolean invalidateSession = true;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (this.invalidateSession && request.getSession(false) != null) {
            request.getSession().invalidate();
        }
        if (this.clearSecurityContext) {
            SecurityContextHolder.clearContext();
        }
    }

    public void setClearSecurityContext(boolean clearSecurityContext) {
        this.clearSecurityContext = clearSecurityContext;
    }

    public void setInvalidateSession(boolean invalidateSession) {
        this.invalidateSession = invalidateSession;
    }
}

