/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.utils;

import ch.vd.shared.iam.core.filter.auth.IamAuthority;
import ch.vd.shared.iam.web.common.RequestHelper;
import ch.vd.shared.iam.web.filter.auth.IamRequestWrapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public abstract class IamWebUtils {
    private static final String PIPE_SEPARATOR = "\\x7C";
    public static final String X_FORWARDED_HOST = "X-Forwarded-Host";

    public static List<String> parseRoles(IamRequestWrapper wrapper) {
        return IamWebUtils.parseRoles(wrapper.getApplication(), wrapper.getRoles());
    }

    public static List<String> parseRoles(String application, String rolesStr) {
        String[] roles;
        Objects.requireNonNull(application, "'application' cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (String role : roles = rolesStr == null ? new String[]{} : rolesStr.split(PIPE_SEPARATOR)) {
            if (IamWebUtils.isLDAPRoles(role)) {
                String[] roleItems = role.split("[=,]");
                if (roleItems.length > 1) {
                    String appRole = roleItems[1];
                    IamWebUtils.handleApplicationRoles(application, result, appRole);
                    continue;
                }
                RequestHelper.LOGGER.error("parseRoles(): Unexpected role={}", (Object)role);
                continue;
            }
            IamWebUtils.handleApplicationRoles(application, result, role);
        }
        return result;
    }

    private static void handleApplicationRoles(String application, List<String> result, String role) {
        if (role.startsWith(application)) {
            Assert.isTrue((role.length() > application.length() ? 1 : 0) != 0, (String)("Erreur dans les headers. application='" + application + "' role='" + role + "'"));
            if (role.charAt(application.length()) == '-') {
                String subRole = role.substring(1 + application.length());
                result.add("ROLE_" + subRole.toUpperCase());
            } else {
                RequestHelper.LOGGER.debug("parseRoles(): Ignoring role={}", (Object)role);
            }
        } else {
            RequestHelper.LOGGER.debug("parseRoles(): Ignoring role={}", (Object)role);
        }
    }

    public static List<IamAuthority> convertToAuthority(List<String> rolesStr) {
        ArrayList<IamAuthority> result = new ArrayList<IamAuthority>();
        if (rolesStr != null) {
            for (String role : rolesStr) {
                result.add(new IamAuthority(role));
            }
        }
        return result;
    }

    public static String calculateRedirect(HttpServletRequest request, String inputUrl) {
        int commaIndex;
        String contextPath = request.getContextPath();
        String contextUrl = !inputUrl.startsWith("/") ? contextPath + "/" + inputUrl : inputUrl;
        String host = request.getHeader(X_FORWARDED_HOST);
        if (StringUtils.isNotBlank((CharSequence)host) && (commaIndex = host.indexOf(",", 3)) > 0) {
            host = host.substring(0, commaIndex);
        }
        String redir = host != null && !host.startsWith("localhost") ? "https://" + host + contextUrl : contextUrl;
        return redir;
    }

    public static Date parseIsoTime(String str) {
        Date date;
        if (str != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            try {
                date = sdf.parse(str);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        } else {
            date = null;
        }
        return date;
    }

    private static boolean isLDAPRoles(String allRoles) {
        return allRoles.contains("=");
    }
}

