/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import dotty.DottyPredef$;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.profile.ExtendedThreadMxBean;
import dotty.tools.dotc.profile.ExternalToolHook;
import dotty.tools.dotc.profile.GcEventData$;
import dotty.tools.dotc.profile.ProfileRange;
import dotty.tools.dotc.profile.ProfileRange$;
import dotty.tools.dotc.profile.ProfileReporter;
import dotty.tools.dotc.profile.ProfileSnap;
import dotty.tools.dotc.profile.ProfileSnap$;
import dotty.tools.dotc.profile.Profiler;
import dotty.tools.dotc.profile.RealProfiler$;
import dotty.tools.io.AbstractFile;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.compat.java8.JProcedure1;

public class RealProfiler
implements Profiler,
NotificationListener {
    private final ProfileReporter reporter;
    private final Contexts.Context ctx;
    private final int id;
    private final Thread mainThread;

    public static MemoryMXBean memoryMx() {
        return RealProfiler$.MODULE$.memoryMx();
    }

    public static List gcMx() {
        return RealProfiler$.MODULE$.gcMx();
    }

    public static ExtendedThreadMxBean threadMx() {
        return RealProfiler$.MODULE$.threadMx();
    }

    public static CompilationMXBean compileMx() {
        return RealProfiler$.MODULE$.compileMx();
    }

    public static ClassLoadingMXBean classLoaderMx() {
        return RealProfiler$.MODULE$.classLoaderMx();
    }

    public static RuntimeMXBean runtimeMx() {
        return RealProfiler$.MODULE$.runtimeMx();
    }

    public RealProfiler(ProfileReporter reporter, Contexts.Context ctx) {
        this.reporter = reporter;
        this.ctx = ctx;
        this.id = RealProfiler$.MODULE$.dotty$tools$dotc$profile$RealProfiler$$$idGen().incrementAndGet();
        RealProfiler$.MODULE$.gcMx().foreach((Function1)((JProcedure1)x$1 -> {
            GarbageCollectorMXBean garbageCollectorMXBean = x$1;
            if (garbageCollectorMXBean instanceof NotificationEmitter) {
                NotificationEmitter notificationEmitter;
                NotificationEmitter emitter = notificationEmitter = (NotificationEmitter)((Object)garbageCollectorMXBean);
                emitter.addNotificationListener(this, null, null);
            } else {
                GarbageCollectorMXBean gc = garbageCollectorMXBean;
                Predef$.MODULE$.println((Object)("Cant connect gcListener to " + gc.getClass()));
            }
        }));
        this.mainThread = Thread.currentThread();
        reporter.header(this);
    }

    public void completeBackground(ProfileRange threadRange) {
        this.reporter.reportBackground(this, threadRange);
    }

    public AbstractFile outDir() {
        Settings.Setting<AbstractFile> setting = Settings$Setting$.MODULE$.SettingDecorator(this.ctx.settings().outputDir());
        return Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, this.ctx);
    }

    public int id() {
        return this.id;
    }

    private Thread mainThread() {
        return this.mainThread;
    }

    public ProfileSnap snapThread(long idleTimeNanos) {
        Thread current = Thread.currentThread();
        return ProfileSnap$.MODULE$.apply(current.getId(), current.getName(), System.nanoTime(), idleTimeNanos, RealProfiler$.MODULE$.threadMx().getCurrentThreadCpuTime(), RealProfiler$.MODULE$.threadMx().getCurrentThreadUserTime(), RealProfiler$.MODULE$.threadMx().getThreadAllocatedBytes(Thread.currentThread().getId()), this.readHeapUsage());
    }

    private long readHeapUsage() {
        return RealProfiler$.MODULE$.memoryMx().getHeapMemoryUsage().getUsed();
    }

    private void doGC() {
        System.gc();
        System.runFinalization();
    }

    @Override
    public void finished() {
        RealProfiler$.MODULE$.gcMx().foreach((Function1)((JProcedure1)x$1 -> {
            GarbageCollectorMXBean garbageCollectorMXBean = x$1;
            if (garbageCollectorMXBean instanceof NotificationEmitter) {
                NotificationEmitter notificationEmitter;
                NotificationEmitter emitter = notificationEmitter = (NotificationEmitter)((Object)garbageCollectorMXBean);
                emitter.removeNotificationListener(this);
            } else {
                GarbageCollectorMXBean gc = garbageCollectorMXBean;
            }
        }));
        this.reporter.close(this);
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        CompositeData cd;
        long reportNs;
        block3: {
            Object object;
            block2: {
                CompositeData compositeData;
                reportNs = System.nanoTime();
                Object data = notification.getUserData();
                long seq = notification.getSequenceNumber();
                String message = notification.getMessage();
                String tpe = notification.getType();
                long time = notification.getTimeStamp();
                object = data;
                if (!(object instanceof CompositeData)) break block2;
                cd = compositeData = (CompositeData)object;
                String string = tpe;
                String string2 = "com.sun.management.gc.notification";
                if (!(string != null ? !string.equals(string2) : string2 != null)) break block3;
            }
            throw new MatchError(object);
        }
        String name = cd.get("gcName").toString();
        String action = cd.get("gcAction").toString();
        String cause = cd.get("gcCause").toString();
        CompositeData info = (CompositeData)cd.get("gcInfo");
        long duration = (Long)info.get("duration");
        long startTime = (Long)info.get("startTime");
        long endTime = (Long)info.get("endTime");
        long threads = ((Integer)info.get("GcThreadCount")).longValue();
        this.reporter.reportGc(GcEventData$.MODULE$.apply("", reportNs, startTime, endTime, name, action, cause, threads));
    }

    @Override
    public void afterPhase(Phases.Phase phase, ProfileSnap snapBefore) {
        ProfileSnap profileSnap;
        Settings.Setting<List<String>> setting;
        if (this.mainThread() != Thread.currentThread()) {
            DottyPredef$.MODULE$.assertFail();
        }
        ProfileSnap initialSnap = this.snapThread(0L);
        Settings.Setting<List<String>> setting2 = Settings$Setting$.MODULE$.SettingDecorator(this.ctx.settings().YprofileExternalTool());
        if (((LinearSeqOptimized)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2, this.ctx)).contains((Object)phase.toString())) {
            Predef$.MODULE$.println((Object)"Profile hook stop");
            ExternalToolHook.after();
        }
        if (((LinearSeqOptimized)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting = Settings$Setting$.MODULE$.SettingDecorator(this.ctx.settings().YprofileRunGcBetweenPhases()), this.ctx)).contains((Object)phase.toString())) {
            this.doGC();
            profileSnap = initialSnap.updateHeap(this.readHeapUsage());
        } else {
            profileSnap = initialSnap;
        }
        ProfileSnap finalSnap = profileSnap;
        this.reporter.reportForeground(this, ProfileRange$.MODULE$.apply(snapBefore, finalSnap, phase, "", 0, Thread.currentThread()));
    }

    @Override
    public ProfileSnap beforePhase(Phases.Phase phase) {
        Settings.Setting<List<String>> setting;
        Settings.Setting<List<String>> setting2;
        if (this.mainThread() != Thread.currentThread()) {
            DottyPredef$.MODULE$.assertFail();
        }
        if (((LinearSeqOptimized)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2 = Settings$Setting$.MODULE$.SettingDecorator(this.ctx.settings().YprofileRunGcBetweenPhases()), this.ctx)).contains((Object)phase.toString())) {
            this.doGC();
        }
        if (((LinearSeqOptimized)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting = Settings$Setting$.MODULE$.SettingDecorator(this.ctx.settings().YprofileExternalTool()), this.ctx)).contains((Object)phase.toString())) {
            Predef$.MODULE$.println((Object)"Profile hook start");
            ExternalToolHook.before();
        }
        return this.snapThread(0L);
    }
}

