/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Chars$ {
    public static final Chars$ MODULE$;
    private final char[] char2uescapeArray;
    private final Set otherLetters;
    private final Set letterGroups;

    static {
        new Chars$();
    }

    public Chars$() {
        MODULE$ = this;
        this.char2uescapeArray = (char[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'}), ClassTag$.MODULE$.apply(Character.TYPE));
        this.otherLetters = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'$', '_'}));
        this.letterGroups = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{2, 1, 5, 3, 10}));
    }

    public final char LF() {
        return '\n';
    }

    public final char FF() {
        return '\f';
    }

    public final char CR() {
        return '\r';
    }

    public final char SU() {
        return '\u001a';
    }

    public int digit2int(char ch, int base) {
        int num = ch <= '9' ? ch - 48 : ('a' <= ch && ch <= 'z' ? ch - 97 + 10 : ('A' <= ch && ch <= 'Z' ? ch - 65 + 10 : -1));
        return 0 <= num && num < base ? num : -1;
    }

    public String char2uescape(char c) {
        int ch = c >> 12;
        this.char2uescapeArray[2] = (char)((ch < 10 ? 48 : 55) + ch);
        int ch2 = (c >> 8) % 16;
        this.char2uescapeArray[3] = (char)((ch2 < 10 ? 48 : 55) + ch2);
        int ch3 = (c >> 4) % 16;
        this.char2uescapeArray[4] = (char)((ch3 < 10 ? 48 : 55) + ch3);
        int ch4 = c % 16;
        this.char2uescapeArray[5] = (char)((ch4 < 10 ? 48 : 55) + ch4);
        return new String(this.char2uescapeArray);
    }

    public boolean isLineBreakChar(char c) {
        boolean bl;
        char c2 = c;
        switch (c2) {
            case '\n': 
            case '\f': 
            case '\r': 
            case '\u001a': {
                bl = true;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r';
    }

    public boolean isVarPart(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    public boolean isIdentifierStart(char c) {
        return c == '_' || c == '$' || Character.isUnicodeIdentifierStart(c);
    }

    public boolean isIdentifierPart(char c) {
        return c == '$' || Character.isUnicodeIdentifierPart(c);
    }

    public boolean isSpecial(char c) {
        int chtp = Character.getType(c);
        return chtp == 25 || chtp == 28;
    }

    public boolean isValidJVMChar(char c) {
        return c != '.' && c != ';' && c != '[' && c != '/';
    }

    public boolean isValidJVMMethodChar(char c) {
        return c != '.' && c != ';' && c != '[' && c != '/' && c != '<' && c != '>';
    }

    private final Set<Object> otherLetters() {
        return this.otherLetters;
    }

    private final Set<Object> letterGroups() {
        return this.letterGroups;
    }

    public boolean isScalaLetter(char ch) {
        return this.letterGroups().apply((Object)BoxesRunTime.boxToByte((byte)((byte)Character.getType(ch)))) || this.otherLetters().apply((Object)BoxesRunTime.boxToCharacter((char)ch));
    }

    public boolean isOperatorPart(char c) {
        boolean bl;
        char c2 = c;
        switch (c2) {
            case '!': 
            case '#': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '^': 
            case '|': 
            case '~': {
                bl = true;
                break;
            }
            default: {
                char c3 = c2;
                bl = this.isSpecial(c3);
                break;
            }
        }
        return bl;
    }

    private final char hexChar$1(int ch) {
        return (char)((ch < 10 ? 48 : 55) + ch);
    }
}

