/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core;

import dotty.DottyPredef$;
import dotty.tools.dotc.core.Constraint;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.OrderingConstraint;
import dotty.tools.dotc.core.TestReporter;
import dotty.tools.dotc.core.TyperState$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.Types$NoType$;
import dotty.tools.dotc.reporting.ConsoleReporter;
import dotty.tools.dotc.reporting.ConsoleReporter$;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.reporting.StoreReporter;
import dotty.tools.dotc.util.SimpleIdentityMap$;
import dotty.tools.dotc.util.SimpleIdentitySet;
import dotty.tools.dotc.util.SimpleIdentitySet$empty$;
import java.lang.ref.WeakReference;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.JProcedure1;
import scala.runtime.BoxedUnit;

public class TyperState {
    private final TyperState previous;
    private final int id;
    private Reporter myReporter;
    private Constraint myConstraint;
    private final Constraint previousConstraint;
    private boolean myIsCommittable;
    private boolean isShared;
    private boolean isCommitted;
    private SimpleIdentitySet myOwnedVars;
    private TestReporter testReporter;

    public TyperState(TyperState previous) {
        this.previous = previous;
        this.id = TyperState$.MODULE$.dotty$tools$dotc$core$TyperState$$$nextId();
        TyperState$ typerState$ = TyperState$.MODULE$;
        typerState$.dotty$tools$dotc$core$TyperState$$$nextId_$eq(typerState$.dotty$tools$dotc$core$TyperState$$$nextId() + 1);
        this.myReporter = previous == null ? new ConsoleReporter(ConsoleReporter$.MODULE$.$lessinit$greater$default$1(), ConsoleReporter$.MODULE$.$lessinit$greater$default$2()) : previous.reporter();
        this.myConstraint = previous == null ? new OrderingConstraint(SimpleIdentityMap$.MODULE$.Empty(), SimpleIdentityMap$.MODULE$.Empty(), SimpleIdentityMap$.MODULE$.Empty()) : previous.constraint();
        this.previousConstraint = previous == null ? this.constraint() : previous.constraint();
        this.myIsCommittable = true;
        this.isShared = false;
        this.isCommitted = false;
        this.myOwnedVars = SimpleIdentitySet$empty$.MODULE$;
        this.testReporter = null;
    }

    public int id() {
        return this.id;
    }

    public Reporter reporter() {
        return this.myReporter;
    }

    public TyperState setReporter(Reporter reporter) {
        this.myReporter = reporter;
        return this;
    }

    public Constraint constraint() {
        return this.myConstraint;
    }

    public void constraint_$eq(Constraint c, Contexts.Context ctx) {
        this.myConstraint = c;
    }

    public void resetConstraintTo(Constraint c) {
        if (c != this.myConstraint) {
            this.myConstraint.markRetracted();
        }
        this.myConstraint = c;
    }

    private Constraint previousConstraint() {
        return this.previousConstraint;
    }

    public boolean isCommittable() {
        return this.myIsCommittable;
    }

    public TyperState setCommittable(boolean committable) {
        this.myIsCommittable = committable;
        return this;
    }

    public boolean isGlobalCommittable() {
        return this.isCommittable() && (this.previous == null || this.previous.isGlobalCommittable());
    }

    public void markShared() {
        this.isShared = true;
    }

    public TyperState fresh() {
        return new TyperState(this).setReporter(new StoreReporter(this.reporter())).setCommittable(this.isCommittable());
    }

    public Seq<Types.TypeVar> uninstVars() {
        return this.constraint().uninstVars();
    }

    public SimpleIdentitySet ownedVars() {
        return this.myOwnedVars;
    }

    public void ownedVars_$eq(SimpleIdentitySet vs) {
        this.myOwnedVars = vs;
    }

    public Types.Type instType(Types.TypeVar tvar, Contexts.Context ctx) {
        Types.Type type;
        Types.Type type2 = this.constraint().entry(tvar.origin());
        if (type2 instanceof Types.TypeBounds) {
            Types.TypeBounds typeBounds = (Types.TypeBounds)type2;
            type = Types$NoType$.MODULE$;
        } else if (type2 instanceof Types.TypeParamRef) {
            Types.TypeParamRef typeParamRef;
            Types.TypeParamRef tp = typeParamRef = (Types.TypeParamRef)type2;
            Types.Type tvar1 = this.constraint().typeVarOfParam(tp);
            type = tvar1.exists() ? tvar1 : tp;
        } else {
            Types.Type tp = type2;
            type = tp;
        }
        return type;
    }

    public TyperState uncommittedAncestor() {
        return this.isCommitted ? this.previous.uncommittedAncestor() : this;
    }

    public <T> T test(Function1<Contexts.Context, T> op, Contexts.Context ctx) {
        Object object;
        if (this.isShared) {
            object = op.apply((Object)ctx.fresh().setExploreTyperState());
        } else {
            Constraint savedConstraint = this.myConstraint;
            Reporter savedReporter = this.myReporter;
            boolean savedCommittable = this.myIsCommittable;
            boolean savedCommitted = this.isCommitted;
            this.myIsCommittable = false;
            if (this.testReporter == null || this.testReporter.inUse()) {
                this.testReporter = new TestReporter(this.reporter());
            } else {
                this.testReporter.reset();
            }
            this.testReporter.inUse_$eq(true);
            this.myReporter = this.testReporter;
            try {
                object = op.apply((Object)ctx);
            }
            finally {
                this.testReporter.inUse_$eq(false);
                this.resetConstraintTo(savedConstraint);
                this.myReporter = savedReporter;
                this.myIsCommittable = savedCommittable;
                this.isCommitted = savedCommitted;
            }
        }
        return (T)object;
    }

    public void commit(Contexts.Context ctx) {
        TyperState targetState = ctx.typerState();
        if (!this.isCommittable()) {
            DottyPredef$.MODULE$.assertFail();
        }
        targetState.constraint_$eq(targetState.constraint() == this.previousConstraint() ? this.constraint() : targetState.constraint().$amp(this.constraint(), this.reporter().errorsReported(), ctx), ctx);
        this.constraint().foreachTypeVar((Function1<Types.TypeVar, BoxedUnit>)((JProcedure1)tvar -> {
            if (tvar.owningState().get() == this) {
                tvar.owningState_$eq(new WeakReference<TyperState>(targetState));
            }
        }));
        targetState.ownedVars_$eq(targetState.ownedVars().$plus$plus(this.ownedVars()));
        targetState.gc(ctx);
        this.reporter().flush(ctx);
        this.isCommitted = true;
    }

    public void gc(Contexts.Context ctx) {
        ListBuffer toCollect = new ListBuffer();
        this.constraint().foreachTypeVar((Function1<Types.TypeVar, BoxedUnit>)((JProcedure1)tvar -> {
            Types.Type inst;
            if (!tvar.inst().exists() && (inst = this.instType((Types.TypeVar)tvar, ctx)).exists() && tvar.owningState().get() == this) {
                tvar.inst_$eq(inst);
                Types.TypeLambda lam = tvar.origin().binder();
                if (this.constraint().isRemovable(lam)) {
                    toCollect.$plus$eq((Object)lam);
                }
            }
        }));
        toCollect.foreach((Function1)((JProcedure1)poly -> this.constraint_$eq(this.constraint().remove((Types.TypeLambda)poly, ctx), ctx)));
    }

    public String toString() {
        return "TS[" + this.id() + "]";
    }

    public String stateChainStr() {
        return "" + this + (this.previous == null ? "" : this.previous.stateChainStr());
    }
}

