/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.runtime.Arrays$;
import dotty.tools.dotc.util.LRUCache$;
import dotty.tools.dotc.util.SixteenNibbles$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.compat.java8.JFunction1;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class LRUCache<Key, Value> {
    private final Object[] keys;
    private final Object values;
    private long next;
    private int last;
    private int lastButOne;

    public static long initialRing() {
        return LRUCache$.MODULE$.initialRing();
    }

    public static int Retained() {
        return LRUCache$.MODULE$.Retained();
    }

    public <Key, Value> LRUCache(ClassTag<Key> evidence$1, ClassTag<Value> evidence$2) {
        this.keys = (Object[])Arrays$.MODULE$.newGenericArray(LRUCache$.MODULE$.Retained(), evidence$1);
        this.values = Arrays$.MODULE$.newGenericArray(LRUCache$.MODULE$.Retained(), evidence$2);
        this.next = LRUCache$.MODULE$.initialRing();
        this.last = LRUCache$.MODULE$.Retained() - 1;
        this.lastButOne = this.last() - 1;
    }

    public Key[] keys() {
        return this.keys;
    }

    public Value[] values() {
        return this.values;
    }

    public long next() {
        return this.next;
    }

    public void next_$eq(long x$1) {
        this.next = x$1;
    }

    public int last() {
        return this.last;
    }

    public void last_$eq(int x$1) {
        this.last = x$1;
    }

    public int lastButOne() {
        return this.lastButOne;
    }

    public void lastButOne_$eq(int x$1) {
        this.lastButOne = x$1;
    }

    public int first() {
        return SixteenNibbles$.MODULE$.apply$extension(this.next(), this.last());
    }

    public Value lookup(Key key) {
        return (Value)this.lookupNext$1(key, this.last(), this.first(), this.next());
    }

    public void enter(Key key, Value value) {
        this.keys()[this.last()] = key;
        ScalaRunTime$.MODULE$.array_update(this.values(), this.last(), value);
        this.last_$eq(this.lastButOne());
    }

    public void invalidate(Key key) {
        if (this.lookup(key) != null) {
            this.keys()[this.first()] = null;
            this.last_$eq(this.first());
        }
    }

    public Iterator<Object> indices() {
        long l = this.next();
        return package$.MODULE$.Iterator().iterate((Object)BoxesRunTime.boxToInteger((int)this.first()), (Function1)((JFunction1.mcII.sp)idx -> SixteenNibbles$.MODULE$.apply$extension(l, idx)));
    }

    public Iterator<Key> keysIterator() {
        return this.indices().take(LRUCache$.MODULE$.Retained()).map((Function1)Predef$.MODULE$.wrapRefArray((Object[])this.keys())).filter((Function1)((JFunction1)_$1069 -> _$1069 != null));
    }

    public String toString() {
        List assocs = ((List)this.keysIterator().toList().reverse().map(key -> "" + key + " -> " + this.lookup(key), List$.MODULE$.canBuildFrom())).reverse();
        return "LRUCache(" + assocs.mkString(", ") + ")";
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Object lookupNext$1(Object key$5, int prev, int current, long nx) {
        long l = nx;
        int n = current;
        int n2 = prev;
        while (true) {
            int follow = SixteenNibbles$.MODULE$.apply$extension(l, n);
            if (this.keys()[n] == key$5) {
                if (n == this.last()) {
                    this.last_$eq(n2);
                } else if (n2 != this.last()) {
                    this.next_$eq(SixteenNibbles$.MODULE$.updated$extension(this.next(), n2, follow));
                    this.next_$eq(SixteenNibbles$.MODULE$.updated$extension(this.next(), n, this.first()));
                    this.next_$eq(SixteenNibbles$.MODULE$.updated$extension(this.next(), this.last(), n));
                }
                Object object = ScalaRunTime$.MODULE$.array_apply(this.values(), n);
                return object;
            }
            if (n == this.last()) {
                this.lastButOne_$eq(n2);
                return null;
            }
            int n3 = n;
            n = follow;
            n2 = n3;
        }
    }
}

