/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.SimpleIdentitySet$empty$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.JFunction2;
import scala.compat.java8.JProcedure1;
import scala.runtime.BoxedUnit;

public abstract class SimpleIdentitySet<Elem> {
    public abstract int size();

    public abstract <E> SimpleIdentitySet<E> $plus(E var1);

    public abstract <E> SimpleIdentitySet<Elem> $minus(E var1);

    public abstract <E> boolean contains(E var1);

    public abstract void foreach(Function1<Elem, BoxedUnit> var1);

    public List<Elem> toList() {
        ListBuffer buf = new ListBuffer();
        this.foreach((Function1<Elem, BoxedUnit>)((JProcedure1)_$1070 -> buf.$plus$eq(_$1070)));
        return buf.toList();
    }

    public <E> SimpleIdentitySet<E> $plus$plus(SimpleIdentitySet<E> that) {
        return (SimpleIdentitySet)that.toList().$div$colon((Object)this, (Function2)((JFunction2)(_$1071, _$1072) -> _$1071.$plus(_$1072)));
    }

    public <E> SimpleIdentitySet<Elem> $minus$minus(SimpleIdentitySet<E> that) {
        return (SimpleIdentitySet)that.toList().$div$colon((Object)this, (Function2)((JFunction2)(_$1073, _$1074) -> _$1073.$minus(_$1074)));
    }

    public String toString() {
        return this.toList().mkString("(", ", ", ")");
    }

    private static class Set1<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object x0;

        public <Elem> Set1(Object x0) {
            this.x0 = x0;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            return this.contains(x) ? this : new Set2(this.x0, x);
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            return x == this.x0 ? SimpleIdentitySet$empty$.MODULE$ : this;
        }

        @Override
        public <E> boolean contains(E x) {
            return x == this.x0;
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            f.apply(this.x0);
        }
    }

    private static class Set2<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object x0;
        private final Object x1;

        public <Elem> Set2(Object x0, Object x1) {
            this.x0 = x0;
            this.x1 = x1;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            return this.contains(x) ? this : new Set3(this.x0, this.x1, x);
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            return x == this.x0 ? new Set1(this.x1) : (x == this.x1 ? new Set1(this.x0) : this);
        }

        @Override
        public <E> boolean contains(E x) {
            return x == this.x0 || x == this.x1;
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            f.apply(this.x0);
            f.apply(this.x1);
        }
    }

    private static class Set3<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object x0;
        private final Object x1;
        private final Object x2;

        public <Elem> Set3(Object x0, Object x1, Object x2) {
            this.x0 = x0;
            this.x1 = x1;
            this.x2 = x2;
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            SimpleIdentitySet simpleIdentitySet;
            if (this.contains(x)) {
                simpleIdentitySet = this;
            } else {
                Object[] xs = new Object[]{this.x0, this.x1, this.x2, x};
                simpleIdentitySet = new SetN(xs);
            }
            return simpleIdentitySet;
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            return x == this.x0 ? new Set2(this.x1, this.x2) : (x == this.x1 ? new Set2(this.x0, this.x2) : (x == this.x2 ? new Set2(this.x0, this.x1) : this));
        }

        @Override
        public <E> boolean contains(E x) {
            return x == this.x0 || x == this.x1 || x == this.x2;
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            f.apply(this.x0);
            f.apply(this.x1);
            f.apply(this.x2);
        }
    }

    private static class SetN<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object[] xs;

        public <Elem> SetN(Object[] xs) {
            this.xs = xs;
        }

        @Override
        public int size() {
            return this.xs.length;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            Object[] xs1 = new Object[this.size() + 1];
            Array$.MODULE$.copy((Object)this.xs, 0, (Object)xs1, 0, this.size());
            xs1[this.size()] = x;
            return new SetN<Elem>(xs1);
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            SimpleIdentitySet simpleIdentitySet;
            int i;
            for (i = 0; i < this.size() && this.xs[i] != x; ++i) {
            }
            if (i == this.size()) {
                simpleIdentitySet = this;
            } else if (this.size() == 4) {
                simpleIdentitySet = i == 0 ? new Set3(this.xs[1], this.xs[2], this.xs[3]) : (i == 1 ? new Set3(this.xs[0], this.xs[2], this.xs[3]) : (i == 2 ? new Set3(this.xs[0], this.xs[1], this.xs[3]) : new Set3(this.xs[0], this.xs[1], this.xs[2])));
            } else {
                Object[] xs1 = new Object[this.size() - 1];
                Array$.MODULE$.copy((Object)this.xs, 0, (Object)xs1, 0, i);
                Array$.MODULE$.copy((Object)this.xs, i + 1, (Object)xs1, i, this.size() - (i + 1));
                simpleIdentitySet = new SetN<Elem>(xs1);
            }
            return simpleIdentitySet;
        }

        @Override
        public <E> boolean contains(E x) {
            int i;
            for (i = 0; i < this.size() && this.xs[i] != x; ++i) {
            }
            return i < this.size();
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            for (int i = 0; i < this.size(); ++i) {
                f.apply(this.xs[i]);
            }
        }
    }
}

