/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.Chars$;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.Positions$Position$;
import dotty.tools.dotc.util.SourceFile$;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.dotc.util.SourcePosition$;
import dotty.tools.dotc.util.Util$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.VirtualFile;
import java.io.File;
import java.util.Optional;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JFunction1;
import scala.io.Codec;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;

public class SourceFile
implements dotty.tools.dotc.interfaces.SourceFile,
Product {
    private final AbstractFile file;
    private final char[] content;
    private final int length;
    private int[] lineIndices$lzy1;
    private boolean lineIndicesbitmap$1;
    private int lastLine;

    public static SourceFile unapply(SourceFile sourceFile) {
        return SourceFile$.MODULE$.unapply(sourceFile);
    }

    public static Function1 curried() {
        return SourceFile$.MODULE$.curried();
    }

    public static Function1 tupled() {
        return SourceFile$.MODULE$.tupled();
    }

    public SourceFile(AbstractFile file, char[] content) {
        this.file = file;
        this.content = content;
        this.length = content.length;
        this.lastLine = 0;
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public AbstractFile file() {
        return this.file;
    }

    public char[] content() {
        return this.content;
    }

    public SourceFile(AbstractFile file, Codec codec) {
        this(file, new String(file.toByteArray(), codec.charSet()).toCharArray());
    }

    public SourceFile(String name, String content) {
        this((AbstractFile)new VirtualFile(name), content.toCharArray());
    }

    public int tabInc() {
        return 8;
    }

    public String name() {
        return this.file().name();
    }

    public String path() {
        return this.file().path();
    }

    public Optional<File> jfile() {
        return Optional.ofNullable(this.file().file());
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof SourceFile) {
            SourceFile sourceFile;
            SourceFile that2 = sourceFile = (SourceFile)object;
            String string = this.file().path();
            String string2 = that2.file().path();
            bl = !(string != null ? !string.equals(string2) : string2 != null) && this.start() == that2.start();
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Statics.anyHash((Object)this.file().path()) + Statics.anyHash((Object)BoxesRunTime.boxToInteger((int)this.start()));
    }

    public char apply(int idx) {
        return this.content()[idx];
    }

    public int length() {
        return this.length;
    }

    public boolean exists() {
        return true;
    }

    public SourceFile underlying() {
        return this;
    }

    public int start() {
        return 0;
    }

    public SourcePosition atPos(long pos) {
        return Positions$Position$.MODULE$.exists$extension(pos) ? SourcePosition$.MODULE$.apply(this.underlying(), pos, SourcePosition$.MODULE$.$lessinit$greater$default$3()) : NoSourcePosition$.MODULE$;
    }

    public boolean isSelfContained() {
        return this.underlying() == this;
    }

    public SourcePosition positionInUltimateSource(SourcePosition position) {
        return SourcePosition$.MODULE$.apply(this.underlying(), Positions$Position$.MODULE$.shift$extension(position.pos(), this.start()), SourcePosition$.MODULE$.$lessinit$greater$default$3());
    }

    private boolean isLineBreak(int idx) {
        char ch;
        boolean bl = idx >= this.length() ? false : ((ch = this.content()[idx]) == '\r' ? idx + 1 == this.length() || this.content()[idx + 1] != '\n' : Chars$.MODULE$.isLineBreakChar(ch));
        return bl;
    }

    private int[] calculateLineIndices(char[] cs) {
        ArrayBuffer buf = new ArrayBuffer();
        buf.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cs.length).foreach((Function1)((JFunction1)arg_0 -> this.calculateLineIndices$$anonfun$adapted$1(buf, arg_0)));
        buf.$plus$eq((Object)BoxesRunTime.boxToInteger((int)cs.length));
        return (int[])buf.toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    private int[] lineIndices() {
        int[] nArray;
        if (this.lineIndicesbitmap$1) {
            nArray = this.lineIndices$lzy1;
        } else {
            this.lineIndices$lzy1 = this.calculateLineIndices(this.content());
            this.lineIndicesbitmap$1 = true;
            nArray = this.lineIndices$lzy1;
        }
        return nArray;
    }

    public int lineToOffset(int index) {
        return this.lineIndices()[index];
    }

    public int offsetToLine(int offset) {
        this.lastLine = Util$.MODULE$.bestFit(this.lineIndices(), this.lineIndices().length, offset, this.lastLine);
        if (offset >= this.length()) {
            --this.lastLine;
        }
        return this.lastLine;
    }

    public int startOfLine(int offset) {
        Predef$.MODULE$.require(offset >= 0);
        return this.lineToOffset(this.offsetToLine(offset));
    }

    public int nextLine(int offset) {
        return this.lineToOffset(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.offsetToLine(offset) + 1), this.lineIndices().length - 1));
    }

    public String lineContent(int offset) {
        return new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps((char[])new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(this.content())).slice(this.startOfLine(offset), this.nextLine(offset)))).mkString();
    }

    /*
     * WARNING - void declaration
     */
    public int column(int offset) {
        void var3_3;
        int col = 0;
        for (int idx = this.startOfLine(offset); idx != offset; ++idx) {
            col += idx < this.length() && this.content()[idx] == '\t' ? (this.tabInc() - col) % this.tabInc() : 1;
        }
        return (int)var3_3;
    }

    public String startColumnPadding(int offset) {
        StringBuilder pad = new StringBuilder();
        for (int idx = this.startOfLine(offset); idx != offset; ++idx) {
            pad.append((char)(idx < this.length() && this.content()[idx] == '\t' ? 9 : 32));
        }
        return pad.result();
    }

    public String toString() {
        return this.file().toString();
    }

    public SourceFile copy(AbstractFile file, char[] content) {
        return new SourceFile(file, content);
    }

    public AbstractFile copy$default$1() {
        return this.file();
    }

    public char[] copy$default$2() {
        return this.content();
    }

    public AbstractFile _1() {
        return this.file();
    }

    public char[] _2() {
        return this.content();
    }

    public boolean canEqual(Object that) {
        return that instanceof SourceFile;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "SourceFile";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        if (0 == n2) {
            object = this._1();
        } else if (1 == n2) {
            object = this._2();
        } else {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
        }
        return object;
    }

    private final /* synthetic */ Object calculateLineIndices$$anonfun$1(ArrayBuffer buf$49, int i) {
        return this.isLineBreak(i) ? buf$49.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i + 1))) : BoxedUnit.UNIT;
    }

    private final Object calculateLineIndices$$anonfun$adapted$1(ArrayBuffer buf$50, Object i) {
        return this.calculateLineIndices$$anonfun$1(buf$50, BoxesRunTime.unboxToInt((Object)i));
    }
}

