/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Directory;
import dotty.tools.io.File;
import dotty.tools.io.Path;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import scala.Function1;
import scala.compat.java8.JProcedure1;

public class JarWriter {
    private final File file;
    private final Manifest manifest;
    private JarOutputStream out$lzy1;
    private boolean outbitmap$1;

    public JarWriter(File file, Manifest manifest) {
        this.file = file;
        this.manifest = manifest;
    }

    public File file() {
        return this.file;
    }

    public Manifest manifest() {
        return this.manifest;
    }

    private JarOutputStream out() {
        if (!this.outbitmap$1) {
            this.out$lzy1 = new JarOutputStream(this.file().outputStream(this.file().outputStream$default$1()), this.manifest());
            this.outbitmap$1 = true;
        }
        return this.out$lzy1;
    }

    public DataOutputStream newOutputStream(String path) {
        JarEntry entry = new JarEntry(path);
        this.out().putNextEntry(entry);
        return new DataOutputStream(this.out());
    }

    public void writeAllFrom(Directory dir) {
        try {
            dir.list().foreach((Function1)((JProcedure1)x -> this.addEntry((Path)x, "")));
        }
        finally {
            this.out().close();
        }
    }

    public void addStream(JarEntry entry, InputStream in) {
        this.out().putNextEntry(entry);
        try {
            this.transfer(in, this.out());
        }
        finally {
            this.out().closeEntry();
        }
    }

    public void addFile(File file, String prefix) {
        JarEntry entry = new JarEntry(prefix + file.name());
        this.addStream(entry, file.inputStream());
    }

    public void addEntry(Path entry, String prefix) {
        if (entry.isFile()) {
            this.addFile(entry.toFile(), prefix);
        } else {
            this.addDirectory(entry.toDirectory(), prefix + entry.name() + "/");
        }
    }

    public void addDirectory(Directory entry, String prefix) {
        entry.list().foreach((Function1)((JProcedure1)p -> this.addEntry((Path)p, prefix)));
    }

    private void transfer(InputStream in, OutputStream out) {
        byte[] buf = new byte[10240];
        JarWriter.loop$1(in, out, buf);
    }

    public void close() {
        this.out().close();
    }

    private static final void loop$1(InputStream in$12, OutputStream out$34, byte[] buf$55) {
        while (true) {
            int n;
            if (-1 == (n = in$12.read(buf$55, 0, buf$55.length))) break;
            int n2 = n;
            out$34.write(buf$55, 0, n2);
        }
        in$12.close();
    }
}

