/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.AbstractFile;
import dotty.tools.io.File;
import dotty.tools.io.FileZipArchive;
import dotty.tools.io.VirtualFile;
import dotty.tools.io.ZipArchive$;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;

public abstract class ZipArchive
extends AbstractFile {
    private final Path jpath;

    public static FileZipArchive fromPath(Path path) {
        return ZipArchive$.MODULE$.fromPath(path);
    }

    public static FileZipArchive fromFile(File file) {
        return ZipArchive$.MODULE$.fromFile(file);
    }

    public static AbstractFile fromManifestURL(URL uRL) {
        return ZipArchive$.MODULE$.fromManifestURL(uRL);
    }

    public static boolean closeZipFile() {
        return ZipArchive$.MODULE$.closeZipFile();
    }

    public ZipArchive(Path jpath) {
        this.jpath = jpath;
    }

    @Override
    public Path jpath() {
        return this.jpath;
    }

    public Option<ZipArchive> underlyingSource() {
        return Some$.MODULE$.apply((Object)this);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        throw this.unsupported();
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        throw this.unsupported();
    }

    @Override
    public void create() {
        throw this.unsupported();
    }

    @Override
    public void delete() {
        throw this.unsupported();
    }

    @Override
    public OutputStream output() {
        throw this.unsupported();
    }

    @Override
    public AbstractFile container() {
        throw this.unsupported();
    }

    @Override
    public AbstractFile absolute() {
        throw this.unsupported();
    }

    private DirEntry ensureDir(Map<String, DirEntry> dirs, String path, ZipEntry zipEntry) {
        DirEntry dirEntry;
        Option option = dirs.get((Object)path);
        if (option instanceof Some) {
            DirEntry v;
            Some some = (Some)option;
            dirEntry = v = (DirEntry)some.value();
        } else if (None$.MODULE$.equals(option)) {
            DirEntry parent = this.ensureDir(dirs, ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$dirName(path), null);
            DirEntry dir = new DirEntry(this, path);
            parent.entries().update((Object)ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$baseName(path), (Object)dir);
            dirs.update((Object)path, (Object)dir);
            dirEntry = dir;
        } else {
            throw new MatchError((Object)option);
        }
        return dirEntry;
    }

    public DirEntry getDir(Map<String, DirEntry> dirs, ZipEntry entry) {
        return entry.isDirectory() ? this.ensureDir(dirs, entry.getName(), entry) : this.ensureDir(dirs, ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$dirName(entry.getName()), null);
    }

    public static class DirEntry
    extends Entry {
        private final HashMap entries;
        private final ZipArchive $outer;

        public DirEntry(ZipArchive $outer, String path) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, path);
            this.entries = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }

        public String dotty$tools$io$ZipArchive$DirEntry$$path() {
            return super.path();
        }

        public HashMap<String, Entry> entries() {
            return this.entries;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        public Iterator<Entry> iterator() {
            return this.entries().valuesIterator();
        }

        @Override
        public Entry lookupName(String name, boolean directory) {
            return directory ? (Entry)this.entries().get((Object)(name + "/")).orNull(Predef$.MODULE$.$conforms()) : (Entry)this.entries().get((Object)name).orNull(Predef$.MODULE$.$conforms());
        }

        private ZipArchive $outer() {
            return this.$outer;
        }

        public final ZipArchive dotty$tools$io$ZipArchive$DirEntry$$$outer() {
            return this.$outer();
        }
    }

    public static abstract class Entry
    extends VirtualFile {
        private final ZipArchive $outer;

        public Entry(ZipArchive $outer, String path) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$baseName(path), path);
        }

        public String dotty$tools$io$ZipArchive$Entry$$path() {
            return super.path();
        }

        public ZipFile getArchive() {
            return null;
        }

        public Option<ZipArchive> underlyingSource() {
            return Some$.MODULE$.apply((Object)this.dotty$tools$io$ZipArchive$Entry$$$outer());
        }

        @Override
        public String toString() {
            return this.dotty$tools$io$ZipArchive$Entry$$$outer().path() + "(" + this.dotty$tools$io$ZipArchive$Entry$$path() + ")";
        }

        private ZipArchive $outer() {
            return this.$outer;
        }

        public final ZipArchive dotty$tools$io$ZipArchive$Entry$$$outer() {
            return this.$outer();
        }
    }
}

