/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core;

import dotty.tools.dotc.core.Types;
import scala.collection.immutable.List;
import scala.util.hashing.MurmurHash3$;

public interface Hashable {
    default public int hashSeed() {
        return this.getClass().hashCode();
    }

    default public int finishHash(int hashCode, int arity) {
        return this.avoidSpecialHashes(MurmurHash3$.MODULE$.finalizeHash(hashCode, arity));
    }

    default public int typeHash(Binders bs, Types.Type tp) {
        return bs == null || tp.stableHash() ? tp.hash() : tp.computeHash(bs);
    }

    default public int identityHash(Binders bs) {
        return this.avoidSpecialHashes(System.identityHashCode(this));
    }

    default public int finishHash(Binders bs, int seed, int arity, Types.Type tp) {
        int elemHash = this.typeHash(bs, tp);
        if (elemHash == 0) {
            return 0;
        }
        return this.finishHash(MurmurHash3$.MODULE$.mix(seed, elemHash), arity + 1);
    }

    default public int finishHash(Binders bs, int seed, int arity, Types.Type tp1, Types.Type tp2) {
        int elemHash = this.typeHash(bs, tp1);
        if (elemHash == 0) {
            return 0;
        }
        return this.finishHash(bs, MurmurHash3$.MODULE$.mix(seed, elemHash), arity + 1, tp2);
    }

    default public int finishHash(Binders bs, int seed, int arity, List<Types.Type> tps) {
        int h = seed;
        List xs = tps;
        int len = arity;
        while (!xs.isEmpty()) {
            int elemHash = this.typeHash(bs, (Types.Type)xs.head());
            if (elemHash == 0) {
                return 0;
            }
            h = MurmurHash3$.MODULE$.mix(h, elemHash);
            xs = xs.tail();
            ++len;
        }
        return this.finishHash(h, len);
    }

    default public int finishHash(Binders bs, int seed, int arity, Types.Type tp, List<Types.Type> tps) {
        int elemHash = this.typeHash(bs, tp);
        if (elemHash == 0) {
            return 0;
        }
        return this.finishHash(bs, MurmurHash3$.MODULE$.mix(seed, elemHash), arity + 1, tps);
    }

    default public int doHash(Object x) {
        return this.finishHash(MurmurHash3$.MODULE$.mix(this.hashSeed(), x.hashCode()), 1);
    }

    default public int doHash(Binders bs, Types.Type tp) {
        return this.finishHash(bs, this.hashSeed(), 0, tp);
    }

    default public int doHash(Binders bs, Object x1, Types.Type tp2) {
        return this.finishHash(bs, MurmurHash3$.MODULE$.mix(this.hashSeed(), x1.hashCode()), 1, tp2);
    }

    default public int doHash(Binders bs, Types.Type tp1, Types.Type tp2) {
        return this.finishHash(bs, this.hashSeed(), 0, tp1, tp2);
    }

    default public int doHash(Binders bs, Object x1, Types.Type tp2, Types.Type tp3) {
        return this.finishHash(bs, MurmurHash3$.MODULE$.mix(this.hashSeed(), x1.hashCode()), 1, tp2, tp3);
    }

    default public int doHash(Binders bs, Types.Type tp1, List<Types.Type> tps2) {
        return this.finishHash(bs, this.hashSeed(), 0, tp1, tps2);
    }

    default public int doHash(Binders bs, Object x1, Types.Type tp2, List<Types.Type> tps3) {
        return this.finishHash(bs, MurmurHash3$.MODULE$.mix(this.hashSeed(), x1.hashCode()), 1, tp2, tps3);
    }

    default public int doHash(int x1, int x2) {
        return this.finishHash(MurmurHash3$.MODULE$.mix(MurmurHash3$.MODULE$.mix(this.hashSeed(), x1), x2), 1);
    }

    default public int addDelta(int elemHash, int delta) {
        return elemHash == 0 ? 0 : this.avoidSpecialHashes(elemHash + delta);
    }

    default public int avoidSpecialHashes(int h) {
        return h == 0 ? Integer.MIN_VALUE : (h == 1234 ? 4321 : h);
    }

    public static class BinderPairs {
        private final Types.BindingType tp1;
        private final Types.BindingType tp2;
        private final BinderPairs next;

        public BinderPairs(Types.BindingType tp1, Types.BindingType tp2, BinderPairs next) {
            this.tp1 = tp1;
            this.tp2 = tp2;
            this.next = next;
        }

        public final boolean matches(Types.Type t1, Types.Type t2) {
            boolean bl;
            block3: {
                block2: {
                    BinderPairs binderPairs = this;
                    while (t1 != binderPairs.tp1 || t2 != binderPairs.tp2) {
                        if (binderPairs.next != null) {
                            binderPairs = binderPairs.next;
                            continue;
                        }
                        break block2;
                    }
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            return bl;
        }
    }

    public static class Binders {
        private final Types.BindingType tp;
        private final Binders next;

        public Binders(Types.BindingType tp, Binders next) {
            this.tp = tp;
            this.next = next;
        }

        public Types.BindingType tp() {
            return this.tp;
        }

        public Binders next() {
            return this.next;
        }
    }
}

