/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.DottyPredef$;
import dotty.runtime.function.JFunction1;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.config.Printers$;
import dotty.tools.dotc.core.tasty.TastyBuffer;
import dotty.tools.dotc.core.tasty.TastyBuffer$;
import dotty.tools.dotc.core.tasty.TastyBuffer$Addr$;
import dotty.tools.dotc.util.Util$;
import java.io.Serializable;
import java.util.IdentityHashMap;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null;
import scala.runtime.RichInt$;

public class TreeBuffer
extends TastyBuffer {
    private final int initialOffsetSize = this.bytes().length / 8;
    private int[] offsets = new int[this.initialOffsetSize()];
    private boolean[] isRelative = new boolean[this.initialOffsetSize()];
    private int[] delta;
    private int numOffsets = 0;
    private final IdentityHashMap treeAddrs = new IdentityHashMap();

    public TreeBuffer() {
        super(50000);
    }

    private final int ItemsOverOffsets() {
        return 2;
    }

    private int initialOffsetSize() {
        return this.initialOffsetSize;
    }

    private IdentityHashMap<Trees.Tree<Null>, Object> treeAddrs() {
        return this.treeAddrs;
    }

    public int registerTreeAddr(Trees.Tree tree) {
        int n;
        Object object = this.treeAddrs().get(tree);
        if (object == null) {
            this.treeAddrs().put(tree, new TastyBuffer.Addr(this.currentAddr()));
            n = this.currentAddr();
        } else if (object instanceof TastyBuffer.Addr) {
            int addr;
            n = addr = object == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.Addr)object).index();
        } else {
            throw new MatchError(object);
        }
        return n;
    }

    public int addrOfTree(Trees.Tree tree) {
        int n;
        Object object = this.treeAddrs().get(tree);
        if (object == null) {
            n = TastyBuffer$.MODULE$.NoAddr();
        } else if (object instanceof TastyBuffer.Addr) {
            int addr;
            n = addr = object == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.Addr)object).index();
        } else {
            throw new MatchError(object);
        }
        return n;
    }

    private int offset(int i) {
        return TastyBuffer$Addr$.MODULE$.apply(this.offsets[i]);
    }

    private void keepOffset(boolean relative) {
        if (this.numOffsets == this.offsets.length) {
            this.offsets = (int[])Util$.MODULE$.dble(this.offsets, ClassTag$.MODULE$.apply(Integer.TYPE));
            this.isRelative = (boolean[])Util$.MODULE$.dble(this.isRelative, ClassTag$.MODULE$.apply(Boolean.TYPE));
        }
        this.offsets[this.numOffsets] = this.length();
        this.isRelative[this.numOffsets] = relative;
        ++this.numOffsets;
    }

    /*
     * WARNING - void declaration
     */
    public int reserveRef(boolean relative) {
        void var2_2;
        int addr = this.currentAddr();
        this.keepOffset(relative);
        this.reserveAddr();
        return (int)var2_2;
    }

    public void writeRef(int target) {
        this.keepOffset(false);
        this.fillAddr(this.reserveAddr(), target);
    }

    public void fillRef(int at, int target, boolean relative) {
        int addr = relative ? TastyBuffer$Addr$.MODULE$.relativeTo$extension(target, at) : target;
        this.fillAddr(at, addr);
    }

    public int deltaAt(int at) {
        int idx = Util$.MODULE$.bestFit(this.offsets, this.numOffsets, at - 1, Util$.MODULE$.bestFit$default$4());
        return idx < 0 ? 0 : this.delta[idx];
    }

    public int adjusted(int x) {
        return TastyBuffer$Addr$.MODULE$.$minus$extension(x, this.deltaAt(x));
    }

    private void computeDeltas() {
        this.delta = new int[this.numOffsets];
        int lastDelta = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int off = this.offset(i);
            int skippedOff = this.skipZeroes(off);
            int skippedCount = skippedOff - off;
            if (skippedCount >= 4) {
                DottyPredef$.MODULE$.assertFail(() -> TreeBuffer.computeDeltas$$anonfun$1(off));
            }
            this.delta[i] = lastDelta += skippedCount;
        }
    }

    private int adjustedOffset(int i) {
        int n;
        int at = this.offset(i);
        int original = this.getAddr(at);
        if (this.isRelative[i]) {
            int len2;
            int start = this.skipNat(at);
            int len1 = TastyBuffer$Addr$.MODULE$.$minus$extension(TastyBuffer$Addr$.MODULE$.$plus$extension(original, this.delta[i]), this.deltaAt(TastyBuffer$Addr$.MODULE$.$plus$extension(original, start)));
            if (!TastyBuffer$Addr$.MODULE$.$eq$eq$extension(len1, len2 = TastyBuffer$Addr$.MODULE$.$minus$extension(this.adjusted(TastyBuffer$Addr$.MODULE$.$plus$extension(original, start)), this.adjusted(start)))) {
                DottyPredef$.MODULE$.assertFail(() -> TreeBuffer.adjustedOffset$$anonfun$1(i, at, original, len1, len2));
            }
            n = len1;
        } else {
            n = this.adjusted(original);
        }
        return n;
    }

    private void adjustOffsets() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numOffsets).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int corrected = this.adjustedOffset(i);
            this.fillAddr(this.offset(i), corrected);
        });
    }

    private int adjustDeltas() {
        int[] delta1 = new int[this.delta.length];
        int lastDelta = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int corrected = this.adjustedOffset(i);
            delta1[i] = lastDelta += 4 - TastyBuffer$.MODULE$.natSize(corrected);
        }
        int saved = this.numOffsets == 0 ? 0 : delta1[this.numOffsets - 1] - this.delta[this.numOffsets - 1];
        this.delta = delta1;
        return saved;
    }

    private int compress() {
        IntRef lastDelta = IntRef.create((int)0);
        IntRef start = IntRef.create((int)0);
        int wasted = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int n;
            int n2;
            int next = this.offsets[i];
            this.shift$1(lastDelta, start, next);
            start.elem = n2 = next + this.delta[i] - lastDelta.elem;
            int pastZeroes = this.skipZeroes(TastyBuffer$Addr$.MODULE$.apply(next));
            if (pastZeroes < start.elem) {
                DottyPredef$.MODULE$.assertFail(TreeBuffer::compress$$anonfun$1);
            }
            wasted += pastZeroes - start.elem;
            lastDelta.elem = n = this.delta[i];
        }
        this.shift$1(lastDelta, start, this.length());
        this.length_$eq(this.length() - lastDelta.elem);
        return wasted;
    }

    public void adjustTreeAddrs() {
        for (Trees.Tree<Null> tree : this.treeAddrs().keySet()) {
            Object object = this.treeAddrs().get(tree);
            if (object instanceof TastyBuffer.Addr) {
                int addr = object == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.Addr)object).index();
                this.treeAddrs().put(tree, new TastyBuffer.Addr(this.adjusted(addr)));
                continue;
            }
            throw new MatchError(object);
        }
    }

    public void compactify() {
        int origLength = this.length();
        this.computeDeltas();
        IntRef saved = IntRef.create((int)0);
        do {
            int n;
            saved.elem = n = this.adjustDeltas();
            Printers$.MODULE$.pickling().println(() -> TreeBuffer.compactify$$anonfun$1(saved));
        } while (saved.elem > 0 && this.length() / saved.elem < 100);
        this.adjustOffsets();
        this.adjustTreeAddrs();
        int wasted = this.compress();
        Printers$.MODULE$.pickling().println(() -> this.compactify$$anonfun$2(origLength, wasted));
    }

    private static final String computeDeltas$$anonfun$1(int off$1) {
        return "unset field at position " + new TastyBuffer.Addr(off$1);
    }

    private static final String adjustedOffset$$anonfun$1(int i$5, int at$1, int original$8, int len1$1, int len2$1) {
        return "adjusting offset #" + i$5 + ": " + new TastyBuffer.Addr(at$1) + ", original = " + new TastyBuffer.Addr(original$8) + ", len1 = " + new TastyBuffer.Addr(len1$1) + ", len2 = " + new TastyBuffer.Addr(len2$1);
    }

    private final void shift$1(IntRef lastDelta$1, IntRef start$4, int end) {
        System.arraycopy(this.bytes(), start$4.elem, this.bytes(), start$4.elem - lastDelta$1.elem, end - start$4.elem);
    }

    private static final String compress$$anonfun$1() {
        return "something's wrong: eliminated non-zero";
    }

    private static final String compactify$$anonfun$1(IntRef saved$1) {
        return "adjusting deltas, saved = " + saved$1.elem;
    }

    private final String compactify$$anonfun$2(int origLength$1, int wasted$1) {
        return "original length: " + origLength$1 + ", compressed to: " + this.length() + ", wasted: " + wasted$1;
    }
}

