/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.DottyPredef$;
import dotty.runtime.function.JFunction1;
import dotty.tools.dotc.core.NameKinds;
import dotty.tools.dotc.core.NameKinds$;
import dotty.tools.dotc.core.NameKinds$SignedName$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Names$;
import dotty.tools.dotc.core.Signature;
import dotty.tools.dotc.core.Signature$;
import dotty.tools.dotc.core.tasty.TastyBuffer;
import dotty.tools.dotc.core.tasty.TastyBuffer$Addr$;
import dotty.tools.dotc.core.tasty.TastyHeaderUnpickler;
import dotty.tools.dotc.core.tasty.TastyReader;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxesRunTime;

public class TastyUnpickler {
    private final TastyReader reader;
    private final HashMap sectionReader;
    private final NameTable nameAtRef;

    public TastyUnpickler(TastyReader reader) {
        this.reader = reader;
        this.sectionReader = new HashMap();
        this.nameAtRef = new NameTable();
        new TastyHeaderUnpickler(reader).readHeader();
        reader.until(reader.readEnd(), this::$init$$$anonfun$1);
        while (!reader.isAtEnd()) {
            String secName = this.readString();
            int secEnd = reader.readEnd();
            this.sectionReader().update((Object)secName, (Object)new TastyReader(this.bytes(), reader.currentAddr(), secEnd, reader.currentAddr()));
            reader.goto(secEnd);
        }
    }

    public TastyUnpickler(byte[] bytes) {
        this(new TastyReader(bytes));
    }

    private HashMap<String, TastyReader> sectionReader() {
        return this.sectionReader;
    }

    public NameTable nameAtRef() {
        return this.nameAtRef;
    }

    private Names.TermName readName() {
        return this.nameAtRef().apply(this.reader.readNameRef());
    }

    private String readString() {
        return this.readName().toString();
    }

    private Names.TermName readNameContents() {
        Names.TermName termName;
        int tag = this.reader.readByte();
        int length = this.reader.readNat();
        int start = this.reader.currentAddr();
        int end = TastyBuffer$Addr$.MODULE$.$plus$extension(start, length);
        int n = tag;
        switch (n) {
            case 1: {
                this.reader.goto(end);
                termName = Names$.MODULE$.termName(this.bytes(), start, length);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                termName = ((NameKinds.QualifiedNameKind)NameKinds$.MODULE$.qualifiedNameKindOfTag().apply((Object)BoxesRunTime.boxToInteger((int)tag))).apply(this.readName(), this.readName().asSimpleName());
                break;
            }
            case 10: {
                String separator = this.readName().toString();
                int num = this.reader.readNat();
                List originals = this.reader.until(end, this::$anonfun$1);
                Names.TermName original = originals.isEmpty() ? Names$.MODULE$.EmptyTermName() : (Names.TermName)originals.head();
                termName = ((NameKinds.NumberedNameKind)NameKinds$.MODULE$.uniqueNameKindOfSeparator().apply((Object)separator)).apply(original, num);
                break;
            }
            case 11: 
            case 12: {
                termName = ((NameKinds.NumberedNameKind)NameKinds$.MODULE$.numberedNameKindOfTag().apply((Object)BoxesRunTime.boxToInteger((int)tag))).apply(this.readName(), this.reader.readNat());
                break;
            }
            case 63: {
                Names.TermName original = this.readName();
                Names.TypeName result = this.readName().toTypeName();
                List params = this.reader.until(end, this::$anonfun$2);
                Signature sig = Signature$.MODULE$.apply(params, result);
                termName = NameKinds$SignedName$.MODULE$.apply(original, sig);
                break;
            }
            default: {
                termName = ((NameKinds.ClassifiedNameKind)NameKinds$.MODULE$.simpleNameKindOfTag().apply((Object)BoxesRunTime.boxToInteger((int)tag))).apply(this.readName());
                break;
            }
        }
        Names.TermName result = termName;
        if (!TastyBuffer$Addr$.MODULE$.$eq$eq$extension(this.reader.currentAddr(), end)) {
            DottyPredef$.MODULE$.assertFail(() -> this.readNameContents$$anonfun$1(start, end, result));
        }
        return result;
    }

    public <R> Option<R> unpickle(SectionUnpickler<R> sec) {
        return this.sectionReader().get((Object)sec.name()).map((Function1)(JFunction1 & Serializable)reader -> sec.unpickle((TastyReader)reader, this.nameAtRef()));
    }

    public byte[] bytes() {
        return this.reader.bytes();
    }

    private final ArrayBuffer $init$$$anonfun$1() {
        return this.nameAtRef().add(this.readNameContents());
    }

    private final Names.TermName $anonfun$1() {
        return this.readName();
    }

    private final Names.TypeName $anonfun$2() {
        return this.readName().toTypeName();
    }

    private final String readNameContents$$anonfun$1(int start$3, int end$3, Names.TermName result$4) {
        return "bad name " + result$4 + " " + new TastyBuffer.Addr(start$3) + " " + new TastyBuffer.Addr(this.reader.currentAddr()) + " " + new TastyBuffer.Addr(end$3);
    }

    public static class NameTable
    implements Function1<TastyBuffer.NameRef, Names.TermName> {
        private final ArrayBuffer names = new ArrayBuffer();

        private ArrayBuffer<Names.TermName> names() {
            return this.names;
        }

        public ArrayBuffer<Names.TermName> add(Names.TermName name) {
            return this.names().$plus$eq((Object)name);
        }

        public Names.TermName apply(int ref) {
            return (Names.TermName)this.names().apply(ref);
        }

        public Iterable<Names.TermName> contents() {
            return this.names();
        }
    }

    public static abstract class SectionUnpickler<R> {
        private final String name;

        public <R> SectionUnpickler(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract R unpickle(TastyReader var1, NameTable var2);
    }

    public static class UnpickleException
    extends RuntimeException {
        public UnpickleException(String msg) {
            super(msg);
        }
    }
}

