/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import dotty.tools.dotc.config.CommandLineParser$;
import dotty.tools.dotc.config.Properties$;
import dotty.tools.dotc.config.ScalaSettings;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.Message$;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CompilerCommand$
implements scala.Serializable {
    public static final CompilerCommand$ MODULE$;

    static {
        new CompilerCommand$();
    }

    public CompilerCommand$() {
        MODULE$ = this;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CompilerCommand$.class);
    }

    public String cmdName() {
        return "dotc";
    }

    private String explainAdvanced() {
        return "\n    |-- Notes on option parsing --\n    |Boolean settings are always false unless set.\n    |Where multiple values are accepted, they should be comma-separated.\n    |  example: -Xplugin:plugin1,plugin2\n    |<phases> means one or a comma-separated list of:\n    |  - (partial) phase names with an optional \"+\" suffix to include the next phase\n    |  - the string \"all\"\n    |  example: -Xprint:all prints all phases.\n    |  example: -Xprint:front,mixin prints the frontend and mixin phases.\n    |  example: -Ylog:erasure+ logs the erasure phase and the phase after the erasure phase.\n    |           This is useful because during the tree transform of phase X, we often\n    |           already are in phase X + 1.\n  ";
    }

    public String shortUsage() {
        return "Usage: " + this.cmdName() + " <options> <source files>";
    }

    public String versionMsg() {
        return "Dotty compiler " + Properties$.MODULE$.versionString() + " -- " + Properties$.MODULE$.copyrightString();
    }

    public Settings.ArgsSummary distill(String[] args, Contexts.Context ctx) {
        return ctx.settings().processArguments((List<String>)this.expandedArguments$1(args), true, ctx);
    }

    public List<String> checkUsage(Settings.ArgsSummary summary, boolean sourcesRequired, Contexts.Context ctx) {
        Nil$ nil$;
        ScalaSettings settings = ctx.settings();
        summary.warnings().foreach((Function1)(JProcedure1 & Serializable)_$184 -> ctx.warning(() -> this.checkUsage$$anonfun$7$$anonfun$1(_$184), ctx.warning$default$2()));
        if (summary.errors().nonEmpty()) {
            summary.errors().foreach((Function1)(JProcedure1 & Serializable)_$185 -> ctx.error(() -> this.checkUsage$$anonfun$8$$anonfun$1(_$185), ctx.error$default$2(), ctx.error$default$3()));
            ctx.echo(this::checkUsage$$anonfun$3, ctx.echo$default$2());
            nil$ = package$.MODULE$.Nil();
        } else {
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(settings.version());
            if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx))) {
                ctx.echo(this::checkUsage$$anonfun$4, ctx.echo$default$2());
                nil$ = package$.MODULE$.Nil();
            } else if (this.shouldStopWithInfo$1(ctx, settings)) {
                ctx.echo(() -> this.checkUsage$$anonfun$5(ctx, settings), ctx.echo$default$2());
                nil$ = package$.MODULE$.Nil();
            } else {
                if (sourcesRequired && summary.arguments().isEmpty()) {
                    ctx.echo(() -> this.checkUsage$$anonfun$6(ctx), ctx.echo$default$2());
                }
                nil$ = summary.arguments();
            }
        }
        return nil$;
    }

    private final /* synthetic */ boolean stripComment$1$$anonfun$1(char _$179) {
        return _$179 != '#';
    }

    private final boolean stripComment$2$$anonfun$adapted$1(Object _$179) {
        return this.stripComment$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$179));
    }

    private final String stripComment$3(String s) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(s)).takeWhile((Function1)((JFunction1 & Serializable)this::stripComment$2$$anonfun$adapted$1));
    }

    private final List expandArg$1(String arg) {
        Path path = Paths.get(new StringOps(Predef$.MODULE$.augmentString(arg)).stripPrefix("@"), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException(new StringOps(Predef$.MODULE$.augmentString("argument file %s could not be found")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getFileName()})));
        }
        java.util.List<String> lines = Files.readAllLines(path);
        String params = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(lines).asScala()).map((Function1)(JFunction1 & Serializable)s -> this.stripComment$3((String)s), Buffer$.MODULE$.canBuildFrom())).mkString(" ");
        return CommandLineParser$.MODULE$.tokenize(params);
    }

    private final List expandedArguments$1(String[] args$17) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args$17)).toList().flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            List list;
            String string = x$1;
            String x = string;
            if (x.startsWith("@")) {
                list = this.expandArg$1(x);
            } else {
                String x2 = string;
                list = package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x2}));
            }
            return list;
        }, List$.MODULE$.canBuildFrom());
    }

    private final String format$1(int width$1, String s) {
        return new StringOps(Predef$.MODULE$.augmentString("%-" + width$1 + "s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s}));
    }

    private final String defaultValue$1(Settings.Setting s$9) {
        Object t = s$9.default();
        return t instanceof Integer || t instanceof String ? s$9.default().toString() : "";
    }

    private final String formatSetting$1(int width$3, String name, String value) {
        return new StringOps(Predef$.MODULE$.augmentString(value)).nonEmpty() ? "\n" + this.format$1(width$3, "") + " " + name + ": " + value + "." : "";
    }

    private final String helpStr$1(int width$2, Settings.Setting s) {
        return "" + this.format$1(width$2, s.name()) + " " + s.description() + this.formatSetting$1(width$2, "Default", this.defaultValue$1(s)) + this.formatSetting$1(width$2, "Choices", s.legalChoices());
    }

    private final String availableOptionsMsg$2(Contexts.Context ctx$354, Function1 cond) {
        List ss = (List)((TraversableOnce)ctx$354.settings().allSettings().filter(cond)).toList().sortBy((Function1)(JFunction1 & Serializable)_$180 -> _$180.name(), (Ordering)Ordering.String$.MODULE$);
        int width = BoxesRunTime.unboxToInt((Object)((TraversableOnce)ss.map((Function1)(JFunction1 & Serializable)_$181 -> _$181.name().length(), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        return ((TraversableOnce)ss.map((Function1)(JFunction1 & Serializable)s -> this.helpStr$1(width, (Settings.Setting)s), List$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private final String createUsageMsg$1(Contexts.Context ctx$360, String label, boolean shouldExplain, Function1 cond) {
        String prefix = ((TraversableOnce)package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Some$.MODULE$.apply((Object)this.shortUsage()), Some$.MODULE$.apply((Object)this.explainAdvanced()).filter((Function1)(JFunction1 & Serializable)_$182 -> shouldExplain), Some$.MODULE$.apply((Object)(label + " options include:"))})).flatten((Function1)(JFunction1 & Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).mkString("\n");
        return prefix + "\n" + this.availableOptionsMsg$2(ctx$360, cond);
    }

    private final boolean isStandard$1(Settings.Setting s) {
        return !this.isAdvanced$1(s) && !this.isPrivate$1(s);
    }

    private final boolean isAdvanced$1(Settings.Setting s) {
        return s.name().startsWith("-X");
    }

    private final boolean isPrivate$1(Settings.Setting s) {
        return s.name().startsWith("-Y");
    }

    private final String usageMessage$2(Contexts.Context ctx$361) {
        return this.createUsageMsg$1(ctx$361, "where possible standard", false, (Function1)(JFunction1 & Serializable)s -> this.isStandard$1((Settings.Setting)s));
    }

    private final String xusageMessage$2(Contexts.Context ctx$362) {
        return this.createUsageMsg$1(ctx$362, "Possible advanced", true, (Function1)(JFunction1 & Serializable)s -> this.isAdvanced$1((Settings.Setting)s));
    }

    private final String yusageMessage$2(Contexts.Context ctx$363) {
        return this.createUsageMsg$1(ctx$363, "Possible private", true, (Function1)(JFunction1 & Serializable)s -> this.isPrivate$1((Settings.Setting)s));
    }

    private final boolean shouldStopWithInfo$1(Contexts.Context ctx$355, ScalaSettings settings$1) {
        return ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Settings.Setting[]{settings$1.help(), settings$1.Xhelp(), settings$1.Yhelp(), settings$1.showPlugins()}))).exists((Function1)(JFunction1 & Serializable)_$183 -> {
            Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(_$183);
            return BoxesRunTime.unboxToBoolean(Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx$355));
        });
    }

    private final String infoMessage$1(Contexts.Context ctx$357, ScalaSettings settings$2) {
        Settings.Setting<Object> setting;
        Settings.Setting<Object> setting2;
        Settings.Setting<Object> setting3;
        Settings.Setting<Object> setting4 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.help());
        return BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting4, ctx$357)) ? this.usageMessage$2(ctx$357) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting3 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.Xhelp()), ctx$357)) ? this.xusageMessage$2(ctx$357) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.Yhelp()), ctx$357)) ? this.yusageMessage$2(ctx$357) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting = Settings$Setting$.MODULE$.SettingDecorator(settings$2.showPlugins()), ctx$357)) ? ctx$357.pluginDescriptions() : "")));
    }

    private final Message checkUsage$$anonfun$7$$anonfun$1(String _$184$1) {
        return Message$.MODULE$.toNoExplanation(_$184$1);
    }

    private final Message checkUsage$$anonfun$8$$anonfun$1(String _$185$1) {
        return Message$.MODULE$.toNoExplanation(_$185$1);
    }

    private final String checkUsage$$anonfun$3() {
        return "  dotc -help  gives more information";
    }

    private final String checkUsage$$anonfun$4() {
        return this.versionMsg();
    }

    private final String checkUsage$$anonfun$5(Contexts.Context ctx$364, ScalaSettings settings$3) {
        return this.infoMessage$1(ctx$364, settings$3);
    }

    private final String checkUsage$$anonfun$6(Contexts.Context ctx$365) {
        return this.usageMessage$2(ctx$365);
    }
}

