/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.runtime.function.JFunction1;
import dotty.tools.io.Directory;
import dotty.tools.io.Directory$;
import dotty.tools.io.File;
import dotty.tools.io.Path$;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.package$;
import scala.runtime.Nothing$;

public class Path {
    private final java.nio.file.Path jpath;
    private final char separator;
    private final String separatorStr;

    public static String randomPrefix() {
        return Path$.MODULE$.randomPrefix();
    }

    public static Nothing$ fail(String string) {
        return Path$.MODULE$.fail(string);
    }

    public static List<Directory> onlyDirs(List<Path> list) {
        return Path$.MODULE$.onlyDirs(list);
    }

    public static Iterator<Directory> onlyDirs(Iterator<Path> iterator) {
        return Path$.MODULE$.onlyDirs(iterator);
    }

    public static List roots() {
        return Path$.MODULE$.roots();
    }

    public static Iterator<File> onlyFiles(Iterator<Path> iterator) {
        return Path$.MODULE$.onlyFiles(iterator);
    }

    public static Path apply(java.nio.file.Path path) {
        return Path$.MODULE$.apply(path);
    }

    public static Path apply(String string) {
        return Path$.MODULE$.apply(string);
    }

    public static boolean isExtensionJarOrZip(String string) {
        return Path$.MODULE$.isExtensionJarOrZip(string);
    }

    public static boolean isExtensionJarOrZip(java.nio.file.Path path) {
        return Path$.MODULE$.isExtensionJarOrZip(path);
    }

    public Path(java.nio.file.Path jpath) {
        this.jpath = jpath;
        this.separator = java.io.File.separatorChar;
        this.separatorStr = java.io.File.separator;
    }

    public java.nio.file.Path jpath() {
        return this.jpath;
    }

    public char separator() {
        return this.separator;
    }

    public String separatorStr() {
        return this.separatorStr;
    }

    public File toFile() {
        return new File(this.jpath(), Codec$.MODULE$.fallbackSystemCodec());
    }

    public Directory toDirectory() {
        return new Directory(this.jpath());
    }

    public Path toAbsolute() {
        return this.isAbsolute() ? this : new Path(this.jpath().toAbsolutePath());
    }

    public Path toCanonical() {
        return this.normalize().toAbsolute();
    }

    public URI toURI() {
        return this.jpath().toUri();
    }

    public URL toURL() {
        return this.toURI().toURL();
    }

    public Path toAbsoluteWithRoot(Path root) {
        return this.isAbsolute() ? this : root.toAbsolute().$div(this);
    }

    public Path $div(String child) {
        return new Path(this.jpath().resolve(child));
    }

    public Path $div(Path child) {
        return this.resolve(child);
    }

    public Directory $div(Directory child) {
        return this.$div((Path)child).toDirectory();
    }

    public File $div(File child) {
        return this.$div((Path)child).toFile();
    }

    public Iterator<Path> walkFilter(Function1<Path, Object> cond) {
        return this.isFile() ? this.toFile().walkFilter(cond) : (this.isDirectory() ? this.toDirectory().walkFilter(cond) : package$.MODULE$.Iterator().empty());
    }

    public Iterator<Path> walk() {
        return this.walkFilter((Function1<Path, Object>)(JFunction1 & Serializable)_$1217 -> true);
    }

    public String name() {
        String string;
        java.nio.file.Path path = this.jpath().getFileName();
        if (path == null) {
            string = "";
        } else {
            java.nio.file.Path name = path;
            string = name.toString();
        }
        return string;
    }

    public String path() {
        return this.jpath().toString();
    }

    public Path normalize() {
        return new Path(this.jpath().normalize());
    }

    public Path resolve(Path other) {
        return new Path(this.jpath().resolve(other.jpath()));
    }

    public Path relativize(Path other) {
        return new Path(this.jpath().relativize(other.jpath()));
    }

    public List<String> segments() {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(this.path())).split(this.separator()))).toList().filterNot((Function1)(JFunction1 & Serializable)_$1218 -> _$1218.length() == 0);
    }

    public Directory parent() {
        Directory directory;
        java.nio.file.Path path = this.jpath().normalize().getParent();
        if (path == null) {
            directory = Directory$.MODULE$.apply(this.jpath());
        } else {
            java.nio.file.Path parent = path;
            directory = Directory$.MODULE$.apply(parent);
        }
        return directory;
    }

    public List<Directory> parents() {
        Directory p = this.parent();
        return p.isSame(this) ? package$.MODULE$.Nil() : p.parents().$colon$colon((Object)p);
    }

    public String extension() {
        return Path$.MODULE$.extension(this.name());
    }

    public boolean hasExtension(String ext, Seq<String> exts) {
        String lower = this.extension().toLowerCase();
        String string = ext.toLowerCase();
        String string2 = lower;
        return !(string == null ? string2 != null : !string.equals(string2)) || exts.exists((Function1)(JFunction1 & Serializable)_$1219 -> {
            String string = _$1219.toLowerCase();
            String string2 = lower;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public String stripExtension() {
        return new StringOps(Predef$.MODULE$.augmentString(this.name())).stripSuffix("." + this.extension());
    }

    public Path addExtension(String ext) {
        return new Path(this.jpath().resolveSibling(this.name() + ext));
    }

    public Path changeExtension(String ext) {
        String string = this.extension();
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.addExtension(ext) : new Path(this.jpath().resolveSibling(this.stripExtension() + "." + ext));
    }

    public <T> Option<T> ifFile(Function1<File, T> f) {
        return this.isFile() ? Some$.MODULE$.apply(f.apply((Object)this.toFile())) : None$.MODULE$;
    }

    public <T> Option<T> ifDirectory(Function1<Directory, T> f) {
        return this.isDirectory() ? Some$.MODULE$.apply(f.apply((Object)this.toDirectory())) : None$.MODULE$;
    }

    public boolean canRead() {
        return Files.isReadable(this.jpath());
    }

    public boolean canWrite() {
        return Files.isWritable(this.jpath());
    }

    public boolean exists() {
        boolean bl;
        try {
            bl = Files.exists(this.jpath(), new LinkOption[0]);
        }
        catch (SecurityException ex) {
            bl = false;
        }
        return bl;
    }

    public boolean isFile() {
        boolean bl;
        try {
            bl = Files.isRegularFile(this.jpath(), new LinkOption[0]);
        }
        catch (SecurityException ex) {
            bl = false;
        }
        return bl;
    }

    public boolean isDirectory() {
        boolean bl;
        block3: {
            try {
                bl = Files.isDirectory(this.jpath(), new LinkOption[0]);
            }
            catch (SecurityException ex) {
                String string = this.jpath().toString();
                String string2 = ".";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isAbsolute() {
        return this.jpath().isAbsolute();
    }

    public boolean isEmpty() {
        return this.path().length() == 0;
    }

    public FileTime lastModified() {
        return Files.getLastModifiedTime(this.jpath(), new LinkOption[0]);
    }

    public long length() {
        return Files.size(this.jpath());
    }

    public boolean endsWith(Path other) {
        return this.segments().endsWith(other.segments());
    }

    public boolean isSame(Path other) {
        Path path = this.toCanonical();
        Path path2 = other.toCanonical();
        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
    }

    public boolean isFresher(Path other) {
        return this.lastModified().compareTo(other.lastModified()) > 0;
    }

    public Directory createDirectory(boolean force, boolean failIfExists) {
        boolean res = this.tryCreate(() -> this.$anonfun$1(force));
        if (!res && failIfExists && this.exists()) {
            throw Path$.MODULE$.fail(new StringOps(Predef$.MODULE$.augmentString("Directory '%s' already exists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
        }
        return this.isDirectory() ? this.toDirectory() : new Directory(this.jpath());
    }

    public boolean createDirectory$default$1() {
        return true;
    }

    public boolean createDirectory$default$2() {
        return false;
    }

    public File createFile(boolean failIfExists) {
        boolean res = this.tryCreate(this::$anonfun$2);
        Files.createFile(this.jpath(), new FileAttribute[0]);
        if (!res && failIfExists && this.exists()) {
            throw Path$.MODULE$.fail(new StringOps(Predef$.MODULE$.augmentString("File '%s' already exists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
        }
        return this.isFile() ? this.toFile() : new File(this.jpath(), Codec$.MODULE$.fallbackSystemCodec());
    }

    public boolean createFile$default$1() {
        return false;
    }

    private boolean tryCreate(Function0 create) {
        boolean bl;
        try {
            create.apply();
            bl = true;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            bl = false;
        }
        return bl;
    }

    public void delete() {
        try {
            Files.deleteIfExists(this.jpath());
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {}
    }

    public boolean deleteRecursively() {
        boolean bl;
        if (!this.exists()) {
            bl = false;
        } else {
            Files.walkFileTree(this.jpath(), new SimpleFileVisitor(){

                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean truncate() {
        if (!this.isFile()) return false;
        RandomAccessFile raf = new RandomAccessFile(this.jpath().toFile(), "rw");
        raf.setLength(0L);
        raf.close();
        if (this.length() != 0L) return false;
        return true;
    }

    public String toString() {
        return this.path();
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof Path) {
            Path x = (Path)object;
            String string = this.path();
            String string2 = x.path();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    private final java.nio.file.Path $anonfun$1(boolean force$1) {
        return force$1 ? Files.createDirectories(this.jpath(), new FileAttribute[0]) : Files.createDirectory(this.jpath(), new FileAttribute[0]);
    }

    private final java.nio.file.Path $anonfun$2() {
        return Files.createFile(this.jpath(), new FileAttribute[0]);
    }
}

