/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.DottyPredef$;
import dotty.runtime.function.JFunction1;
import dotty.tools.dotc.core.tasty.TastyBuffer$;
import dotty.tools.dotc.core.tasty.TastyBuffer$Addr$;
import dotty.tools.dotc.core.tasty.TastyBuffer$NameRef$;
import dotty.tools.dotc.util.Util$;
import scala.Byte$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

public class TastyBuffer {
    private byte[] bytes;
    private int length;

    public static int natSize(int n) {
        return TastyBuffer$.MODULE$.natSize(n);
    }

    public static int AddrWidth() {
        return TastyBuffer$.MODULE$.AddrWidth();
    }

    public static int NoAddr() {
        return TastyBuffer$.MODULE$.NoAddr();
    }

    public TastyBuffer(int initialSize) {
        this.bytes = new byte[initialSize];
        this.length = 0;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public void bytes_$eq(byte[] x$1) {
        this.bytes = x$1;
    }

    public int length() {
        return this.length;
    }

    public void length_$eq(int x$1) {
        this.length = x$1;
    }

    public void writeByte(int b) {
        if (this.length() >= this.bytes().length) {
            this.bytes_$eq((byte[])Util$.MODULE$.dble(this.bytes(), ClassTag$.MODULE$.apply(Byte.TYPE)));
        }
        this.bytes()[this.length()] = (byte)b;
        this.length_$eq(this.length() + 1);
    }

    public void writeBytes(byte[] data, int n) {
        while (this.bytes().length < this.length() + n) {
            this.bytes_$eq((byte[])Util$.MODULE$.dble(this.bytes(), ClassTag$.MODULE$.apply(Byte.TYPE)));
        }
        System.arraycopy(data, 0, this.bytes(), this.length(), n);
        this.length_$eq(this.length() + n);
    }

    public void writeNat(int x) {
        this.writeLongNat((long)x & 0xFFFFFFFFL);
    }

    public void writeInt(int x) {
        this.writeLongInt(Int$.MODULE$.int2long(x));
    }

    public void writeLongNat(long x) {
        long y = x >>> 7;
        if (y != 0L) {
            this.writePrefix$1(y);
        }
        this.writeByte((int)(x & 0x7FL | 0x80L));
    }

    public void writeLongInt(long x) {
        long y = x >> 7;
        if (y != 0L - (x >> 6 & 1L)) {
            this.writePrefix$2(y);
        }
        this.writeByte((int)(x & 0x7FL | 0x80L));
    }

    public void writeUncompressedLong(long x) {
        LongRef y = LongRef.create((long)x);
        byte[] bytes = new byte[8];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(7), 0).by(-1).foreach((Function1)(JFunction1.mcVI.sp & java.io.Serializable)i -> {
            long l;
            bytes$1[i] = (byte)(y$2.elem & 0xFFL);
            y$2.elem = l = y$2.elem >>> 8;
        });
        this.writeBytes(bytes, 8);
    }

    public void putNat(int at, int x, int width) {
        int y = x;
        int w = width;
        if (at + w >= this.bytes().length) {
            this.bytes_$eq((byte[])Util$.MODULE$.dble(this.bytes(), ClassTag$.MODULE$.apply(Byte.TYPE)));
        }
        int digit = y & 0x7F | 0x80;
        while (w > 0) {
            this.bytes()[at + --w] = (byte)digit;
            digit = (y >>>= 7) & 0x7F;
        }
        if (y != 0) {
            DottyPredef$.MODULE$.assertFail(() -> TastyBuffer.putNat$$anonfun$1(x, width));
        }
    }

    public int getByte(int at) {
        return Byte$.MODULE$.byte2int(this.bytes()[at]);
    }

    public int getNat(int at) {
        return (int)this.getLongNat(at);
    }

    public long getLongNat(int at) {
        long b = 0L;
        long x = 0L;
        int idx = at;
        do {
            b = Byte$.MODULE$.byte2long(this.bytes()[idx]);
            x = x << 7 | b & 0x7FL;
            ++idx;
        } while ((b & 0x80L) == 0L);
        return x;
    }

    public int getAddr(int at) {
        return TastyBuffer$Addr$.MODULE$.apply(this.getNat(at));
    }

    public final int skipZeroes(int at) {
        TastyBuffer tastyBuffer = this;
        int n = at;
        while (tastyBuffer.getByte(n) == 0) {
            TastyBuffer tastyBuffer2 = tastyBuffer;
            int n2 = TastyBuffer$Addr$.MODULE$.$plus$extension(n, 1);
            tastyBuffer = tastyBuffer2;
            n = n2;
        }
        return n;
    }

    public final int skipNat(int at) {
        int next;
        TastyBuffer tastyBuffer = this;
        int n = at;
        while (true) {
            next = TastyBuffer$Addr$.MODULE$.$plus$extension(n, 1);
            if ((tastyBuffer.getByte(n) & 0x80) != 0) break;
            TastyBuffer tastyBuffer2 = tastyBuffer;
            int n2 = next;
            tastyBuffer = tastyBuffer2;
            n = n2;
        }
        return next;
    }

    public int currentAddr() {
        return TastyBuffer$Addr$.MODULE$.apply(this.length());
    }

    /*
     * WARNING - void declaration
     */
    public int reserveAddr() {
        void var1_1;
        int result = this.currentAddr();
        this.length_$eq(this.length() + 4);
        return (int)var1_1;
    }

    public void fillAddr(int at, int target) {
        this.putNat(at, target, 4);
    }

    public void writeAddr(int addr) {
        this.writeNat(addr);
    }

    public void assemble() {
    }

    private final void writePrefix$1(long x) {
        long y = x >>> 7;
        if (y != 0L) {
            this.writePrefix$1(y);
        }
        this.writeByte((int)(x & 0x7FL));
    }

    private final void writePrefix$2(long x) {
        long y = x >> 7;
        if (y != 0L - (x >> 6 & 1L)) {
            this.writePrefix$2(y);
        }
        this.writeByte((int)(x & 0x7FL));
    }

    private static final String putNat$$anonfun$1(int x$321, int width$5) {
        return "number " + x$321 + " too large to fit in " + width$5 + " bytes";
    }

    public static final class Addr
    implements Product,
    Serializable {
        private final int index;

        public static int relativeTo$extension(int n, int n2) {
            return TastyBuffer$Addr$.MODULE$.relativeTo$extension(n, n2);
        }

        public static int $minus$extension(int n, int n2) {
            return TastyBuffer$Addr$.MODULE$.$minus$extension(n, n2);
        }

        public static boolean canEqual$extension(int n, Object object) {
            return TastyBuffer$Addr$.MODULE$.canEqual$extension(n, object);
        }

        public static boolean $bang$eq$extension(int n, int n2) {
            return TastyBuffer$Addr$.MODULE$.$bang$eq$extension(n, n2);
        }

        public static int unapply(int n) {
            return TastyBuffer$Addr$.MODULE$.unapply(n);
        }

        public static Object productElement$extension(int n, int n2) {
            return TastyBuffer$Addr$.MODULE$.productElement$extension(n, n2);
        }

        public static int productArity$extension(int n) {
            return TastyBuffer$Addr$.MODULE$.productArity$extension(n);
        }

        public static boolean $eq$eq$extension(int n, int n2) {
            return TastyBuffer$Addr$.MODULE$.$eq$eq$extension(n, n2);
        }

        public static int hashCode$extension(int n) {
            return TastyBuffer$Addr$.MODULE$.hashCode$extension(n);
        }

        public static int $plus$extension(int n, int n2) {
            return TastyBuffer$Addr$.MODULE$.$plus$extension(n, n2);
        }

        public static int copy$extension(int n, int n2) {
            return TastyBuffer$Addr$.MODULE$.copy$extension(n, n2);
        }

        public static String productElementName$extension(int n, int n2) {
            return TastyBuffer$Addr$.MODULE$.productElementName$extension(n, n2);
        }

        public static int copy$default$1$extension(int n) {
            return TastyBuffer$Addr$.MODULE$.copy$default$1$extension(n);
        }

        public static String toString$extension(int n) {
            return TastyBuffer$Addr$.MODULE$.toString$extension(n);
        }

        public static <A> Function1<Object, A> andThen(Function1<Addr, A> function1) {
            return TastyBuffer$Addr$.MODULE$.andThen(function1);
        }

        public static int _1$extension(int n) {
            return TastyBuffer$Addr$.MODULE$._1$extension(n);
        }

        public static String productPrefix$extension(int n) {
            return TastyBuffer$Addr$.MODULE$.productPrefix$extension(n);
        }

        public static int apply(int n) {
            return TastyBuffer$Addr$.MODULE$.apply(n);
        }

        public static <A> Function1<A, Addr> compose(Function1<A, Object> function1) {
            return TastyBuffer$Addr$.MODULE$.compose(function1);
        }

        public static boolean equals$extension(int n, Object object) {
            return TastyBuffer$Addr$.MODULE$.equals$extension(n, object);
        }

        public Addr(int index) {
            this.index = index;
        }

        public int hashCode() {
            return TastyBuffer$Addr$.MODULE$.hashCode$extension(this.index());
        }

        public boolean equals(Object x$0) {
            return TastyBuffer$Addr$.MODULE$.equals$extension(this.index(), x$0);
        }

        public String toString() {
            return TastyBuffer$Addr$.MODULE$.toString$extension(this.index());
        }

        public boolean canEqual(Object that) {
            return TastyBuffer$Addr$.MODULE$.canEqual$extension(this.index(), that);
        }

        public int productArity() {
            return TastyBuffer$Addr$.MODULE$.productArity$extension(this.index());
        }

        public String productPrefix() {
            return TastyBuffer$Addr$.MODULE$.productPrefix$extension(this.index());
        }

        public Object productElement(int n) {
            return TastyBuffer$Addr$.MODULE$.productElement$extension(this.index(), n);
        }

        public int index() {
            return this.index;
        }

        public int $minus(int delta) {
            return TastyBuffer$Addr$.MODULE$.$minus$extension(this.index(), delta);
        }

        public int $plus(int delta) {
            return TastyBuffer$Addr$.MODULE$.$plus$extension(this.index(), delta);
        }

        public int relativeTo(int base) {
            return TastyBuffer$Addr$.MODULE$.relativeTo$extension(this.index(), base);
        }

        public boolean $eq$eq(int that) {
            return TastyBuffer$Addr$.MODULE$.$eq$eq$extension(this.index(), that);
        }

        public boolean $bang$eq(int that) {
            return TastyBuffer$Addr$.MODULE$.$bang$eq$extension(this.index(), that);
        }

        public String productElementName(int x$1) {
            return TastyBuffer$Addr$.MODULE$.productElementName$extension(this.index(), x$1);
        }

        public int copy(int index) {
            return TastyBuffer$Addr$.MODULE$.copy$extension(this.index(), index);
        }

        public int copy$default$1() {
            return TastyBuffer$Addr$.MODULE$.copy$default$1$extension(this.index());
        }

        public int _1() {
            return TastyBuffer$Addr$.MODULE$._1$extension(this.index());
        }
    }

    public static final class NameRef
    implements Product,
    Serializable {
        private final int index;

        public static boolean canEqual$extension(int n, Object object) {
            return TastyBuffer$NameRef$.MODULE$.canEqual$extension(n, object);
        }

        public static int unapply(int n) {
            return TastyBuffer$NameRef$.MODULE$.unapply(n);
        }

        public static Object productElement$extension(int n, int n2) {
            return TastyBuffer$NameRef$.MODULE$.productElement$extension(n, n2);
        }

        public static int productArity$extension(int n) {
            return TastyBuffer$NameRef$.MODULE$.productArity$extension(n);
        }

        public static int hashCode$extension(int n) {
            return TastyBuffer$NameRef$.MODULE$.hashCode$extension(n);
        }

        public static int copy$extension(int n, int n2) {
            return TastyBuffer$NameRef$.MODULE$.copy$extension(n, n2);
        }

        public static String productElementName$extension(int n, int n2) {
            return TastyBuffer$NameRef$.MODULE$.productElementName$extension(n, n2);
        }

        public static int copy$default$1$extension(int n) {
            return TastyBuffer$NameRef$.MODULE$.copy$default$1$extension(n);
        }

        public static String toString$extension(int n) {
            return TastyBuffer$NameRef$.MODULE$.toString$extension(n);
        }

        public static <A> Function1<Object, A> andThen(Function1<NameRef, A> function1) {
            return TastyBuffer$NameRef$.MODULE$.andThen(function1);
        }

        public static int _1$extension(int n) {
            return TastyBuffer$NameRef$.MODULE$._1$extension(n);
        }

        public static String productPrefix$extension(int n) {
            return TastyBuffer$NameRef$.MODULE$.productPrefix$extension(n);
        }

        public static int apply(int n) {
            return TastyBuffer$NameRef$.MODULE$.apply(n);
        }

        public static <A> Function1<A, NameRef> compose(Function1<A, Object> function1) {
            return TastyBuffer$NameRef$.MODULE$.compose(function1);
        }

        public static boolean equals$extension(int n, Object object) {
            return TastyBuffer$NameRef$.MODULE$.equals$extension(n, object);
        }

        public NameRef(int index) {
            this.index = index;
        }

        public int hashCode() {
            return TastyBuffer$NameRef$.MODULE$.hashCode$extension(this.index());
        }

        public boolean equals(Object x$0) {
            return TastyBuffer$NameRef$.MODULE$.equals$extension(this.index(), x$0);
        }

        public String toString() {
            return TastyBuffer$NameRef$.MODULE$.toString$extension(this.index());
        }

        public boolean canEqual(Object that) {
            return TastyBuffer$NameRef$.MODULE$.canEqual$extension(this.index(), that);
        }

        public int productArity() {
            return TastyBuffer$NameRef$.MODULE$.productArity$extension(this.index());
        }

        public String productPrefix() {
            return TastyBuffer$NameRef$.MODULE$.productPrefix$extension(this.index());
        }

        public Object productElement(int n) {
            return TastyBuffer$NameRef$.MODULE$.productElement$extension(this.index(), n);
        }

        public int index() {
            return this.index;
        }

        public String productElementName(int x$1) {
            return TastyBuffer$NameRef$.MODULE$.productElementName$extension(this.index(), x$1);
        }

        public int copy(int index) {
            return TastyBuffer$NameRef$.MODULE$.copy$extension(this.index(), index);
        }

        public int copy$default$1() {
            return TastyBuffer$NameRef$.MODULE$.copy$default$1$extension(this.index());
        }

        public int _1() {
            return TastyBuffer$NameRef$.MODULE$._1$extension(this.index());
        }
    }
}

