/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.runtime.LazyVals$;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import dotty.tools.io.Directory;
import dotty.tools.io.File;
import dotty.tools.io.File$;
import dotty.tools.io.Jar$;
import dotty.tools.io.Jar$WManifest$;
import dotty.tools.io.JarWriter;
import dotty.tools.io.Path;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.package$;
import scala.util.Properties$;

public class Jar
implements Iterable<JarEntry> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(Jar.class, "bitmap$0");
    public long bitmap$0;
    private final File file;
    public JarFile jarFile$lzy1;
    public Option manifest$lzy1;

    public static void create(File file, Directory directory, String string) {
        Jar$.MODULE$.create(file, directory, string);
    }

    public static WManifest WManifest(Manifest manifest) {
        return Jar$.MODULE$.WManifest(manifest);
    }

    public static boolean isJarOrZip(Path path, boolean bl) {
        return Jar$.MODULE$.isJarOrZip(path, bl);
    }

    public static boolean isJarOrZip(Path path) {
        return Jar$.MODULE$.isJarOrZip(path);
    }

    public Jar(File file) {
        this.file = file;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Parallelizable.$init$((Parallelizable)this);
        TraversableLike.$init$((TraversableLike)this);
        GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
        GenTraversable.$init$((GenTraversable)this);
        Traversable.$init$((Traversable)this);
        GenIterable.$init$((GenIterable)this);
        IterableLike.$init$((IterableLike)this);
        Iterable.$init$((Iterable)this);
    }

    public Jar(java.io.File jfile) {
        this(File$.MODULE$.apply(jfile.toPath(), Codec$.MODULE$.fallbackSystemCodec()));
    }

    public Jar(String path) {
        this(File$.MODULE$.apply(path, Codec$.MODULE$.fallbackSystemCodec()));
    }

    public void errorFn(String msg) {
        Console$.MODULE$.println((Object)msg);
    }

    public JarFile jarFile() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    JarFile jarFile;
                    this.jarFile$lzy1 = jarFile = new JarFile(this.file.jpath().toFile());
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return jarFile;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.jarFile$lzy1;
    }

    public Option<Manifest> manifest() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    Option option;
                    this.manifest$lzy1 = option = (Option)this.withJarInput((Function1)(JFunction1 & Serializable)s -> Option$.MODULE$.apply((Object)s.getManifest()));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return option;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.manifest$lzy1;
    }

    public Option<String> mainClass() {
        return this.manifest().map((Function1)(JFunction1 & Serializable)f -> Jar$.MODULE$.WManifest((Manifest)f).apply(Attributes.Name.MAIN_CLASS));
    }

    public Option<String> classPathString() {
        return this.manifest().flatMap((Function1)(JFunction1 & Serializable)m -> Jar$.MODULE$.WManifest((Manifest)m).attrs().get((Object)Attributes.Name.CLASS_PATH).map((Function1)(JFunction1 & Serializable)cp -> cp));
    }

    public List<String> classPathElements() {
        Nil$ nil$;
        Option<String> option = this.classPathString();
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            nil$ = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split("\\s+"))).toList();
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    public <T> T withJarInput(Function1<JarInputStream, T> f) {
        Object object;
        try (JarInputStream in = new JarInputStream(this.file.inputStream());){
            object = f.apply((Object)in);
        }
        return (T)object;
    }

    public JarWriter jarWriter(Seq<Tuple2<Attributes.Name, String>> mainAttrs) {
        return new JarWriter(this.file, Jar$WManifest$.MODULE$.apply(mainAttrs).underlying());
    }

    public <U> void foreach(Function1<JarEntry, U> f) {
        this.withJarInput((Function1)(JProcedure1 & Serializable)in -> package$.MODULE$.Iterator().continually(() -> Jar.foreach$$anonfun$2$$anonfun$1(in)).takeWhile((Function1)(JFunction1 & Serializable)_$1217 -> _$1217 != null).foreach(f));
    }

    public Iterator<JarEntry> iterator() {
        return this.toList().iterator();
    }

    public InputStream getEntryStream(JarEntry entry) {
        InputStream inputStream;
        InputStream inputStream2 = this.jarFile().getInputStream(entry);
        if (inputStream2 == null) {
            this.errorFn("No such entry: " + entry);
            inputStream = null;
        } else {
            InputStream x;
            inputStream = x = inputStream2;
        }
        return inputStream;
    }

    public String toString() {
        return String.valueOf(this.file);
    }

    private static final JarEntry foreach$$anonfun$2$$anonfun$1(JarInputStream in$11) {
        return in$11.getNextJarEntry();
    }

    public static class WManifest {
        private final Manifest manifest;

        public WManifest(Manifest manifest) {
            this.manifest = manifest;
            this.initialMainAttrs().withFilter((Function1)(JFunction1 & Serializable)x$1 -> {
                boolean bl;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Attributes.Name k = (Attributes.Name)tuple2._1();
                    String v = (String)tuple2._2();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }).foreach((Function1)(JFunction1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Attributes.Name k = (Attributes.Name)tuple2._1();
                String v = (String)tuple2._2();
                return this.update(k, v);
            });
        }

        public Manifest manifest() {
            return this.manifest;
        }

        public Manifest underlying() {
            return this.manifest();
        }

        public scala.collection.mutable.Map<Attributes.Name, String> attrs() {
            return ((scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.manifest().getMainAttributes()).asScala()).withDefaultValue(null);
        }

        public scala.collection.immutable.Map<Attributes.Name, String> initialMainAttrs() {
            Object[] objectArray = new Tuple2[2];
            Object object = Predef$.MODULE$.ArrowAssoc((Object)Attributes.Name.MANIFEST_VERSION);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)"1.0");
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)Properties$.MODULE$.ScalaCompilerVersion());
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, (Object)Properties$.MODULE$.versionNumberString());
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray(objectArray));
        }

        public String apply(Attributes.Name name) {
            return (String)this.attrs().apply((Object)name);
        }

        public String apply(String name) {
            return this.apply(new Attributes.Name(name));
        }

        public Option<String> update(Attributes.Name key, String value) {
            return this.attrs().put((Object)key, (Object)value);
        }

        public Option<String> update(String key, String value) {
            return this.attrs().put((Object)new Attributes.Name(key), (Object)value);
        }

        public String mainClass() {
            return this.apply(Attributes.Name.MAIN_CLASS);
        }

        public Option<String> mainClass_$eq(String value) {
            return this.update(Attributes.Name.MAIN_CLASS, value);
        }
    }
}

