/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.DottyPredef$;
import dotty.runtime.function.JProcedure1;
import dotty.tools.dotc.util.HashSet$;
import dotty.tools.dotc.util.Set;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class HashSet<T>
extends Set<T> {
    private final int powerOfTwoInitialCapacity;
    private final float loadFactor;
    private int used;
    private int limit;
    public Object[] dotty$tools$dotc$util$HashSet$$table;
    private int accesses;
    private int misses;
    private int rover;

    public static float $lessinit$greater$default$2() {
        return HashSet$.MODULE$.$lessinit$greater$default$2();
    }

    public <T> HashSet(int powerOfTwoInitialCapacity, float loadFactor) {
        this.powerOfTwoInitialCapacity = powerOfTwoInitialCapacity;
        this.loadFactor = loadFactor;
        if (Integer.bitCount(powerOfTwoInitialCapacity) != 1) {
            DottyPredef$.MODULE$.assertFail();
        }
        this.accesses = 0;
        this.misses = 0;
        this.clear();
        this.rover = -1;
    }

    public boolean isEqual(T x, T y) {
        return x.equals(y);
    }

    public int accesses() {
        return this.accesses;
    }

    public void accesses_$eq(int x$1) {
        this.accesses = x$1;
    }

    public int misses() {
        return this.misses;
    }

    public void misses_$eq(int x$1) {
        this.misses = x$1;
    }

    public int size() {
        return this.used;
    }

    private void allocate(int size) {
        this.dotty$tools$dotc$util$HashSet$$table = new Object[size];
        this.limit = (int)((float)size * this.loadFactor);
    }

    @Override
    public void clear() {
        this.used = 0;
        this.allocate(this.powerOfTwoInitialCapacity);
    }

    private int index(int x) {
        return x & this.dotty$tools$dotc$util$HashSet$$table.length - 1;
    }

    public int hash(T x) {
        return x.hashCode();
    }

    private T entryAt(int idx) {
        return (T)this.dotty$tools$dotc$util$HashSet$$table[idx];
    }

    public T findEntryOrUpdate(T x) {
        int h = this.index(this.hash(x));
        T entry = this.entryAt(h);
        while (entry != null) {
            if (this.isEqual(x, entry)) {
                return entry;
            }
            h = this.index(h + 1);
            entry = this.entryAt(h);
        }
        return this.addEntryAt(h, x);
    }

    private T addEntryAt(int idx, T x) {
        this.dotty$tools$dotc$util$HashSet$$table[idx] = x;
        ++this.used;
        if (this.used > this.limit) {
            this.growTable();
        }
        return x;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T findEntry(T x) {
        void var3_3;
        int h = this.index(this.hash(x));
        T entry = this.entryAt(h);
        while (entry != null && !this.isEqual(x, entry)) {
            h = this.index(h + 1);
            entry = this.entryAt(h);
        }
        return var3_3;
    }

    @Override
    public void addEntry(T x) {
        int h = this.index(this.hash(x));
        T entry = this.entryAt(h);
        while (entry != null) {
            if (this.isEqual(x, entry)) {
                return;
            }
            h = this.index(h + 1);
            entry = this.entryAt(h);
        }
        this.dotty$tools$dotc$util$HashSet$$table[h] = x;
        ++this.used;
        if (this.used > this.dotty$tools$dotc$util$HashSet$$table.length >> 2) {
            this.growTable();
        }
    }

    public void addEntries(IterableOnce<T> xs) {
        xs.iterator().foreach((Function1)(JProcedure1 & Serializable)x -> this.addEntry(x));
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator(this){
            private int i;
            private final HashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.i = 0;
            }

            public boolean hasNext() {
                while (this.i < this.dotty$tools$dotc$util$HashSet$_$$anon$$$outer().dotty$tools$dotc$util$HashSet$$table.length && this.dotty$tools$dotc$util$HashSet$_$$anon$$$outer().dotty$tools$dotc$util$HashSet$$table[this.i] == null) {
                    ++this.i;
                }
                return this.i < this.dotty$tools$dotc$util$HashSet$_$$anon$$$outer().dotty$tools$dotc$util$HashSet$$table.length;
            }

            public Object next() {
                Object object;
                if (this.hasNext()) {
                    ++this.i;
                    object = this.dotty$tools$dotc$util$HashSet$_$$anon$$$outer().dotty$tools$dotc$util$HashSet$$table[this.i - 1];
                } else {
                    object = null;
                }
                return object;
            }

            private HashSet $outer() {
                return this.$outer;
            }

            public final HashSet dotty$tools$dotc$util$HashSet$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    public T findEntryByHash(int hashCode) {
        this.rover = this.index(hashCode);
        return this.nextEntryByHash(hashCode);
    }

    public T nextEntryByHash(int hashCode) {
        Object entry = this.dotty$tools$dotc$util$HashSet$$table[this.rover];
        while (entry != null) {
            this.rover = this.index(this.rover + 1);
            if (this.hash(entry) == hashCode) {
                return (T)entry;
            }
            entry = this.dotty$tools$dotc$util$HashSet$$table[this.rover];
        }
        return null;
    }

    public T addEntryAfterScan(T x) {
        return this.addEntryAt(this.rover, x);
    }

    private void addOldEntry(T x) {
        int h = this.index(this.hash(x));
        T entry = this.entryAt(h);
        while (entry != null) {
            h = this.index(h + 1);
            entry = this.entryAt(h);
        }
        this.dotty$tools$dotc$util$HashSet$$table[h] = x;
    }

    private void growTable() {
        Object[] oldtable = this.dotty$tools$dotc$util$HashSet$$table;
        this.allocate(this.dotty$tools$dotc$util$HashSet$$table.length * 2);
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            if (entry == null) continue;
            this.addOldEntry(entry);
        }
    }

    public String toString() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("HashSet(%d / %d)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.used), BoxesRunTime.boxToInteger((int)this.dotty$tools$dotc$util$HashSet$$table.length)}));
    }
}

