/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.DottyPredef$;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JFunction2;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$StringInterpolators$;
import dotty.tools.dotc.printing.Highlighting$Blue$;
import dotty.tools.dotc.printing.Highlighting$Red$;
import dotty.tools.dotc.printing.Highlighting$Yellow$;
import dotty.tools.dotc.printing.SyntaxHighlighting$;
import dotty.tools.dotc.reporting.diagnostic.ErrorMessageID;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.reporting.diagnostic.messages;
import dotty.tools.dotc.util.SourcePosition;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public interface MessageRendering {
    default public String stripColor(String str) {
        return str.replaceAll("\u001b\\[.*?m", "");
    }

    default public List<String> outer(SourcePosition pos, String prefix, Contexts.Context ctx) {
        Nil$ nil$;
        if (pos.outer().exists()) {
            String string = Decorators$StringInterpolators$.MODULE$.i$extension(Decorators$.MODULE$.StringInterpolators(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "| This location is in code that was inlined at ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{prefix, pos.outer()}), ctx);
            nil$ = this.outer(pos.outer(), prefix, ctx).$colon$colon((Object)string);
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    default public Tuple3<List<String>, List<String>, Object> sourceLines(SourcePosition pos, String diagnosticLevel, Contexts.Context ctx) {
        if (!pos.exists() || !pos.source().file().exists()) {
            DottyPredef$.MODULE$.assertFail();
        }
        IntRef maxLen = IntRef.create((int)Integer.MIN_VALUE);
        Settings.Setting<String> setting = Settings$Setting$.MODULE$.SettingDecorator(ctx.settings().color());
        String string = Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx);
        String string2 = "never";
        char[] syntax = (string == null ? string2 != null : !string.equals(string2)) ? SyntaxHighlighting$.MODULE$.highlight(new String(pos.linesSlice()), ctx).toCharArray() : pos.linesSlice();
        List lines = MessageRendering.linesFrom$1(syntax);
        Tuple2<List<Object>, List<Object>> tuple2 = pos.beforeAndAfterPoint();
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<List<Object>, List<Object>> tuple22 = tuple2;
        List before = (List)tuple22._1();
        List after = (List)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)before, (Object)after);
        List before2 = (List)tuple23._1();
        List after2 = (List)tuple23._2();
        return Tuple3$.MODULE$.apply((Object)((List)before2.zip((IterableOnce)lines)).map((Function1)(JFunction1 & Serializable)offsetAndLine -> this.render$1(pos, diagnosticLevel, ctx, maxLen, (Tuple2)offsetAndLine)), (Object)((List)after2.zip((IterableOnce)lines.drop(before2.length()))).map((Function1)(JFunction1 & Serializable)offsetAndLine -> this.render$1(pos, diagnosticLevel, ctx, maxLen, (Tuple2)offsetAndLine)), (Object)BoxesRunTime.boxToInteger((int)maxLen.elem));
    }

    default public String columnMarker(SourcePosition pos, int offset, String diagnosticLevel, Contexts.Context ctx) {
        String prefix = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), offset - 1);
        String padding = pos.startColumnPadding();
        String carets = this.hl(diagnosticLevel, pos.startLine() == pos.endLine() ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("^"), scala.math.package$.MODULE$.max(1, pos.endColumn() - pos.startColumn())) : "^", ctx);
        return "" + prefix + "|" + padding + carets;
    }

    default public String errorMsg(SourcePosition pos, String msg, int offset, Contexts.Context ctx) {
        String padding = (String)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(msg)).foldLeft((Object)pos.startColumnPadding(), (Function2)(JFunction2 & Serializable)(pad, line) -> {
            int lineLength = this.stripColor((String)line).length();
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(ctx.settings().pageWidth());
            int maxPad = scala.math.package$.MODULE$.max(0, BoxesRunTime.unboxToInt((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx)) - offset - lineLength) - offset;
            return maxPad < pad.length() ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxPad) : pad;
        });
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(msg)).map((Function1)(JFunction1 & Serializable)line -> StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), offset - 1) + "|" + padding + line).mkString(System.lineSeparator());
    }

    default public String posStr(SourcePosition pos, String diagnosticLevel, Message message, Contexts.Context ctx) {
        String string;
        if (pos.exists()) {
            String string2;
            String file;
            String string3 = file = pos.source().file().exists() ? "" + pos.source().file().toString() + ":" + (pos.line() + 1) + ":" + pos.column() : "" + pos.source().file().toString() + ": offset " + pos.start() + " (missing source file)";
            if (message.errorId() != ErrorMessageID.NoExplanationID) {
                int errorNumber = message.errorId().errorNumber();
                string2 = "[E" + (StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 3 - ((Object)BoxesRunTime.boxToInteger((int)errorNumber)).toString().length()) + errorNumber) + "] ";
            } else {
                string2 = "";
            }
            String errId = string2;
            String string4 = message.kind();
            String string5 = "";
            String kind = !(string4 != null ? !string4.equals(string5) : string5 != null) ? diagnosticLevel : "" + message.kind() + " " + diagnosticLevel;
            String prefix = "-- " + errId + kind + ": " + file + " ";
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(ctx.settings().pageWidth());
            string = this.hl(diagnosticLevel, prefix + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), scala.math.package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx)) - this.stripColor(prefix).length(), 0)), ctx);
        } else {
            string = "";
        }
        return string;
    }

    default public String explanation(Message m, Contexts.Context ctx) {
        StringBuilder sb = new StringBuilder(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|\n          |" + Highlighting$Blue$.MODULE$.apply("Explanation").show(ctx) + "\n          |" + Highlighting$Blue$.MODULE$.apply("===========").show(ctx))));
        sb.append(System.lineSeparator()).append(m.explanation());
        Option option = StringOps$.MODULE$.lastOption$extension(Predef$.MODULE$.augmentString(m.explanation()));
        Some some = Some$.MODULE$.apply((Object)System.lineSeparator());
        if (option == null ? some != null : !option.equals(some)) {
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    default public String messageAndPos(Message msg, SourcePosition pos, String diagnosticLevel, Contexts.Context ctx) {
        StringBuilder stringBuilder;
        StringBuilder sb = new StringBuilder();
        String posString = this.posStr(pos, diagnosticLevel, msg, ctx);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(posString))) {
            sb.append(posString).append(System.lineSeparator());
        }
        if (pos.exists() && pos.source().file().exists()) {
            Tuple3<List<String>, List<String>, Object> tuple3 = this.sourceLines(pos, diagnosticLevel, ctx);
            if (!(tuple3 instanceof Tuple3)) {
                throw new MatchError(tuple3);
            }
            Tuple3<List<String>, List<String>, Object> tuple32 = tuple3;
            List srcBefore = (List)tuple32._1();
            List srcAfter = (List)tuple32._2();
            int offset = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Tuple3 tuple33 = Tuple3$.MODULE$.apply((Object)srcBefore, (Object)srcAfter, (Object)BoxesRunTime.boxToInteger((int)offset));
            List srcBefore2 = (List)tuple33._1();
            List srcAfter2 = (List)tuple33._2();
            int offset2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
            String marker = this.columnMarker(pos, offset2, diagnosticLevel, ctx);
            String err = this.errorMsg(pos, msg.msg(), offset2, ctx);
            List<String> list = this.outer(pos, StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), offset2 - 1), ctx);
            stringBuilder = sb.append(srcAfter2.$colon$colon$colon(list).$colon$colon((Object)err).$colon$colon((Object)marker).$colon$colon$colon(srcBefore2).mkString(System.lineSeparator()));
        } else {
            stringBuilder = sb.append(msg.msg());
        }
        return sb.toString();
    }

    default public String hl(String diagnosticLevel, String str, Contexts.Context ctx) {
        String string;
        String string2 = diagnosticLevel;
        if ("Info".equals(string2)) {
            string = Highlighting$Blue$.MODULE$.apply(str).show(ctx);
        } else if ("Error".equals(string2)) {
            string = Highlighting$Red$.MODULE$.apply(str).show(ctx);
        } else {
            if (!diagnosticLevel.contains("Warning")) {
                DottyPredef$.MODULE$.assertFail();
            }
            string = Highlighting$Yellow$.MODULE$.apply(str).show(ctx);
        }
        return string;
    }

    default public String diagnosticLevel(MessageContainer cont) {
        String string;
        MessageContainer messageContainer = cont;
        if (messageContainer instanceof messages.Error) {
            messages.Error m = (messages.Error)messageContainer;
            string = "Error";
        } else if (messageContainer instanceof messages.FeatureWarning) {
            messages.FeatureWarning m = (messages.FeatureWarning)messageContainer;
            string = "Feature Warning";
        } else if (messageContainer instanceof messages.DeprecationWarning) {
            messages.DeprecationWarning m = (messages.DeprecationWarning)messageContainer;
            string = "Deprecation Warning";
        } else if (messageContainer instanceof messages.UncheckedWarning) {
            messages.UncheckedWarning m = (messages.UncheckedWarning)messageContainer;
            string = "Unchecked Warning";
        } else if (messageContainer instanceof messages.MigrationWarning) {
            messages.MigrationWarning m = (messages.MigrationWarning)messageContainer;
            string = "Migration Warning";
        } else if (messageContainer instanceof messages.Warning) {
            messages.Warning m = (messages.Warning)messageContainer;
            string = "Warning";
        } else if (messageContainer instanceof messages.Info) {
            messages.Info m = (messages.Info)messageContainer;
            string = "Info";
        } else {
            throw new MatchError((Object)messageContainer);
        }
        return string;
    }

    private String render$1(SourcePosition pos$53, String diagnosticLevel$1, Contexts.Context ctx$1216, IntRef maxLen$2, Tuple2 offsetAndLine) {
        int n;
        Tuple2 tuple2 = offsetAndLine;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int offset = BoxesRunTime.unboxToInt((Object)tuple2._1());
        String line = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)offset), (Object)line);
        int offset2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        String line2 = (String)tuple22._2();
        int lineNbr = pos$53.source().offsetToLine(offset2);
        String prefix = "" + (lineNbr + 1) + " |";
        maxLen$2.elem = n = scala.math.package$.MODULE$.max(maxLen$2.elem, prefix.length());
        String lnum = this.hl(diagnosticLevel$1, StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), scala.math.package$.MODULE$.max(0, maxLen$2.elem - prefix.length())) + prefix, ctx$1216);
        return lnum + StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(line2));
    }

    private static boolean pred$1(char c) {
        boolean bl;
        char c2 = c;
        switch (c2) {
            case '\n': 
            case '\f': 
            case '\r': 
            case '\u001a': {
                bl = true;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    private static /* synthetic */ boolean $anonfun$2(char _$649) {
        return !MessageRendering.pred$1(_$649);
    }

    private static boolean $anonfun$adapted$1(Object _$649) {
        return MessageRendering.$anonfun$2(BoxesRunTime.unboxToChar((Object)_$649));
    }

    private static boolean $anonfun$adapted$2(Object c) {
        return MessageRendering.pred$1(BoxesRunTime.unboxToChar((Object)c));
    }

    private static List linesFrom$1(char[] arr) {
        Object object = Predef$.MODULE$.charArrayOps(arr);
        Tuple2 tuple2 = ArrayOps$.MODULE$.span$extension(object, (Function1)((JFunction1 & Serializable)MessageRendering::$anonfun$adapted$1));
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple22 = tuple2;
        char[] line = (char[])tuple22._1();
        char[] rest0 = (char[])tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)line, (Object)rest0);
        char[] line2 = (char[])tuple23._1();
        char[] rest02 = (char[])tuple23._2();
        Object object2 = Predef$.MODULE$.charArrayOps(rest02);
        Tuple2 tuple24 = ArrayOps$.MODULE$.span$extension(object2, (Function1)((JFunction1 & Serializable)MessageRendering::$anonfun$adapted$2));
        if (!(tuple24 instanceof Tuple2)) {
            throw new MatchError((Object)tuple24);
        }
        char[] rest = (char[])tuple24._2();
        char[] rest2 = rest;
        String string = new String(line2);
        Object object3 = Predef$.MODULE$.charArrayOps(rest2);
        return (ArrayOps$.MODULE$.isEmpty$extension(object3) ? package$.MODULE$.Nil() : MessageRendering.linesFrom$1(rest2)).$colon$colon((Object)string);
    }
}

