/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.runtime.function.JFunction1;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.VirtualDirectory$;
import dotty.tools.io.VirtualFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.sys.package$;

public class VirtualDirectory
extends AbstractFile {
    private final String name;
    private final Option<VirtualDirectory> maybeContainer;
    private final long lastModified;
    private final Map files;

    public static None$ $lessinit$greater$default$2() {
        return VirtualDirectory$.MODULE$.$lessinit$greater$default$2();
    }

    public VirtualDirectory(String name, Option<VirtualDirectory> maybeContainer) {
        this.name = name;
        this.maybeContainer = maybeContainer;
        this.lastModified = System.currentTimeMillis();
        this.files = (Map)Map$.MODULE$.empty();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String path() {
        String string;
        Option<VirtualDirectory> option = this.maybeContainer;
        if (None$.MODULE$.equals(option)) {
            string = this.name();
        } else if (option instanceof Some) {
            VirtualDirectory parent = (VirtualDirectory)((Some)option).value();
            string = parent.path() + '/' + this.name();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    @Override
    public AbstractFile absolute() {
        return this;
    }

    @Override
    public VirtualDirectory container() {
        return (VirtualDirectory)this.maybeContainer.get();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public Path jpath() {
        return null;
    }

    @Override
    public InputStream input() {
        throw package$.MODULE$.error("directories cannot be read");
    }

    @Override
    public OutputStream output() {
        throw package$.MODULE$.error("directories cannot be written");
    }

    @Override
    public void create() {
        throw this.unsupported();
    }

    @Override
    public void delete() {
        throw this.unsupported();
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        throw this.unsupported();
    }

    private Map<String, AbstractFile> files() {
        return this.files;
    }

    @Override
    public Iterator<AbstractFile> iterator() {
        return this.files().values().toList().iterator();
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        return (AbstractFile)this.files().get((Object)name).filter((Function1)(JFunction1 & Serializable)_$1243 -> _$1243.isDirectory() == directory).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public AbstractFile fileNamed(String name) {
        return (AbstractFile)Option$.MODULE$.apply((Object)this.lookupName(name, false)).getOrElse(() -> this.fileNamed$$anonfun$1(name));
    }

    @Override
    public AbstractFile subdirectoryNamed(String name) {
        return (AbstractFile)Option$.MODULE$.apply((Object)this.lookupName(name, true)).getOrElse(() -> this.subdirectoryNamed$$anonfun$1(name));
    }

    public void clear() {
        this.files().clear();
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile fileNamed$$anonfun$1(String name$213) {
        void var2_2;
        VirtualFile newFile = new VirtualFile(name$213, this.path() + '/' + name$213);
        this.files().update((Object)name$213, (Object)newFile);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualDirectory subdirectoryNamed$$anonfun$1(String name$214) {
        void var2_2;
        VirtualDirectory dir = new VirtualDirectory(name$214, (Option<VirtualDirectory>)Some$.MODULE$.apply((Object)this));
        this.files().update((Object)name$214, (Object)dir);
        return var2_2;
    }
}

