/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.runtime.function.JProcedure1;
import dotty.tools.io.Directory;
import dotty.tools.io.File$;
import dotty.tools.io.Path;
import dotty.tools.io.Streamable;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.io.Codec;
import scala.package$;
import scala.runtime.BoxesRunTime;

public class File
extends Path
implements Streamable.Bytes,
Streamable.Chars {
    private final Codec creationCodec;

    public static File apply(java.nio.file.Path path, Codec codec) {
        return File$.MODULE$.apply(path, codec);
    }

    public static File apply(String string, Codec codec) {
        return File$.MODULE$.apply(string, codec);
    }

    public static String pathSeparator() {
        return File$.MODULE$.pathSeparator();
    }

    public File(java.nio.file.Path jpath, Codec constructorCodec) {
        super(jpath);
        this.creationCodec = constructorCodec;
    }

    public java.nio.file.Path dotty$tools$io$File$$jpath() {
        return super.jpath();
    }

    @Override
    public Codec creationCodec() {
        return this.creationCodec;
    }

    @Override
    public File addExtension(String ext) {
        return super.addExtension(ext).toFile();
    }

    @Override
    public File toAbsolute() {
        return this.isAbsolute() ? this : super.toAbsolute().toFile();
    }

    @Override
    public Directory toDirectory() {
        return new Directory(this.dotty$tools$io$File$$jpath());
    }

    @Override
    public File toFile() {
        return this;
    }

    @Override
    public File normalize() {
        return super.normalize().toFile();
    }

    @Override
    public long length() {
        return super.length();
    }

    @Override
    public Iterator<Path> walkFilter(Function1<Path, Object> cond) {
        return BoxesRunTime.unboxToBoolean((Object)cond.apply((Object)this)) ? package$.MODULE$.Iterator().single((Object)this) : package$.MODULE$.Iterator().empty();
    }

    @Override
    public InputStream inputStream() {
        return Files.newInputStream(this.dotty$tools$io$File$$jpath(), new OpenOption[0]);
    }

    public OutputStream outputStream(boolean append) {
        return append ? Files.newOutputStream(this.dotty$tools$io$File$$jpath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND) : Files.newOutputStream(this.dotty$tools$io$File$$jpath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public boolean outputStream$default$1() {
        return false;
    }

    public BufferedOutputStream bufferedOutput(boolean append) {
        return new BufferedOutputStream(this.outputStream(append));
    }

    public boolean bufferedOutput$default$1() {
        return false;
    }

    public OutputStreamWriter writer(boolean append, Codec codec) {
        return new OutputStreamWriter(this.outputStream(append), codec.charSet());
    }

    public BufferedWriter bufferedWriter() {
        return this.bufferedWriter(false);
    }

    public BufferedWriter bufferedWriter(boolean append) {
        return this.bufferedWriter(append, this.creationCodec());
    }

    public BufferedWriter bufferedWriter(boolean append, Codec codec) {
        return new BufferedWriter(this.writer(append, codec));
    }

    public PrintWriter printWriter() {
        return new PrintWriter((Writer)this.bufferedWriter(), true);
    }

    public void writeAll(Seq<String> strings) {
        try (BufferedWriter out = this.bufferedWriter();){
            strings.foreach((Function1)(JProcedure1 & Serializable)_$1226 -> out.write((String)_$1226));
        }
    }

    public void appendAll(Seq<String> strings) {
        try (BufferedWriter out = this.bufferedWriter(true);){
            strings.foreach((Function1)(JProcedure1 & Serializable)_$1227 -> out.write((String)_$1227));
        }
    }

    public void printlnAll(Seq<String> strings) {
        try (PrintWriter out = this.printWriter();){
            strings.foreach((Function1)(JProcedure1 & Serializable)_$1228 -> out.println((String)_$1228));
        }
    }

    public Option<String> safeSlurp() {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply((Object)this.slurp());
        }
        catch (IOException iOException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        boolean bl;
        Method method;
        try {
            method = java.io.File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        Method method2 = method;
        try {
            bl = (Boolean)method2.invoke((Object)this.dotty$tools$io$File$$jpath().toFile(), Predef$.MODULE$.boolean2Boolean(executable), Predef$.MODULE$.boolean2Boolean(ownerOnly));
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean setExecutable$default$2() {
        return true;
    }
}

