/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.DottyPredef$;
import dotty.runtime.function.JFunction1;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.Directory;
import dotty.tools.io.File;
import dotty.tools.io.Path;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;

public class PlainFile
extends AbstractFile {
    private final Path givenPath;
    private final String absolutePath;

    public PlainFile(Path givenPath) {
        this.givenPath = givenPath;
        if (this.path() == null) {
            DottyPredef$.MODULE$.assertFail();
        }
        this.absolutePath = givenPath.toAbsolute().toString().intern();
    }

    public Path givenPath() {
        return this.givenPath;
    }

    @Override
    public java.nio.file.Path jpath() {
        return this.givenPath().jpath();
    }

    public Some<PlainFile> underlyingSource() {
        return Some$.MODULE$.apply((Object)this);
    }

    @Override
    public String name() {
        return this.givenPath().name();
    }

    @Override
    public String path() {
        return this.givenPath().path();
    }

    @Override
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public PlainFile absolute() {
        return new PlainFile(this.givenPath().toAbsolute());
    }

    @Override
    public AbstractFile container() {
        return new PlainFile(this.givenPath().parent());
    }

    @Override
    public InputStream input() {
        return this.givenPath().toFile().inputStream();
    }

    @Override
    public OutputStream output() {
        File file = this.givenPath().toFile();
        return file.outputStream(file.outputStream$default$1());
    }

    @Override
    public Option<Object> sizeOption() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.givenPath().length())));
    }

    public int hashCode() {
        return System.identityHashCode(this.absolutePath());
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof PlainFile) {
            PlainFile x = (PlainFile)object;
            bl = this.absolutePath() == x.absolutePath();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isDirectory() {
        return this.givenPath().isDirectory();
    }

    @Override
    public long lastModified() {
        return this.givenPath().lastModified().toMillis();
    }

    @Override
    public Iterator<AbstractFile> iterator() {
        return this.givenPath().toDirectory().list().filter((Function1)(JFunction1 & Serializable)path -> PlainFile.existsFast$1(path)).map((Function1)(JFunction1 & Serializable)_$1240 -> new PlainFile((Path)_$1240));
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        Path child = this.givenPath().$div(name);
        return child.isDirectory() && directory || child.isFile() && !directory ? new PlainFile(child) : null;
    }

    @Override
    public void create() {
        if (!this.exists()) {
            this.givenPath().createFile(this.givenPath().createFile$default$1());
        }
    }

    @Override
    public void delete() {
        if (this.givenPath().isFile()) {
            this.givenPath().delete();
        } else if (this.givenPath().isDirectory()) {
            this.givenPath().toDirectory().deleteRecursively();
        }
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        return new PlainFile(this.givenPath().$div(name));
    }

    private static final boolean existsFast$1(Path path) {
        Path path2 = path;
        return path2 instanceof Directory || path2 instanceof File ? true : path.exists();
    }
}

