/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.AbstractFile;
import dotty.tools.io.Directory;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.compat.java8.JFunction1;
import scala.package$;
import scala.runtime.BoxesRunTime;

public class PlainNioFile
extends AbstractFile {
    private final Path nioPath;
    private final String fpath;

    public PlainNioFile(Path nioPath) {
        this.nioPath = nioPath;
        Predef$.MODULE$.assert(nioPath != null);
        this.fpath = nioPath.toAbsolutePath().toString();
    }

    @Override
    public File file() {
        File file;
        try {
            file = this.nioPath.toFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            file = null;
        }
        return file;
    }

    @Override
    public Option underlyingSource() {
        return Some$.MODULE$.apply((Object)this);
    }

    private String fpath() {
        return this.fpath;
    }

    @Override
    public String name() {
        return this.nioPath.getFileName().toString();
    }

    @Override
    public String path() {
        return this.nioPath.toString();
    }

    @Override
    public AbstractFile absolute() {
        return new PlainNioFile(this.nioPath.toAbsolutePath());
    }

    @Override
    public AbstractFile container() {
        return new PlainNioFile(this.nioPath.getParent());
    }

    @Override
    public InputStream input() {
        return Files.newInputStream(this.nioPath, new OpenOption[0]);
    }

    @Override
    public OutputStream output() {
        return Files.newOutputStream(this.nioPath, new OpenOption[0]);
    }

    @Override
    public Option sizeOption() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)Files.size(this.nioPath))));
    }

    public int hashCode() {
        return this.fpath().hashCode();
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof PlainNioFile) {
            PlainNioFile plainNioFile;
            PlainNioFile x = plainNioFile = (PlainNioFile)object;
            String string = this.fpath();
            String string2 = x.fpath();
            bl = !(string == null ? string2 != null : !string.equals(string2));
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.nioPath, new LinkOption[0]);
    }

    @Override
    public long lastModified() {
        return Files.getLastModifiedTime(this.nioPath, new LinkOption[0]).toMillis();
    }

    @Override
    public Iterator iterator() {
        Iterator iterator;
        try {
            java.util.Iterator<Path> it = Files.newDirectoryStream(this.nioPath).iterator();
            iterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(it).asScala()).map((Function1)((JFunction1)PlainNioFile::iterator$$anonfun$7));
        }
        catch (NotDirectoryException notDirectoryException) {
            iterator = package$.MODULE$.Iterator().empty();
        }
        return iterator;
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        Path child = this.nioPath.resolve(name);
        return Files.isDirectory(child, new LinkOption[0]) && directory || Files.isRegularFile(child, new LinkOption[0]) && !directory ? new PlainNioFile(child) : null;
    }

    @Override
    public void create() {
        block0: {
            if (this.exists()) break block0;
            Files.createFile(this.nioPath, new FileAttribute[0]);
        }
    }

    @Override
    public void delete() {
        block1: {
            block0: {
                if (!Files.isRegularFile(this.nioPath, new LinkOption[0])) break block0;
                Files.deleteIfExists(this.nioPath);
                break block1;
            }
            if (!Files.isDirectory(this.nioPath, new LinkOption[0])) break block1;
            new Directory(this.nioPath.toFile()).deleteRecursively();
        }
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        return new PlainNioFile(this.nioPath.resolve(name));
    }

    private static PlainNioFile iterator$$anonfun$7(Path _$1034) {
        return new PlainNioFile(_$1034);
    }
}

