/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.AbstractFile;
import dotty.tools.io.File;
import dotty.tools.io.FileZipArchive;
import dotty.tools.io.VirtualFile;
import dotty.tools.io.ZipArchive$;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;

public abstract class ZipArchive
extends AbstractFile {
    private final java.io.File file;

    public static boolean closeZipFile() {
        return ZipArchive$.MODULE$.closeZipFile();
    }

    public static FileZipArchive fromFile(java.io.File file) {
        return ZipArchive$.MODULE$.fromFile(file);
    }

    public static FileZipArchive fromFile(File file) {
        return ZipArchive$.MODULE$.fromFile(file);
    }

    public static AbstractFile fromManifestURL(URL uRL) {
        return ZipArchive$.MODULE$.fromManifestURL(uRL);
    }

    public ZipArchive(java.io.File file) {
        this.file = file;
    }

    @Override
    public java.io.File file() {
        return this.file;
    }

    @Override
    public Option underlyingSource() {
        return Some$.MODULE$.apply((Object)this);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        throw this.unsupported();
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        throw this.unsupported();
    }

    @Override
    public void create() {
        throw this.unsupported();
    }

    @Override
    public void delete() {
        throw this.unsupported();
    }

    @Override
    public OutputStream output() {
        throw this.unsupported();
    }

    @Override
    public AbstractFile container() {
        throw this.unsupported();
    }

    @Override
    public AbstractFile absolute() {
        throw this.unsupported();
    }

    private DirEntry ensureDir(Map dirs, String path, ZipEntry zipEntry) {
        DirEntry dirEntry;
        Option option = dirs.get((Object)path);
        if (option instanceof Some) {
            DirEntry v;
            Some some = (Some)option;
            dirEntry = v = (DirEntry)some.x();
        } else if (None$.MODULE$.equals(option)) {
            DirEntry parent = this.ensureDir(dirs, ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$dirName(path), null);
            DirEntry dir = new DirEntry(this, path);
            parent.entries().update((Object)ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$baseName(path), (Object)dir);
            dirs.update((Object)path, (Object)dir);
            dirEntry = dir;
        } else {
            throw new MatchError((Object)option);
        }
        return dirEntry;
    }

    public DirEntry getDir(Map dirs, ZipEntry entry) {
        return entry.isDirectory() ? this.ensureDir(dirs, entry.getName(), entry) : this.ensureDir(dirs, ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$dirName(entry.getName()), null);
    }

    public static class DirEntry
    extends Entry {
        private final HashMap entries;
        private final ZipArchive $outer;

        public DirEntry(ZipArchive $outer, String path) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, path);
            this.entries = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }

        public String dotty$tools$io$ZipArchive$DirEntry$$path() {
            return super.path();
        }

        public HashMap entries() {
            return this.entries;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public Iterator iterator() {
            return this.entries().valuesIterator();
        }

        @Override
        public Entry lookupName(String name, boolean directory) {
            return directory ? (Entry)this.entries().apply((Object)new StringBuilder().append((Object)name).append((Object)"/").toString()) : (Entry)this.entries().apply((Object)name);
        }

        private ZipArchive $outer() {
            return this.$outer;
        }

        public final ZipArchive dotty$tools$io$ZipArchive$DirEntry$$$outer() {
            return this.$outer();
        }
    }

    public static abstract class Entry
    extends VirtualFile {
        private final ZipArchive $outer;

        public Entry(ZipArchive $outer, String path) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$baseName(path), path);
        }

        public String dotty$tools$io$ZipArchive$Entry$$path() {
            return super.path();
        }

        public ZipFile getArchive() {
            return null;
        }

        @Override
        public Option underlyingSource() {
            return Some$.MODULE$.apply((Object)this.dotty$tools$io$ZipArchive$Entry$$$outer());
        }

        @Override
        public String toString() {
            return new StringBuilder().append((Object)this.dotty$tools$io$ZipArchive$Entry$$$outer().path()).append((Object)"(").append((Object)this.dotty$tools$io$ZipArchive$Entry$$path()).append((Object)")").toString();
        }

        private ZipArchive $outer() {
            return this.$outer;
        }

        public final ZipArchive dotty$tools$io$ZipArchive$Entry$$$outer() {
            return this.$outer();
        }
    }
}

