/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.runtime.LazyRef;
import dotty.tools.dotc.config.Printers;
import dotty.tools.dotc.config.Printers$;
import dotty.tools.dotc.config.Printers$noPrinter$;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$Context$;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$PhaseListDecorator$;
import dotty.tools.dotc.core.Mode$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.printing.Showable;
import dotty.tools.dotc.reporting.StoreReporter;
import dotty.tools.dotc.reporting.diagnostic.ExtendMessage;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.Message$;
import dotty.tools.dotc.reporting.diagnostic.messages;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourcePosition;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JFunction1;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public interface Reporting {
    default public void $init$() {
    }

    default public void inform(Function0 msg, SourcePosition pos) {
        block0: {
            Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().verbose());
            if (!BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) break block0;
            this.echo(msg, pos);
        }
    }

    default public NoSourcePosition$ inform$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void echo(Function0 msg, SourcePosition pos) {
        ((Contexts.Context)this).reporter().report(new messages.Info(() -> this.echo$$anonfun$1(msg), pos), ((Contexts.Context)this).ctx());
    }

    default public NoSourcePosition$ echo$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void reportWarning(messages.Warning warning) {
        block2: {
            Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().silentWarnings());
            if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) break block2;
            Settings.Setting setting2 = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().XfatalWarnings());
            if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2, ((Contexts.Context)this).ctx()))) {
                ((Contexts.Context)this).reporter().report(warning.toError(), ((Contexts.Context)this).ctx());
            } else {
                ((Contexts.Context)this).reporter().report(warning, ((Contexts.Context)this).ctx());
            }
        }
    }

    default public void deprecationWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.DeprecationWarning(msg, pos));
    }

    default public NoSourcePosition$ deprecationWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void migrationWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.MigrationWarning(msg, pos));
    }

    default public NoSourcePosition$ migrationWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void uncheckedWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.UncheckedWarning(msg, pos));
    }

    default public NoSourcePosition$ uncheckedWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void featureWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.FeatureWarning(msg, pos));
    }

    default public NoSourcePosition$ featureWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void featureWarning(String feature, String featureDescription, boolean isScala2Feature, Symbols.Symbol featureUseSite, boolean required, SourcePosition pos) {
        String string;
        String req;
        String string2 = required ? "needs to" : (req = "should");
        String prefix = isScala2Feature ? "scala." : "dotty.";
        String fqname = new StringBuilder().append((Object)prefix).append((Object)"language.").append((Object)feature).toString();
        if (((Contexts.Context)this).reporter().isReportedFeatureUseSite(featureUseSite)) {
            string = "";
        } else {
            ((Contexts.Context)this).reporter().reportNewFeatureUseSite(featureUseSite);
            string = new StringOps(Predef$.MODULE$.augmentString(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |This can be achieved by adding the import clause 'import ", "'\n           |or by setting the compiler option -language:", ".\n           |See the Scala docs for value ", " for a discussion\n           |why the feature ", " be explicitly enabled."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fqname, feature, fqname, req})))).stripMargin();
        }
        String explain = string;
        String msg = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " be enabled\\nby making the implicit value ", " visible.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureDescription, req, fqname, explain}));
        if (required) {
            this.error(() -> this.featureWarning$$anonfun$1(msg), pos);
        } else {
            this.reportWarning(new messages.FeatureWarning(() -> this.featureWarning$$anonfun$2(msg), pos));
        }
    }

    default public void warning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.Warning(msg, pos));
    }

    default public NoSourcePosition$ warning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void strictWarning(Function0 msg, SourcePosition pos) {
        Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().strict());
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) {
            this.error(msg, pos);
        } else {
            this.reportWarning(new ExtendMessage(() -> this.strictWarning$$anonfun$1(msg), (Function1)((JFunction1)Reporting::strictWarning$$anonfun$2)).warning(pos));
        }
    }

    default public NoSourcePosition$ strictWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void error(Function0 msg, SourcePosition pos) {
        ((Contexts.Context)this).reporter().report(new messages.Error(msg, pos), ((Contexts.Context)this).ctx());
    }

    default public NoSourcePosition$ error$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void errorOrMigrationWarning(Function0 msg, SourcePosition pos) {
        if (((Contexts.Context)this).ctx().scala2Mode()) {
            this.migrationWarning(msg, pos);
        } else {
            this.error(msg, pos);
        }
    }

    default public NoSourcePosition$ errorOrMigrationWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void restrictionError(Function0 msg, SourcePosition pos) {
        ((Contexts.Context)this).reporter().report(new ExtendMessage(() -> this.restrictionError$$anonfun$1(msg), (Function1)((JFunction1)Reporting::restrictionError$$anonfun$2)).error(pos), ((Contexts.Context)this).ctx());
    }

    default public NoSourcePosition$ restrictionError$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void incompleteInputError(Function0 msg, SourcePosition pos, Contexts.Context ctx) {
        ((Contexts.Context)this).reporter().incomplete(new messages.Error(msg, pos), ctx);
    }

    default public NoSourcePosition$ incompleteInputError$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void log(Function0 msg, SourcePosition pos) {
        block0: {
            Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().log());
            if (!Decorators$PhaseListDecorator$.MODULE$.containsPhase$extension(Decorators$.MODULE$.PhaseListDecorator((List)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx())), ((Contexts.Context)this).phase())) break block0;
            this.echo(() -> this.log$$anonfun$1(msg), pos);
        }
    }

    default public NoSourcePosition$ log$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void debuglog(Function0 msg) {
        block0: {
            if (!((Contexts.Context)this).ctx().debug()) break block0;
            this.log(msg, this.log$default$2());
        }
    }

    default public void informTime(Function0 msg, long start) {
        this.informProgress(() -> this.informTime$$anonfun$1(msg, start));
    }

    default public void informProgress(Function0 msg) {
        this.inform(() -> this.informProgress$$anonfun$2(msg), this.inform$default$2());
    }

    default public Object trace(Function0 msg, Object value) {
        this.log(() -> this.trace$$anonfun$1(msg, value), this.log$default$2());
        return value;
    }

    default public void debugwarn(Function0 msg, SourcePosition pos) {
        block0: {
            Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().debug());
            if (!BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) break block0;
            this.warning(() -> this.debugwarn$$anonfun$1(msg), pos);
        }
    }

    default public NoSourcePosition$ debugwarn$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public Object debugTraceIndented(Function0 question, Printers.Printer printer, boolean show, Function0 op) {
        Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().debugTrace());
        return this.conditionalTraceIndented(BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx())), question, printer, show, op);
    }

    default public Printers.Printer debugTraceIndented$default$2() {
        return Printers$.MODULE$.default();
    }

    default public boolean debugTraceIndented$default$3() {
        return false;
    }

    default public Object conditionalTraceIndented(boolean cond, Function0 question, Printers.Printer printer, boolean show, Function0 op) {
        return cond ? this.traceIndented(question, printer, show, op) : op.apply();
    }

    default public Printers.Printer conditionalTraceIndented$default$3() {
        return Printers$.MODULE$.default();
    }

    default public boolean conditionalTraceIndented$default$4() {
        return false;
    }

    default public Object traceIndented(Function0 question, Printers.Printer printer, boolean show, Function0 op) {
        return printer == Printers$noPrinter$.MODULE$ ? op.apply() : this.traceIndented$_inlineAccessor_$1(question, printer, show, op);
    }

    default public Object traceIndented$_inlineAccessor_$1(Function0 question, Printers.Printer printer, boolean show, Function0 op) {
        return Reporting.super.doTraceIndented(question, printer, show, op);
    }

    default public Printers.Printer traceIndented$default$2() {
        return Printers$.MODULE$.default();
    }

    default public boolean traceIndented$default$3() {
        return false;
    }

    private Object doTraceIndented(Function0 question, Printers.Printer printer, boolean show, Function0 op) {
        LazyRef lazyRef = new LazyRef();
        return this.doTraceIndented(() -> this.doTraceIndented$$anonfun$1(question, lazyRef), arg_0 -> this.doTraceIndented$$anonfun$2(question, show, lazyRef, arg_0), op);
    }

    default public Printers.Printer doTraceIndented$default$2() {
        return Printers$.MODULE$.default();
    }

    default public boolean doTraceIndented$default$3() {
        return false;
    }

    default public Object doTraceIndented(Function0 leading, Function1 trailing, Function0 op) {
        Object object;
        if (Mode$.MODULE$.is$extension(((Contexts.Context)this).ctx().mode(), Mode$.MODULE$.Printing())) {
            object = op.apply();
        } else {
            BooleanRef finalized = BooleanRef.create((boolean)false);
            ObjectRef logctx = ObjectRef.create((Object)((Contexts.Context)this));
            while (((Contexts.Context)logctx.elem).reporter() instanceof StoreReporter) {
                Contexts.Context context = ((Contexts.Context)logctx.elem).outer();
                logctx.elem = context;
            }
            try {
                Contexts.Context $669$ = (Contexts.Context)logctx.elem;
                $669$.log(() -> this.doTraceIndented$$anonfun$3(leading), $669$.log$default$2());
                ((Contexts.Context)this).base().indent_$eq(((Contexts.Context)this).base().indent() + 1);
                Object res = op.apply();
                this.finalize$1(trailing, finalized, logctx, res, "");
                object = res;
            }
            catch (Throwable ex) {
                this.finalize$1(trailing, finalized, logctx, "<missing>", StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (with exception ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ex})));
                throw ex;
            }
        }
        return object;
    }

    private Message echo$$anonfun$1(Function0 msg$25) {
        return Message$.MODULE$.toNoExplanation((String)msg$25.apply());
    }

    private Message featureWarning$$anonfun$1(String msg$26) {
        return Message$.MODULE$.toNoExplanation(msg$26);
    }

    private Message featureWarning$$anonfun$2(String msg$27) {
        return Message$.MODULE$.toNoExplanation(msg$27);
    }

    private Message strictWarning$$anonfun$1(Function0 msg$28) {
        return (Message)msg$28.apply();
    }

    private static String strictWarning$$anonfun$2(String _$538) {
        return new StringBuilder().append((Object)_$538).append((Object)"\n(This would be an error under strict mode)").toString();
    }

    private Message restrictionError$$anonfun$1(Function0 msg$29) {
        return (Message)msg$29.apply();
    }

    private static String restrictionError$$anonfun$2(String m) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Implementation restriction: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m}));
    }

    private String log$$anonfun$1(Function0 msg$30) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[log ", "] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Contexts.Context)this).ctx().phasesStack().reverse().mkString(" -> "), msg$30.apply()}));
    }

    private String elapsed$1(long start$49) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" in ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - start$49))}));
    }

    private String informTime$$anonfun$1(Function0 msg$31, long start$50) {
        return new StringBuilder().append((Object)((String)msg$31.apply())).append((Object)this.elapsed$1(start$50)).toString();
    }

    private String informProgress$$anonfun$2(Function0 msg$32) {
        return new StringBuilder().append((Object)"[").append(msg$32.apply()).append((Object)"]").toString();
    }

    private String trace$$anonfun$1(Function0 msg$33, Object value$4) {
        return new StringBuilder().append((Object)((String)msg$33.apply())).append((Object)" ").append(value$4).toString();
    }

    private Message debugwarn$$anonfun$1(Function0 msg$34) {
        return Message$.MODULE$.toNoExplanation((String)msg$34.apply());
    }

    /*
     * Enabled aggressive block sorting
     */
    private String resStr$1(boolean show$2, Object res) {
        String string;
        Object object = res;
        if (object instanceof Showable) {
            Showable showable;
            Showable res2 = showable = (Showable)object;
            if (show$2) {
                string = res2.show(((Contexts.Context)this).ctx());
                return string;
            }
        }
        string = String.valueOf(res);
        return string;
    }

    private String q$lzyINIT1$1(Function0 question$17, LazyRef q$lzy1$1) {
        Object object;
        LazyRef lazyRef = q$lzy1$1;
        synchronized (lazyRef) {
            Object object2;
            if (q$lzy1$1.initialized()) {
                object2 = q$lzy1$1.value();
            } else {
                q$lzy1$1.initialized_$eq(true);
                q$lzy1$1.value_$eq((Object)((String)question$17.apply()));
                object2 = q$lzy1$1.value();
            }
            object = object2;
        }
        return (String)object;
    }

    private String q$2(Function0 question$18, LazyRef q$lzy1$2) {
        return (String)(q$lzy1$2.initialized() ? q$lzy1$2.value() : this.q$lzyINIT1$1(question$18, q$lzy1$2));
    }

    private String doTraceIndented$$anonfun$1(Function0 question$19, LazyRef q$lzy1$3) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"==> ", "?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.q$2(question$19, q$lzy1$3)}));
    }

    private String doTraceIndented$$anonfun$2(Function0 question$20, boolean show$3, LazyRef q$lzy1$4, Object res) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<== ", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.q$2(question$20, q$lzy1$4), this.resStr$1(show$3, res)}));
    }

    private String finalize$1$$anonfun$1(Function1 trailing$2, Object result$5, String note$1) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(((Contexts.Context)this).base().indentTab())).$times(((Contexts.Context)this).base().indent()), trailing$2.apply(result$5), note$1}));
    }

    private void finalize$1(Function1 trailing$1, BooleanRef finalized$1, ObjectRef logctx$1, Object result, String note) {
        block0: {
            boolean bl;
            if (finalized$1.elem) break block0;
            ((Contexts.Context)this).base().indent_$eq(((Contexts.Context)this).base().indent() - 1);
            Contexts.Context $668$ = (Contexts.Context)logctx$1.elem;
            $668$.log(() -> this.finalize$1$$anonfun$1(trailing$1, result, note), $668$.log$default$2());
            finalized$1.elem = bl = true;
        }
    }

    private String doTraceIndented$$anonfun$3(Function0 leading$1) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(((Contexts.Context)this).base().indentTab())).$times(((Contexts.Context)this).base().indent()), leading$1.apply()}));
    }
}

