/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Directory;
import dotty.tools.io.File$;
import dotty.tools.io.Path;
import dotty.tools.io.Streamable;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.compat.java8.JProcedure1;
import scala.io.Codec;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public class File
extends Path
implements Streamable.Chars {
    private final Codec constructorCodec;
    private final Codec creationCodec;

    public static File makeTemp(String string, String string2, java.io.File file) {
        return File$.MODULE$.makeTemp(string, string2, file);
    }

    public static File apply(Path path, Codec codec) {
        return File$.MODULE$.apply(path, codec);
    }

    public static String makeTemp$default$1() {
        return File$.MODULE$.makeTemp$default$1();
    }

    public static Null$ makeTemp$default$3() {
        return File$.MODULE$.makeTemp$default$3();
    }

    public static Null$ makeTemp$default$2() {
        return File$.MODULE$.makeTemp$default$2();
    }

    public static String pathSeparator() {
        return File$.MODULE$.pathSeparator();
    }

    public File(java.io.File jfile, Codec constructorCodec) {
        this.constructorCodec = constructorCodec;
        super(jfile);
        this.creationCodec = constructorCodec;
    }

    public java.io.File dotty$tools$io$File$$jfile() {
        return super.jfile();
    }

    @Override
    public Codec creationCodec() {
        return this.creationCodec;
    }

    @Override
    public File addExtension(String ext) {
        return super.addExtension(ext).toFile();
    }

    @Override
    public File toAbsolute() {
        return this.isAbsolute() ? this : super.toAbsolute().toFile();
    }

    @Override
    public Directory toDirectory() {
        return new Directory(this.dotty$tools$io$File$$jfile());
    }

    @Override
    public File toFile() {
        return this;
    }

    @Override
    public File normalize() {
        return super.normalize().toFile();
    }

    @Override
    public long length() {
        return super.length();
    }

    @Override
    public Iterator walkFilter(Function1 cond) {
        return BoxesRunTime.unboxToBoolean((Object)cond.apply((Object)this)) ? package$.MODULE$.Iterator().single((Object)this) : package$.MODULE$.Iterator().empty();
    }

    @Override
    public InputStream inputStream() {
        return new FileInputStream(this.dotty$tools$io$File$$jfile());
    }

    public FileOutputStream outputStream(boolean append) {
        return new FileOutputStream(this.dotty$tools$io$File$$jfile(), append);
    }

    public boolean outputStream$default$1() {
        return false;
    }

    public BufferedOutputStream bufferedOutput(boolean append) {
        return new BufferedOutputStream(this.outputStream(append));
    }

    public boolean bufferedOutput$default$1() {
        return false;
    }

    public OutputStreamWriter writer(boolean append, Codec codec) {
        return new OutputStreamWriter((OutputStream)this.outputStream(append), codec.charSet());
    }

    public BufferedWriter bufferedWriter() {
        return this.bufferedWriter(false);
    }

    public BufferedWriter bufferedWriter(boolean append) {
        return this.bufferedWriter(append, this.creationCodec());
    }

    public BufferedWriter bufferedWriter(boolean append, Codec codec) {
        return new BufferedWriter(this.writer(append, codec));
    }

    public PrintWriter printWriter() {
        return new PrintWriter((Writer)this.bufferedWriter(), true);
    }

    public void writeAll(Seq strings) {
        try (BufferedWriter out = this.bufferedWriter();){
            strings.foreach((Function1)((JProcedure1)arg_0 -> this.writeAll$$anonfun$1(out, arg_0)));
        }
    }

    public void appendAll(Seq strings) {
        try (BufferedWriter out = this.bufferedWriter(true);){
            strings.foreach((Function1)((JProcedure1)arg_0 -> this.appendAll$$anonfun$1(out, arg_0)));
        }
    }

    public void printlnAll(Seq strings) {
        try (PrintWriter out = this.printWriter();){
            strings.foreach((Function1)((JProcedure1)arg_0 -> this.printlnAll$$anonfun$1(out, arg_0)));
        }
    }

    public Option safeSlurp() {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply((Object)this.slurp());
        }
        catch (IOException iOException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        boolean bl;
        Method method;
        try {
            method = java.io.File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        Method method2 = method;
        try {
            bl = (Boolean)method2.invoke((Object)this.dotty$tools$io$File$$jfile(), Predef$.MODULE$.boolean2Boolean(executable), Predef$.MODULE$.boolean2Boolean(ownerOnly));
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean setExecutable$default$2() {
        return true;
    }

    private void writeAll$$anonfun$1(BufferedWriter out$31, String _$1020) {
        out$31.write(_$1020);
    }

    private void appendAll$$anonfun$1(BufferedWriter out$32, String _$1021) {
        out$32.write(_$1021);
    }

    private void printlnAll$$anonfun$1(PrintWriter out$33, String _$1022) {
        out$33.println(_$1022);
    }
}

