/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.File$;
import dotty.tools.io.Path$;
import dotty.tools.io.ZipArchive;
import dotty.tools.io.ZipArchive$;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileZipArchive
extends ZipArchive {
    private final Tuple2 $230$;
    private final ZipArchive.DirEntry root;
    private final HashMap allDirs;

    public FileZipArchive(File file) {
        super(file);
        ZipArchive.DirEntry root = new ZipArchive.DirEntry(this, "/");
        Object[] objectArray = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"/");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)root);
        HashMap dirs = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(objectArray));
        ZipFile zipFile = this.dotty$tools$io$FileZipArchive$$openZipFile();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        this.liftedTree10$1(dirs, zipFile, entries);
        this.$230$ = Tuple2$.MODULE$.apply((Object)root, (Object)dirs);
        this.root = (ZipArchive.DirEntry)this.$230$._1();
        this.allDirs = (HashMap)this.$230$._2();
    }

    public File dotty$tools$io$FileZipArchive$$file() {
        return super.file();
    }

    public ZipFile dotty$tools$io$FileZipArchive$$openZipFile() {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(this.dotty$tools$io$FileZipArchive$$file());
        }
        catch (IOException ioe) {
            throw new IOException(new StringBuilder().append((Object)"Error accessing ").append((Object)this.dotty$tools$io$FileZipArchive$$file().getPath()).toString(), ioe);
        }
        return zipFile;
    }

    public ZipArchive.DirEntry root() {
        return this.root;
    }

    public HashMap allDirs() {
        return this.allDirs;
    }

    @Override
    public Iterator iterator() {
        return this.root().iterator();
    }

    @Override
    public String name() {
        return this.dotty$tools$io$FileZipArchive$$file().getName();
    }

    @Override
    public String path() {
        return this.dotty$tools$io$FileZipArchive$$file().getPath();
    }

    @Override
    public InputStream input() {
        return File$.MODULE$.apply(Path$.MODULE$.jfile2path(this.dotty$tools$io$FileZipArchive$$file()), Codec$.MODULE$.fallbackSystemCodec()).inputStream();
    }

    @Override
    public long lastModified() {
        return this.dotty$tools$io$FileZipArchive$$file().lastModified();
    }

    @Override
    public Option sizeOption() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.dotty$tools$io$FileZipArchive$$file().length())));
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof FileZipArchive;
    }

    public int hashCode() {
        return this.dotty$tools$io$FileZipArchive$$file().hashCode();
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof FileZipArchive) {
            FileZipArchive fileZipArchive;
            FileZipArchive x = fileZipArchive = (FileZipArchive)object;
            File file = this.dotty$tools$io$FileZipArchive$$file().getAbsoluteFile();
            File file2 = x.file().getAbsoluteFile();
            bl = !(file == null ? file2 != null : !((Object)file).equals(file2));
        } else {
            bl = false;
        }
        return bl;
    }

    private void liftedTree10$1(HashMap dirs$1, ZipFile zipFile$3, Enumeration entries$7) {
        try {
            while (entries$7.hasMoreElements()) {
                ZipArchive.DirEntry dirEntry;
                ZipEntry zipEntry = (ZipEntry)entries$7.nextElement();
                ZipArchive.DirEntry dir = this.getDir((Map)dirs$1, zipEntry);
                if (zipEntry.isDirectory()) {
                    dirEntry = dir;
                    continue;
                }
                ZipArchive.Entry f = ZipArchive$.MODULE$.closeZipFile() ? new LazyEntry(this, zipEntry.getName(), zipEntry.getTime(), (int)zipEntry.getSize()) : new LeakyEntry(this, zipFile$3, zipEntry);
                dir.entries().update((Object)f.name(), (Object)f);
                dirEntry = BoxedUnit.UNIT;
            }
        }
        finally {
            if (ZipArchive$.MODULE$.closeZipFile()) {
                zipFile$3.close();
            }
        }
    }

    private static class LazyEntry
    extends ZipArchive.Entry {
        private final String name;
        private final long time;
        private final int size;
        private final FileZipArchive $outer;

        public LazyEntry(FileZipArchive $outer, String name, long time, int size) {
            this.name = name;
            this.time = time;
            this.size = size;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, name);
        }

        @Override
        public long lastModified() {
            return this.time;
        }

        @Override
        public InputStream input() {
            ZipFile zipFile = this.dotty$tools$io$FileZipArchive$LazyEntry$$$outer().dotty$tools$io$FileZipArchive$$openZipFile();
            ZipEntry entry = zipFile.getEntry(this.name);
            InputStream delegate = zipFile.getInputStream(entry);
            return new FilterInputStream(zipFile, delegate){
                private final ZipFile zipFile$4;
                private final InputStream delegate$1;
                {
                    this.zipFile$4 = zipFile$5;
                    this.delegate$1 = delegate$2;
                    super(delegate$2);
                }

                public void close() {
                    this.zipFile$4.close();
                }
            };
        }

        @Override
        public Option sizeOption() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.size));
        }

        private FileZipArchive $outer() {
            return this.$outer;
        }

        public final FileZipArchive dotty$tools$io$FileZipArchive$LazyEntry$$$outer() {
            return this.$outer();
        }
    }

    private static class LeakyEntry
    extends ZipArchive.Entry {
        private final ZipFile zipFile;
        private final ZipEntry zipEntry;
        private final FileZipArchive $outer;

        public LeakyEntry(FileZipArchive $outer, ZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, zipEntry.getName());
        }

        @Override
        public long lastModified() {
            return this.zipEntry.getTime();
        }

        @Override
        public InputStream input() {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        @Override
        public Option sizeOption() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.zipEntry.getSize())));
        }

        private FileZipArchive $outer() {
            return this.$outer;
        }

        public final FileZipArchive dotty$tools$io$FileZipArchive$LeakyEntry$$$outer() {
            return this.$outer();
        }
    }
}

