/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.AbstractFile;
import dotty.tools.io.VirtualFile;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JFunction1;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public class VirtualDirectory
extends AbstractFile {
    private final String name;
    private final Option maybeContainer;
    private final long lastModified;
    private final Map files;

    public VirtualDirectory(String name, Option maybeContainer) {
        this.name = name;
        this.maybeContainer = maybeContainer;
        this.lastModified = System.currentTimeMillis();
        this.files = Map$.MODULE$.empty();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String path() {
        String string;
        Option option = this.maybeContainer;
        if (None$.MODULE$.equals(option)) {
            string = this.name();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            VirtualDirectory parent = (VirtualDirectory)some.x();
            string = new StringBuilder().append((Object)parent.path()).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)this.name()).toString();
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    @Override
    public AbstractFile absolute() {
        return this;
    }

    @Override
    public AbstractFile container() {
        return (AbstractFile)this.maybeContainer.get();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public File file() {
        return null;
    }

    @Override
    public InputStream input() {
        throw package$.MODULE$.error("directories cannot be read");
    }

    @Override
    public OutputStream output() {
        throw package$.MODULE$.error("directories cannot be written");
    }

    @Override
    public void create() {
        throw this.unsupported();
    }

    @Override
    public void delete() {
        throw this.unsupported();
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        throw this.unsupported();
    }

    private Map files() {
        return this.files;
    }

    @Override
    public Iterator iterator() {
        return this.files().values().toList().iterator();
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        return (AbstractFile)this.files().get((Object)name).filter((Function1)((JFunction1)arg_0 -> this.lookupName$$anonfun$1(directory, arg_0))).orNull(Predef$.MODULE$.$conforms());
    }

    @Override
    public AbstractFile fileNamed(String name) {
        return (AbstractFile)Option$.MODULE$.apply((Object)this.lookupName(name, false)).getOrElse(() -> this.fileNamed$$anonfun$2(name));
    }

    @Override
    public AbstractFile subdirectoryNamed(String name) {
        return (AbstractFile)Option$.MODULE$.apply((Object)this.lookupName(name, true)).getOrElse(() -> this.subdirectoryNamed$$anonfun$2(name));
    }

    public void clear() {
        this.files().clear();
    }

    private boolean lookupName$$anonfun$1(boolean directory$2, AbstractFile _$1038) {
        return _$1038.isDirectory() == directory$2;
    }

    /*
     * WARNING - void declaration
     */
    private VirtualFile fileNamed$$anonfun$2(String name$242) {
        void var2_2;
        VirtualFile newFile = new VirtualFile(name$242, new StringBuilder().append((Object)this.path()).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)name$242).toString());
        this.files().update((Object)name$242, (Object)newFile);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private VirtualDirectory subdirectoryNamed$$anonfun$2(String name$243) {
        void var2_2;
        VirtualDirectory dir = new VirtualDirectory(name$243, (Option)Some$.MODULE$.apply((Object)this));
        this.files().update((Object)name$243, (Object)dir);
        return var2_2;
    }
}

