/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.interactive;

import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import dotty.tools.FatalError;
import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Driver;
import dotty.tools.dotc.Run;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.Trees$PackageDef$;
import dotty.tools.dotc.ast.tpd$;
import dotty.tools.dotc.ast.tpd$TreeOps$;
import dotty.tools.dotc.classpath.AggregateClassPath;
import dotty.tools.dotc.classpath.AggregateClassPath$;
import dotty.tools.dotc.classpath.JFileDirectoryLookup;
import dotty.tools.dotc.classpath.ZipArchiveFileLookup;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$;
import dotty.tools.dotc.core.Contexts$FreshModeChanges$;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$PreNamedString$;
import dotty.tools.dotc.core.Denotations;
import dotty.tools.dotc.core.Mode$;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.NameOps$NameDecorator$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.SymDenotations;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.Types$UnspecifiedErrorType$;
import dotty.tools.dotc.interactive.InteractiveCompiler;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.interactive.SourceTree;
import dotty.tools.dotc.interactive.SourceTree$;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.reporting.StoreReporter;
import dotty.tools.dotc.reporting.UniqueMessagePositions;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.util.NoSource$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassPath;
import dotty.tools.io.ClassRepresentation;
import dotty.tools.io.VirtualFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.io.Codec$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class InteractiveDriver
extends Driver {
    private final List settings;
    private final Contexts.Context myInitCtx;
    private Contexts.Context myCtx;
    private final Compiler compiler;
    private final LinkedHashMap<URI, SourceFile> myOpenedFiles;
    private final LinkedHashMap<URI, List<SourceTree>> myOpenedTrees;
    private final LinkedHashMap<URI, CompilationUnit> myCompilationUnits;
    public final List<String> dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffixes;
    private final Seq<JFileDirectoryLookup<ClassRepresentation>> dirClassPaths;
    private final Seq<Names.TypeName> zipClassPathClasses;

    public static Option<URI> toUriOption(AbstractFile abstractFile) {
        return InteractiveDriver$.MODULE$.toUriOption(abstractFile);
    }

    public static Option<URI> toUriOption(SourceFile sourceFile) {
        return InteractiveDriver$.MODULE$.toUriOption(sourceFile);
    }

    /*
     * WARNING - void declaration
     */
    public InteractiveDriver(List<String> settings) {
        Tuple2 tuple2;
        void var3_3;
        this.settings = settings;
        Contexts.FreshContext rootCtx = Contexts$FreshModeChanges$.MODULE$.addMode$extension(Contexts$.MODULE$.FreshModeChanges(Contexts$FreshModeChanges$.MODULE$.addMode$extension(Contexts$.MODULE$.FreshModeChanges(Contexts$FreshModeChanges$.MODULE$.addMode$extension(Contexts$.MODULE$.FreshModeChanges(this.initCtx().fresh()), Mode$.MODULE$.ReadPositions())), Mode$.MODULE$.Interactive())), Mode$.MODULE$.ReadComments());
        rootCtx.setSetting(rootCtx.settings().YretainTrees(), BoxesRunTime.boxToBoolean((boolean)true));
        rootCtx.setSetting(rootCtx.settings().YcookComments(), BoxesRunTime.boxToBoolean((boolean)true));
        Contexts.Context ctx = (Contexts.Context)this.setup((String[])settings.toArray(ClassTag$.MODULE$.apply(String.class)), rootCtx)._2();
        ctx.initialize(ctx);
        this.myCtx = this.myInitCtx = var3_3;
        this.compiler = new InteractiveCompiler();
        this.myOpenedFiles = new LinkedHashMap(){

            public SourceFile default(URI key) {
                return NoSource$.MODULE$;
            }
        };
        this.myOpenedTrees = new LinkedHashMap(){

            public List default(URI key) {
                return package$.MODULE$.Nil();
            }
        };
        this.myCompilationUnits = new LinkedHashMap();
        this.dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffixes = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".hasTasty", ".tasty"}));
        ClassPath classPath = this.currentCtx().platform().classPath(this.currentCtx());
        if (classPath instanceof AggregateClassPath) {
            scala.collection.immutable.Seq<ClassPath> seq;
            AggregateClassPath aggregateClassPath = AggregateClassPath$.MODULE$.unapply((AggregateClassPath)classPath);
            scala.collection.immutable.Seq<ClassPath> cps = seq = aggregateClassPath._1();
            scala.collection.immutable.Seq zipCps = (scala.collection.immutable.Seq)cps.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(ClassPath x) {
                    boolean bl;
                    ClassPath classPath = x;
                    if (classPath instanceof ZipArchiveFileLookup) {
                        ZipArchiveFileLookup cp = (ZipArchiveFileLookup)classPath;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(ClassPath x, Function1 function1) {
                    Object object;
                    ClassPath classPath = x;
                    if (classPath instanceof ZipArchiveFileLookup) {
                        ZipArchiveFileLookup cp = (ZipArchiveFileLookup)classPath;
                        object = cp;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            });
            scala.collection.immutable.Seq dirCps = (scala.collection.immutable.Seq)cps.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(ClassPath x) {
                    boolean bl;
                    ClassPath classPath = x;
                    if (classPath instanceof JFileDirectoryLookup) {
                        JFileDirectoryLookup cp = (JFileDirectoryLookup)classPath;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(ClassPath x, Function1 function1) {
                    Object object;
                    ClassPath classPath = x;
                    if (classPath instanceof JFileDirectoryLookup) {
                        JFileDirectoryLookup cp = (JFileDirectoryLookup)classPath;
                        object = cp;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            });
            tuple2 = Tuple2$.MODULE$.apply((Object)zipCps, (Object)dirCps);
        } else {
            tuple2 = Tuple2$.MODULE$.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
        }
        Tuple2 tuple22 = tuple2;
        Seq zipClassPaths = (Seq)tuple22._1();
        this.dirClassPaths = (Seq)tuple22._2();
        ListBuffer names = new ListBuffer();
        zipClassPaths.foreach((Function1)(JProcedure1 & Serializable)cp -> this.classesFromZip(cp.zipFile(), (ListBuffer<Names.TypeName>)names));
        this.zipClassPathClasses = names;
        this.initialize();
    }

    public List<String> settings() {
        return this.settings;
    }

    @Override
    public boolean sourcesRequired() {
        return false;
    }

    public Contexts.Context currentCtx() {
        return this.myCtx;
    }

    public Map<URI, SourceFile> openedFiles() {
        return this.myOpenedFiles;
    }

    public Map<URI, List<SourceTree>> openedTrees() {
        return this.myOpenedTrees;
    }

    public Map<URI, CompilationUnit> compilationUnits() {
        return this.myCompilationUnits;
    }

    public List<SourceTree> sourceTrees(Contexts.Context ctx) {
        return this.sourceTreesContaining("", ctx);
    }

    public List<SourceTree> sourceTreesContaining(String id, Contexts.Context ctx) {
        List fromBuffers = ((IterableOnceOps)this.openedTrees().values().flatten(Predef$.MODULE$.$conforms())).toList();
        ListBuffer classNames = new ListBuffer();
        Settings.Setting<AbstractFile> setting = Settings$Setting$.MODULE$.SettingDecorator(ctx.settings().outputDir());
        AbstractFile output = Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx);
        if (output.isDirectory()) {
            this.classesFromDir(output.jpath(), (ListBuffer<Names.TypeName>)classNames);
        } else {
            this.classesFromZip(output.file(), (ListBuffer<Names.TypeName>)classNames);
        }
        ListBuffer fromCompilationOutput = (ListBuffer)classNames.flatMap((Function1)(JFunction1 & Serializable)cls -> this.treesFromClassName((Names.TypeName)cls, id, ctx));
        return (List)((SeqOps)fromBuffers.$plus$plus((IterableOnce)fromCompilationOutput)).distinct();
    }

    public List<SourceTree> allTrees(Contexts.Context ctx) {
        return this.allTreesContaining("", ctx);
    }

    public List<SourceTree> allTreesContaining(String id, Contexts.Context ctx) {
        List fromSource = ((IterableOnceOps)this.openedTrees().values().flatten(Predef$.MODULE$.$conforms())).toList();
        Seq fromClassPath = (Seq)((IterableOps)this.dirClassPathClasses().$plus$plus(this.zipClassPathClasses)).flatMap((Function1)(JFunction1 & Serializable)cls -> this.treesFromClassName((Names.TypeName)cls, id, ctx));
        return (List)((SeqOps)fromSource.$plus$plus((IterableOnce)fromClassPath)).distinct();
    }

    public List<MessageContainer> run(URI uri, String sourceCode) {
        return this.run(uri, this.toSource(uri, sourceCode));
    }

    public List<MessageContainer> run(URI uri, SourceFile source) {
        List<MessageContainer> list;
        Contexts.Context previousCtx = this.myCtx;
        try {
            UniqueMessagePositions reporter = new UniqueMessagePositions(){
                private final HashMap dotty$tools$dotc$reporting$UniqueMessagePositions$$positions;
                {
                    this.dotty$tools$dotc$reporting$UniqueMessagePositions$$positions = UniqueMessagePositions.super.dotty$tools$dotc$reporting$UniqueMessagePositions$$initial$positions();
                    UniqueMessagePositions.super.$init$();
                }

                public HashMap dotty$tools$dotc$reporting$UniqueMessagePositions$$positions() {
                    return this.dotty$tools$dotc$reporting$UniqueMessagePositions$$positions;
                }

                public /* synthetic */ boolean dotty$tools$dotc$reporting$UniqueMessagePositions$$super$isHidden(MessageContainer m, Contexts.Context ctx) {
                    return super.isHidden(m, ctx);
                }

                public /* synthetic */ boolean dotty$tools$dotc$reporting$HideNonSensicalMessages$$super$isHidden(MessageContainer m, Contexts.Context ctx) {
                    return UniqueMessagePositions.super.isHidden(m, ctx);
                }
            };
            Run run = this.compiler.newRun(this.myInitCtx.fresh().setReporter((Reporter)((Object)reporter)));
            Contexts.Context ctx = this.myCtx = run.runContext();
            this.myOpenedFiles.update((Object)uri, (Object)source);
            run.compileSources((List<SourceFile>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SourceFile[]{source}))));
            run.printSummary();
            CompilationUnit unit = ctx.run().units().nonEmpty() ? (CompilationUnit)ctx.run().units().head() : (CompilationUnit)ctx.run().suspendedUnits().head();
            Trees.Tree t = unit.tpdTree();
            this.cleanup(t, ctx);
            this.myOpenedTrees.update((Object)uri, this.topLevelTrees(t, source));
            this.myCompilationUnits.update((Object)uri, (Object)unit);
            list = ((StoreReporter)((Object)reporter)).removeBufferedMessages(ctx);
        }
        catch (FatalError ex) {
            this.myCtx = previousCtx;
            this.close(uri);
            list = package$.MODULE$.Nil();
        }
        return list;
    }

    public void close(URI uri) {
        this.myOpenedFiles.remove((Object)uri);
        this.myOpenedTrees.remove((Object)uri);
        this.myCompilationUnits.remove((Object)uri);
    }

    private List<SourceTree> treesFromClassName(Names.TypeName className, String id, Contexts.Context ctx) {
        List list = InteractiveDriver.trees$1(ctx, className, id);
        Names.TypeName typeName = NameOps$.MODULE$.NameDecorator(className);
        return InteractiveDriver.trees$1(ctx, NameOps$NameDecorator$.MODULE$.moduleClassName$extension(typeName), id).$colon$colon$colon(list);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Names.TypeName> dirClassPathClasses() {
        void var1_1;
        ListBuffer names = new ListBuffer();
        this.dirClassPaths.foreach((Function1)(JProcedure1 & Serializable)dirCp -> {
            Path root = ((File)dirCp.dir()).toPath();
            this.classesFromDir(root, (ListBuffer<Names.TypeName>)names);
        });
        return var1_1;
    }

    private void classesFromZip(File file, ListBuffer<Names.TypeName> buffer) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                Option option = this.dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffixes.find((Function1)(JFunction1 & Serializable)x$0 -> name.endsWith((String)x$0));
                if (!(option instanceof Some)) continue;
                String tastySuffix = (String)((Some)option).value();
                buffer.$plus$eq((Object)Decorators$PreNamedString$.MODULE$.toTypeName$extension(Decorators$.MODULE$.PreNamedString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(name.replace("/", ".")), tastySuffix))));
            }
        }
    }

    private void classesFromDir(Path dir, ListBuffer<Names.TypeName> buffer) {
        try {
            Files.walkFileTree(dir, new SimpleFileVisitor(dir, buffer, this){
                private final Path dir$1;
                private final ListBuffer buffer$1;
                private final InteractiveDriver $outer;
                {
                    this.dir$1 = dir$3;
                    this.buffer$1 = buffer$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    if (!attrs.isDirectory()) {
                        String name = path.getFileName().toString();
                        this.dotty$tools$dotc$interactive$InteractiveDriver$_$$anon$$$outer().dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffixes.withFilter((Function1)((JFunction1 & Serializable)arg_0 -> InteractiveDriver.dotty$tools$dotc$interactive$InteractiveDriver$$anon$6$$_$visitFile$$anonfun$1(name, arg_0))).foreach((Function1)(JFunction1 & Serializable)tastySuffix -> (ListBuffer)this.buffer$1.$plus$eq((Object)Decorators$PreNamedString$.MODULE$.toTypeName$extension(Decorators$.MODULE$.PreNamedString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.dir$1.relativize(path).toString().replace("/", ".")), tastySuffix)))));
                    }
                    return FileVisitResult.CONTINUE;
                }

                private InteractiveDriver $outer() {
                    return this.$outer;
                }

                public final InteractiveDriver dotty$tools$dotc$interactive$InteractiveDriver$_$$anon$$$outer() {
                    return this.$outer();
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{dotty$tools$dotc$interactive$InteractiveDriver$$anon$6$$_$visitFile$$anonfun$1(java.lang.String java.lang.String ), visitFile$$anonfun$1(java.nio.file.Path java.lang.String )}, serializedLambda);
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {}
    }

    private List<SourceTree> topLevelTrees(Trees.Tree<Types.Type> topTree, SourceFile source) {
        ListBuffer trees = new ListBuffer();
        InteractiveDriver.addTrees$1(source, trees, topTree);
        return trees.toList();
    }

    private void cleanup(Trees.Tree tree, Contexts.Context ctx) {
        Set seen = (Set)Set$.MODULE$.empty();
        InteractiveDriver.cleanupTree$1(ctx, seen, tree);
    }

    private SourceFile toSource(URI uri, String sourceCode) {
        Path path = Paths.get(uri);
        VirtualFile virtualFile = new VirtualFile(path.getFileName().toString(), path.toString());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(virtualFile.output(), "UTF-8"));
        writer.write(sourceCode);
        writer.close();
        return new SourceFile((AbstractFile)virtualFile, Codec$.MODULE$.UTF8());
    }

    private void initialize() {
        Run run = this.compiler.newRun(this.myInitCtx.fresh());
        this.myCtx = run.runContext();
        run.compileUnits((List<CompilationUnit>)package$.MODULE$.Nil(), this.myCtx);
    }

    private static final List trees$1(Contexts.Context ctx$1157, Names.TypeName className, String id) {
        List<SourceTree> list;
        Denotations.Denotation clsd = ctx$1157.base().staticRef(className, ctx$1157.base().staticRef$default$2(), ctx$1157.base().staticRef$default$3(), ctx$1157);
        Denotations.Denotation denotation = clsd;
        if (denotation instanceof SymDenotations.ClassDenotation) {
            SymDenotations.ClassDenotation clsd2 = (SymDenotations.ClassDenotation)denotation;
            clsd2.ensureCompleted(ctx$1157);
            list = SourceTree$.MODULE$.fromSymbol(clsd2.symbol().asClass(), id, ctx$1157);
        } else {
            list = package$.MODULE$.Nil();
        }
        return list;
    }

    public static final /* synthetic */ boolean dotty$tools$dotc$interactive$InteractiveDriver$$anon$6$$_$visitFile$$anonfun$1(String name$132, String tastySuffix) {
        return name$132.endsWith(tastySuffix);
    }

    private static final void addTrees$1(SourceFile source$7, ListBuffer trees$3, Trees.Tree tree2) {
        block1: {
            Trees.Tree tree3;
            block2: {
                block0: {
                    List list;
                    tree3 = tree2;
                    if (!(tree3 instanceof Trees.PackageDef)) break block0;
                    Trees.PackageDef packageDef = Trees$PackageDef$.MODULE$.unapply((Trees.PackageDef)tree3);
                    Trees.RefTree refTree = packageDef._1();
                    List stats = list = packageDef._2();
                    stats.foreach((Function1)(JProcedure1 & Serializable)tree -> InteractiveDriver.addTrees$1(source$7, trees$3, tree));
                    break block1;
                }
                if (!(tree3 instanceof Trees.Import)) break block2;
                Trees.Import imp = (Trees.Import)tree3;
                trees$3.$plus$eq((Object)SourceTree$.MODULE$.apply(imp, source$7));
                break block1;
            }
            if (!(tree3 instanceof Trees.TypeDef)) break block1;
            Trees.TypeDef tree4 = (Trees.TypeDef)tree3;
            trees$3.$plus$eq((Object)SourceTree$.MODULE$.apply(tree4, source$7));
        }
    }

    private static final void cleanupTree$1(Contexts.Context ctx$1158, Set seen$1, Trees.Tree tree) {
        seen$1.$plus$eq((Object)tree);
        Trees.Tree tree2 = tpd$.MODULE$.TreeOps(tree);
        tpd$TreeOps$.MODULE$.foreachSubTree$extension(tree2, (Function1<Trees.Tree<Types.Type>, BoxedUnit>)(JProcedure1 & Serializable)t -> {
            if (Symbols$.MODULE$.toDenot(t.symbol(ctx$1158), ctx$1158).exists() && t.hasType()) {
                if (!Symbols$.MODULE$.toDenot(t.symbol(ctx$1158), ctx$1158).isCompleted()) {
                    Symbols$.MODULE$.toDenot(t.symbol(ctx$1158), ctx$1158).info_$eq(Types$UnspecifiedErrorType$.MODULE$);
                }
                Symbols$.MODULE$.toDenot(t.symbol(ctx$1158), ctx$1158).annotations(ctx$1158).foreach((Function1)(JProcedure1 & Serializable)annot -> {
                    if (annot.isEvaluated() && !seen$1.apply((Object)annot.tree(ctx$1158))) {
                        InteractiveDriver.cleanupTree$1(ctx$1158, seen$1, annot.tree(ctx$1158));
                    }
                });
            }
            t.removeAllAttachments();
        }, ctx$1158);
    }
}

