/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.DottyPredef$;
import dotty.tools.io.AbstractFile$;
import dotty.tools.io.File;
import dotty.tools.io.Path;
import dotty.tools.io.Path$;
import dotty.tools.io.PlainFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import scala.Char$;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class AbstractFile
implements Iterable<AbstractFile> {
    private final String extension;

    public static AbstractFile getDirectory(java.nio.file.Path path) {
        return AbstractFile$.MODULE$.getDirectory(path);
    }

    public static AbstractFile getDirectory(Path path) {
        return AbstractFile$.MODULE$.getDirectory(path);
    }

    public static AbstractFile getDirectory(String string) {
        return AbstractFile$.MODULE$.getDirectory(string);
    }

    public static AbstractFile getFile(java.nio.file.Path path) {
        return AbstractFile$.MODULE$.getFile(path);
    }

    public static AbstractFile getFile(Path path) {
        return AbstractFile$.MODULE$.getFile(path);
    }

    public static AbstractFile getFile(String string) {
        return AbstractFile$.MODULE$.getFile(string);
    }

    public static AbstractFile getResources(URL uRL) {
        return AbstractFile$.MODULE$.getResources(uRL);
    }

    public static AbstractFile getURL(URL uRL) {
        return AbstractFile$.MODULE$.getURL(uRL);
    }

    public AbstractFile() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        this.extension = Path$.MODULE$.extension(this.name());
    }

    public abstract String name();

    public abstract String path();

    public String absolutePath() {
        return this.path();
    }

    public String canonicalPath() {
        return this.jpath() == null ? this.path() : this.jpath().normalize().toString();
    }

    public boolean hasExtension(String other) {
        String string = this.extension();
        String string2 = other.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public String extension() {
        return this.extension;
    }

    public abstract AbstractFile absolute();

    public abstract AbstractFile container();

    public java.io.File file() {
        java.io.File file;
        block3: {
            try {
                if (this.jpath() == null) {
                    file = null;
                    break block3;
                }
                file = this.jpath().toFile();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                file = null;
            }
        }
        return file;
    }

    public abstract java.nio.file.Path jpath();

    public Option<AbstractFile> underlyingSource() {
        return None$.MODULE$;
    }

    public boolean exists() {
        return this.jpath() == null || Files.exists(this.jpath(), new LinkOption[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClassContainer() {
        if (this.isDirectory()) return true;
        if (this.jpath() == null) return false;
        String string = this.extension();
        String string2 = "jar";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = this.extension();
        String string4 = "zip";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public abstract void create();

    public abstract void delete();

    public abstract boolean isDirectory();

    public boolean isVirtual() {
        return false;
    }

    public abstract long lastModified();

    public abstract InputStream input();

    public abstract OutputStream output();

    public BufferedOutputStream bufferedOutput() {
        return new BufferedOutputStream(this.output());
    }

    public Option<Object> sizeOption() {
        return None$.MODULE$;
    }

    public URL toURL() {
        return this.jpath() == null ? null : this.jpath().toUri().toURL();
    }

    public char[] toCharArray() {
        return new String(this.toByteArray()).toCharArray();
    }

    public byte[] toByteArray() {
        byte[] byArray;
        InputStream in = this.input();
        Option<Object> option = this.sizeOption();
        if (option instanceof Some) {
            int size;
            int res;
            int rest;
            byte[] arr = new byte[rest];
            for (rest = size = BoxesRunTime.unboxToInt((Object)((Some)option).value()); rest > 0; rest -= res) {
                res = in.read(arr, arr.length - rest, rest);
                if (res != -1) continue;
                throw new IOException("read error");
            }
            in.close();
            byArray = arr;
        } else if (None$.MODULE$.equals(option)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = in.read();
            while (c != -1) {
                out.write(c);
                c = in.read();
            }
            in.close();
            byArray = out.toByteArray();
        } else {
            throw new MatchError(option);
        }
        return byArray;
    }

    public abstract Iterator<AbstractFile> iterator();

    public abstract AbstractFile lookupName(String var1, boolean var2);

    public abstract AbstractFile lookupNameUnchecked(String var1, boolean var2);

    public AbstractFile lookupPathUnchecked(String path, boolean directory) {
        return this.lookup((Function3<AbstractFile, String, Object, AbstractFile>)((Function3 & Serializable)AbstractFile::lookupPathUnchecked$$anonfun$adapted$1), path, directory);
    }

    private AbstractFile lookup(Function3<AbstractFile, String, Object, AbstractFile> getFile, String path0, boolean directory) {
        BoxedUnit boxedUnit;
        char separator = java.io.File.separatorChar;
        String path = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path0)) == separator ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(path0), 1) : path0;
        int length = path.length();
        if (length <= 0 || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path)) == separator) {
            DottyPredef$.MODULE$.assertFail(() -> AbstractFile.lookup$$anonfun$1(path));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        AbstractFile file = this;
        IntRef start = IntRef.create((int)0);
        while (true) {
            int n;
            BoxedUnit boxedUnit2;
            int index = path.indexOf(Char$.MODULE$.char2int(separator), start.elem);
            if (index >= 0 && start.elem >= index) {
                DottyPredef$.MODULE$.assertFail(() -> AbstractFile.lookup$$anonfun$2(directory, path, start, index));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            String name = path.substring(start.elem, index < 0 ? length : index);
            file = (AbstractFile)getFile.apply((Object)file, (Object)name, (Object)(index < 0 ? BoxesRunTime.boxToBoolean((boolean)directory) : BoxesRunTime.boxToBoolean((boolean)true)));
            if (file == null || index < 0) {
                return file;
            }
            start.elem = n = index + 1;
        }
        return file;
    }

    private AbstractFile fileOrSubdirectoryNamed(String name, boolean isDir) {
        AbstractFile abstractFile;
        AbstractFile lookup = this.lookupName(name, isDir);
        if (lookup != null) {
            abstractFile = lookup;
        } else {
            Files.createDirectories(this.jpath(), new FileAttribute[0]);
            java.nio.file.Path path = this.jpath().resolve(name);
            java.nio.file.Path path2 = isDir ? Files.createDirectory(path, new FileAttribute[0]) : Files.createFile(path, new FileAttribute[0]);
            abstractFile = new PlainFile(new File(path, Codec$.MODULE$.fallbackSystemCodec()));
        }
        return abstractFile;
    }

    public AbstractFile fileNamed(String name) {
        BoxedUnit boxedUnit;
        if (!this.isDirectory()) {
            DottyPredef$.MODULE$.assertFail(() -> this.fileNamed$$anonfun$1(name));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.fileOrSubdirectoryNamed(name, false);
    }

    public AbstractFile subdirectoryNamed(String name) {
        BoxedUnit boxedUnit;
        if (!this.isDirectory()) {
            DottyPredef$.MODULE$.assertFail(() -> this.subdirectoryNamed$$anonfun$1(name));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.fileOrSubdirectoryNamed(name, true);
    }

    public Nothing$ unsupported() {
        return this.unsupported(null);
    }

    public Nothing$ unsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    public String toString() {
        return this.path();
    }

    private static final AbstractFile lookupPathUnchecked$$anonfun$adapted$1(Object f, Object p, Object dir) {
        return ((AbstractFile)f).lookupNameUnchecked((String)p, BoxesRunTime.unboxToBoolean((Object)dir));
    }

    private static final String lookup$$anonfun$1(String path$18) {
        return path$18;
    }

    private static final Tuple4 lookup$$anonfun$2(boolean directory$1, String path$19, IntRef start$64, int index$15) {
        return Tuple4$.MODULE$.apply((Object)path$19, (Object)BoxesRunTime.boxToBoolean((boolean)directory$1), (Object)BoxesRunTime.boxToInteger((int)start$64.elem), (Object)BoxesRunTime.boxToInteger((int)index$15));
    }

    private final String fileNamed$$anonfun$1(String name$213) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tried to find '%s' in '%s' but it is not a directory"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name$213, this.path()}));
    }

    private final String subdirectoryNamed$$anonfun$1(String name$214) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tried to find '%s' in '%s' but it is not a directory"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name$214, this.path()}));
    }
}

