/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.config.CommandLineParser$;
import dotty.tools.dotc.config.Properties$;
import dotty.tools.dotc.config.ScalaSettings;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.Message$;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class CompilerCommand$
implements Serializable {
    public static final CompilerCommand$ MODULE$;

    static {
        new CompilerCommand$();
    }

    private CompilerCommand$() {
        MODULE$ = this;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CompilerCommand$.class);
    }

    public String cmdName() {
        return "dotc";
    }

    private String explainAdvanced() {
        return "\n    |-- Notes on option parsing --\n    |Boolean settings are always false unless set.\n    |Where multiple values are accepted, they should be comma-separated.\n    |  example: -Xplugin:plugin1,plugin2\n    |<phases> means one or a comma-separated list of:\n    |  - (partial) phase names with an optional \"+\" suffix to include the next phase\n    |  - the string \"all\"\n    |  example: -Xprint:all prints all phases.\n    |  example: -Xprint:typer,mixin prints the typer and mixin phases.\n    |  example: -Ylog:erasure+ logs the erasure phase and the phase after the erasure phase.\n    |           This is useful because during the tree transform of phase X, we often\n    |           already are in phase X + 1.\n  ";
    }

    public String shortUsage() {
        return "Usage: " + this.cmdName() + " <options> <source files>";
    }

    public String versionMsg() {
        return "Dotty compiler " + Properties$.MODULE$.versionString() + " -- " + Properties$.MODULE$.copyrightString();
    }

    public Settings.ArgsSummary distill(String[] args, Contexts.Context ctx) {
        return ctx.settings().processArguments((List<String>)this.expandedArguments$1(args), true, ctx);
    }

    public List<String> checkUsage(Settings.ArgsSummary summary, boolean sourcesRequired, Contexts.Context ctx) {
        Nil$ nil$;
        ScalaSettings settings = ctx.settings();
        summary.warnings().foreach((Function1)(JProcedure1 & Serializable)_$7 -> ctx.warning(() -> this.checkUsage$$anonfun$7$$anonfun$1(_$7), ctx.warning$default$2()));
        if (summary.errors().nonEmpty()) {
            summary.errors().foreach((Function1)(JProcedure1 & Serializable)_$8 -> ctx.error(() -> this.checkUsage$$anonfun$8$$anonfun$1(_$8), ctx.error$default$2(), ctx.error$default$3()));
            ctx.echo(this::checkUsage$$anonfun$3, ctx.echo$default$2());
            nil$ = package$.MODULE$.Nil();
        } else {
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(settings.version());
            if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx))) {
                ctx.echo(this::checkUsage$$anonfun$4, ctx.echo$default$2());
                nil$ = package$.MODULE$.Nil();
            } else if (this.shouldStopWithInfo$1(ctx, settings)) {
                ctx.echo(() -> this.checkUsage$$anonfun$5(ctx, settings), ctx.echo$default$2());
                nil$ = package$.MODULE$.Nil();
            } else {
                if (sourcesRequired && summary.arguments().isEmpty()) {
                    ctx.echo(() -> this.checkUsage$$anonfun$6(ctx), ctx.echo$default$2());
                }
                nil$ = summary.arguments();
            }
        }
        return nil$;
    }

    private final /* synthetic */ boolean stripComment$1$$anonfun$1(char _$1) {
        return _$1 != '#';
    }

    private final boolean stripComment$2$$anonfun$adapted$1(Object _$1) {
        return this.stripComment$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1));
    }

    private final String stripComment$3(String s) {
        return StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(s), (Function1)((JFunction1 & Serializable)this::stripComment$2$$anonfun$adapted$1));
    }

    private final List expandArg$1(String arg) {
        Path path = Paths.get(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(arg), "@"), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("argument file %s could not be found"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{path.getFileName()})));
        }
        java.util.List<String> lines = Files.readAllLines(path);
        String params = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(lines).asScala()).map((Function1)(JFunction1 & Serializable)s -> this.stripComment$3((String)s))).mkString(" ");
        return CommandLineParser$.MODULE$.tokenize(params);
    }

    private final List expandedArguments$1(String[] args$1) {
        return Predef$.MODULE$.wrapRefArray((Object[])args$1).toList().flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            List list;
            String string = x$1;
            String x = string;
            if (x.startsWith("@")) {
                list = this.expandArg$1(x);
            } else {
                String x2 = string;
                list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{x2}));
            }
            return list;
        });
    }

    private final String format$1(int width$1, String s) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%-" + width$1 + "s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s}));
    }

    private final String defaultValue$1(Settings.Setting s$1) {
        Object t = s$1.default();
        return t instanceof Integer || t instanceof String ? s$1.default().toString() : "";
    }

    private final String formatSetting$1(int width$3, String name, String value) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value)) ? "\n" + this.format$1(width$3, "") + " " + name + ": " + value + "." : "";
    }

    private final String helpStr$1(int width$2, Settings.Setting s) {
        return "" + this.format$1(width$2, s.name()) + " " + s.description() + this.formatSetting$1(width$2, "Default", this.defaultValue$1(s)) + this.formatSetting$1(width$2, "Choices", s.legalChoices());
    }

    private final String availableOptionsMsg$2(Contexts.Context ctx$1, Function1 cond) {
        List ss = (List)((IterableOnceOps)ctx$1.settings().allSettings().filter(cond)).toList().sortBy((Function1)(JFunction1 & Serializable)_$2 -> _$2.name(), (Ordering)Ordering.String$.MODULE$);
        int width = BoxesRunTime.unboxToInt((Object)ss.map((Function1)(JFunction1 & Serializable)_$3 -> _$3.name().length()).max((Ordering)Ordering.Int$.MODULE$));
        return ss.map((Function1)(JFunction1 & Serializable)s -> this.helpStr$1(width, (Settings.Setting)s)).mkString("\n");
    }

    private final String createUsageMsg$1(Contexts.Context ctx$7, String label, boolean shouldExplain, Function1 cond) {
        String prefix = ((IterableOnceOps)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Some$.MODULE$.apply((Object)this.shortUsage()), Some$.MODULE$.apply((Object)this.explainAdvanced()).filter((Function1)(JFunction1 & Serializable)_$4 -> shouldExplain), Some$.MODULE$.apply((Object)(label + " options include:"))}))).flatten(Predef$.MODULE$.$conforms())).mkString("\n");
        return prefix + "\n" + this.availableOptionsMsg$2(ctx$7, cond);
    }

    private final boolean isStandard$1(Settings.Setting s) {
        return !this.isAdvanced$1(s) && !this.isPrivate$1(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAdvanced$1(Settings.Setting s) {
        if (!s.name().startsWith("-X")) return false;
        String string = s.name();
        String string2 = "-X";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPrivate$1(Settings.Setting s) {
        if (!s.name().startsWith("-Y")) return false;
        String string = s.name();
        String string2 = "-Y";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    private final String usageMessage$2(Contexts.Context ctx$8) {
        return this.createUsageMsg$1(ctx$8, "where possible standard", false, (Function1)(JFunction1 & Serializable)s -> this.isStandard$1((Settings.Setting)s));
    }

    private final String xusageMessage$2(Contexts.Context ctx$9) {
        return this.createUsageMsg$1(ctx$9, "Possible advanced", true, (Function1)(JFunction1 & Serializable)s -> this.isAdvanced$1((Settings.Setting)s));
    }

    private final String yusageMessage$2(Contexts.Context ctx$10) {
        return this.createUsageMsg$1(ctx$10, "Possible private", true, (Function1)(JFunction1 & Serializable)s -> this.isPrivate$1((Settings.Setting)s));
    }

    private final boolean shouldStopWithInfo$1(Contexts.Context ctx$2, ScalaSettings settings$1) {
        return ((IterableOnceOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Settings.Setting[]{settings$1.help(), settings$1.Xhelp(), settings$1.Yhelp(), settings$1.showPlugins(), settings$1.XshowPhases()}))).exists((Function1)(JFunction1 & Serializable)_$5 -> {
            Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(_$5);
            return BoxesRunTime.unboxToBoolean(Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx$2));
        });
    }

    private final String phasesMessage$3() {
        return new Compiler().phases().map((Function1)(JFunction1 & Serializable)x$1 -> {
            String string;
            SeqOps seqOps;
            SeqOps seqOps2;
            List list = x$1;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.List().unapplySeq((SeqOps)list)) && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0) {
                Phases.Phase phase;
                Phases.Phase single = phase = (Phases.Phase)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                string = single.phaseName();
            } else {
                List more = list;
                string = more.map((Function1)(JFunction1 & Serializable)_$6 -> _$6.phaseName()).mkString("{", ", ", "}");
            }
            return string;
        }).mkString("\n");
    }

    private final String infoMessage$1(Contexts.Context ctx$4, ScalaSettings settings$2) {
        Settings.Setting<Object> setting;
        Settings.Setting<Object> setting2;
        Settings.Setting<Object> setting3;
        Settings.Setting<Object> setting4;
        Settings.Setting<Object> setting5 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.help());
        return BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting5, ctx$4)) ? this.usageMessage$2(ctx$4) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting4 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.Xhelp()), ctx$4)) ? this.xusageMessage$2(ctx$4) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting3 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.Yhelp()), ctx$4)) ? this.yusageMessage$2(ctx$4) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.showPlugins()), ctx$4)) ? ctx$4.pluginDescriptions() : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting = Settings$Setting$.MODULE$.SettingDecorator(settings$2.XshowPhases()), ctx$4)) ? this.phasesMessage$3() : ""))));
    }

    private final Message checkUsage$$anonfun$7$$anonfun$1(String _$7$1) {
        return Message$.MODULE$.toNoExplanation(_$7$1);
    }

    private final Message checkUsage$$anonfun$8$$anonfun$1(String _$8$1) {
        return Message$.MODULE$.toNoExplanation(_$8$1);
    }

    private final String checkUsage$$anonfun$3() {
        return "  dotc -help  gives more information";
    }

    private final String checkUsage$$anonfun$4() {
        return this.versionMsg();
    }

    private final String checkUsage$$anonfun$5(Contexts.Context ctx$11, ScalaSettings settings$3) {
        return this.infoMessage$1(ctx$11, settings$3);
    }

    private final String checkUsage$$anonfun$6(Contexts.Context ctx$12) {
        return this.usageMessage$2(ctx$12);
    }
}

