/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.semanticdb.internal;

import dotty.tools.dotc.semanticdb.internal.Internal$;
import dotty.tools.dotc.semanticdb.internal.SemanticdbOutputStream;
import dotty.tools.dotc.semanticdb.internal.WireFormat$;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.runtime.ModuleSerializationProxy;

public final class SemanticdbOutputStream$
implements Serializable {
    public static final SemanticdbOutputStream$ MODULE$;
    private final int DEFAULT_BUFFER_SIZE;
    private final int LITTLE_ENDIAN_32_SIZE;
    private final int LITTLE_ENDIAN_64_SIZE;

    static {
        new SemanticdbOutputStream$();
    }

    private SemanticdbOutputStream$() {
        MODULE$ = this;
        this.DEFAULT_BUFFER_SIZE = 4096;
        this.LITTLE_ENDIAN_32_SIZE = 4;
        this.LITTLE_ENDIAN_64_SIZE = 8;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SemanticdbOutputStream$.class);
    }

    public int DEFAULT_BUFFER_SIZE() {
        return this.DEFAULT_BUFFER_SIZE;
    }

    public int computePreferredBufferSize(int dataLength) {
        if (dataLength > this.DEFAULT_BUFFER_SIZE()) {
            return this.DEFAULT_BUFFER_SIZE();
        }
        return dataLength;
    }

    public SemanticdbOutputStream newInstance(OutputStream output) {
        return this.newInstance(output, this.DEFAULT_BUFFER_SIZE());
    }

    public SemanticdbOutputStream newInstance(OutputStream output, int bufferSize) {
        return new SemanticdbOutputStream(output, new byte[bufferSize]);
    }

    public SemanticdbOutputStream newInstance(ByteBuffer byteBuffer) {
        return this.newInstance(byteBuffer, this.DEFAULT_BUFFER_SIZE());
    }

    public SemanticdbOutputStream newInstance(byte[] b) {
        return new SemanticdbOutputStream(null, b);
    }

    public SemanticdbOutputStream newInstance(ByteBuffer byteBuffer, int bufferSize) {
        return this.newInstance(new SemanticdbOutputStream.ByteBufferOutputStream(byteBuffer), bufferSize);
    }

    public int computeDoubleSize(int fieldNumber, double value) {
        return this.computeTagSize(fieldNumber) + this.computeDoubleSizeNoTag(value);
    }

    public int computeFloatSize(int fieldNumber, float value) {
        return this.computeTagSize(fieldNumber) + this.computeFloatSizeNoTag(value);
    }

    public int computeUInt64Size(int fieldNumber, long value) {
        return this.computeTagSize(fieldNumber) + this.computeUInt64SizeNoTag(value);
    }

    public int computeInt64Size(int fieldNumber, long value) {
        return this.computeTagSize(fieldNumber) + this.computeInt64SizeNoTag(value);
    }

    public int computeInt32Size(int fieldNumber, int value) {
        return this.computeTagSize(fieldNumber) + this.computeInt32SizeNoTag(value);
    }

    public int computeFixed64Size(int fieldNumber, long value) {
        return this.computeTagSize(fieldNumber) + this.computeFixed64SizeNoTag(value);
    }

    public int computeFixed32Size(int fieldNumber, int value) {
        return this.computeTagSize(fieldNumber) + this.computeFixed32SizeNoTag(value);
    }

    public int computeBoolSize(int fieldNumber, boolean value) {
        return this.computeTagSize(fieldNumber) + this.computeBoolSizeNoTag(value);
    }

    public int computeStringSize(int fieldNumber, String value) {
        return this.computeTagSize(fieldNumber) + this.computeStringSizeNoTag(value);
    }

    public int computeByteArraySize(int fieldNumber, byte[] value) {
        return this.computeTagSize(fieldNumber) + this.computeByteArraySizeNoTag(value);
    }

    public int computeByteBufferSize(int fieldNumber, ByteBuffer value) {
        return this.computeTagSize(fieldNumber) + this.computeByteBufferSizeNoTag(value);
    }

    public int computeUInt32Size(int fieldNumber, int value) {
        return this.computeTagSize(fieldNumber) + this.computeUInt32SizeNoTag(value);
    }

    public int computeEnumSize(int fieldNumber, int value) {
        return this.computeTagSize(fieldNumber) + this.computeEnumSizeNoTag(value);
    }

    public int computeSFixed32Size(int fieldNumber, int value) {
        return this.computeTagSize(fieldNumber) + this.computeSFixed32SizeNoTag(value);
    }

    public int computeSFixed64Size(int fieldNumber, long value) {
        return this.computeTagSize(fieldNumber) + this.computeSFixed64SizeNoTag(value);
    }

    public int computeSInt32Size(int fieldNumber, int value) {
        return this.computeTagSize(fieldNumber) + this.computeSInt32SizeNoTag(value);
    }

    public int computeSInt64Size(int fieldNumber, long value) {
        return this.computeTagSize(fieldNumber) + this.computeSInt64SizeNoTag(value);
    }

    public int computeDoubleSizeNoTag(double value) {
        return this.LITTLE_ENDIAN_64_SIZE();
    }

    public int computeFloatSizeNoTag(float value) {
        return this.LITTLE_ENDIAN_32_SIZE();
    }

    public int computeUInt64SizeNoTag(long value) {
        return this.computeRawVarint64Size(value);
    }

    public int computeInt64SizeNoTag(long value) {
        return this.computeRawVarint64Size(value);
    }

    public int computeInt32SizeNoTag(int value) {
        return value >= 0 ? this.computeRawVarint32Size(value) : 10;
    }

    public int computeFixed64SizeNoTag(long value) {
        return this.LITTLE_ENDIAN_64_SIZE();
    }

    public int computeFixed32SizeNoTag(int value) {
        return this.LITTLE_ENDIAN_32_SIZE();
    }

    public int computeBoolSizeNoTag(boolean value) {
        return 1;
    }

    public int computeStringSizeNoTag(String value) {
        byte[] bytes = value.getBytes(Internal$.MODULE$.UTF_8());
        return this.computeRawVarint32Size(bytes.length) + bytes.length;
    }

    public int computeByteArraySizeNoTag(byte[] value) {
        return this.computeRawVarint32Size(value.length) + value.length;
    }

    public int computeByteBufferSizeNoTag(ByteBuffer value) {
        return this.computeRawVarint32Size(value.capacity()) + value.capacity();
    }

    public int computeUInt32SizeNoTag(int value) {
        return this.computeRawVarint32Size(value);
    }

    public int computeEnumSizeNoTag(int value) {
        return this.computeInt32SizeNoTag(value);
    }

    public int computeSFixed32SizeNoTag(int value) {
        return this.LITTLE_ENDIAN_32_SIZE();
    }

    public int computeSFixed64SizeNoTag(long value) {
        return this.LITTLE_ENDIAN_64_SIZE();
    }

    public int computeSInt32SizeNoTag(int value) {
        return this.computeRawVarint32Size(this.encodeZigZag32(value));
    }

    public int computeSInt64SizeNoTag(long value) {
        return this.computeRawVarint64Size(this.encodeZigZag64(value));
    }

    public int computeTagSize(int fieldNumber) {
        return this.computeRawVarint32Size(WireFormat$.MODULE$.makeTag(fieldNumber, 0));
    }

    public int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public int computeRawVarint64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public int LITTLE_ENDIAN_32_SIZE() {
        return this.LITTLE_ENDIAN_32_SIZE;
    }

    public int LITTLE_ENDIAN_64_SIZE() {
        return this.LITTLE_ENDIAN_64_SIZE;
    }

    public int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }
}

