/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.runtime.function.JFunction1;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.tpd$;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$PhaseListDecorator$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.TypeError;
import dotty.tools.dotc.reporting.diagnostic.ExtendMessage;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.Message$;
import dotty.tools.dotc.reporting.diagnostic.messages;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourcePosition;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public interface Reporting {
    default public void inform(Function0 msg, SourcePosition pos) {
        Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(((Contexts.Context)this).settings().verbose());
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) {
            this.echo(msg, pos);
        }
    }

    default public NoSourcePosition$ inform$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void echo(Function0 msg, SourcePosition pos) {
        ((Contexts.Context)this).reporter().report(new messages.Info(() -> Reporting.echo$$anonfun$1(msg), pos), ((Contexts.Context)this).ctx());
    }

    default public NoSourcePosition$ echo$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void reportWarning(messages.Warning warning) {
        Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(((Contexts.Context)this).settings().silentWarnings());
        if (!BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) {
            Settings.Setting<Object> setting2 = Settings$Setting$.MODULE$.SettingDecorator(((Contexts.Context)this).settings().XfatalWarnings());
            if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2, ((Contexts.Context)this).ctx()))) {
                messages.ConditionalWarning warning2;
                Settings.Setting<Object> setting3;
                messages.Warning warning3 = warning;
                if (warning3 instanceof messages.ConditionalWarning && !BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting3 = Settings$Setting$.MODULE$.SettingDecorator((warning2 = (messages.ConditionalWarning)warning3).enablingOption(((Contexts.Context)this).ctx())), ((Contexts.Context)this).ctx()))) {
                    ((Contexts.Context)this).reporter().report(warning2, ((Contexts.Context)this).ctx());
                } else {
                    ((Contexts.Context)this).reporter().report(warning.toError(), ((Contexts.Context)this).ctx());
                }
            } else {
                ((Contexts.Context)this).reporter().report(warning, ((Contexts.Context)this).ctx());
            }
        }
    }

    default public void deprecationWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.DeprecationWarning(msg, pos));
    }

    default public NoSourcePosition$ deprecationWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void migrationWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.MigrationWarning(msg, pos));
    }

    default public NoSourcePosition$ migrationWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void uncheckedWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.UncheckedWarning(msg, pos));
    }

    default public NoSourcePosition$ uncheckedWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void featureWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.FeatureWarning(msg, pos));
    }

    default public NoSourcePosition$ featureWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void featureWarning(String feature, String featureDescription, Symbols.Symbol featureUseSite, boolean required, SourcePosition pos) {
        String string;
        String req = required ? "needs to" : "should";
        String fqname = "scala.language." + feature;
        if (((Contexts.Context)this).reporter().isReportedFeatureUseSite(featureUseSite)) {
            string = "";
        } else {
            ((Contexts.Context)this).reporter().reportNewFeatureUseSite(featureUseSite);
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |See the Scala docs for value " + fqname + " for a discussion\n           |why the feature " + req + " be explicitly enabled."));
        }
        String explain = string;
        String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("" + featureDescription + " " + req + " be enabled\n                 |by adding the import clause 'import " + fqname + "'\n                 |or by setting the compiler option -language:" + feature + "." + explain));
        if (required) {
            this.error(() -> Reporting.featureWarning$$anonfun$1(msg), pos, this.error$default$3());
        } else {
            this.reportWarning(new messages.FeatureWarning(() -> Reporting.featureWarning$$anonfun$2(msg), pos));
        }
    }

    default public void warning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.Warning(msg, Reporting.super.addInlineds(pos, ((Contexts.Context)this).ctx())));
    }

    default public NoSourcePosition$ warning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void strictWarning(Function0 msg, SourcePosition pos) {
        SourcePosition fullPos = Reporting.super.addInlineds(pos, ((Contexts.Context)this).ctx());
        Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(((Contexts.Context)this).settings().strict());
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) {
            this.error(msg, fullPos, this.error$default$3());
        } else {
            this.reportWarning(new ExtendMessage((Function0<Message>)(Function0 & Serializable)() -> (Message)msg.apply(), (Function1<String, String>)(JFunction1 & Serializable)_$1 -> _$1 + "\n(This would be an error under strict mode)").warning(fullPos));
        }
    }

    default public NoSourcePosition$ strictWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void error(Function0 msg, SourcePosition pos, boolean sticky) {
        SourcePosition fullPos = Reporting.super.addInlineds(pos, ((Contexts.Context)this).ctx());
        ((Contexts.Context)this).reporter().report(sticky ? new messages.StickyError(msg, fullPos) : new messages.Error(msg, fullPos), ((Contexts.Context)this).ctx());
        Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(((Contexts.Context)this).ctx().settings().YdebugError());
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) {
            Thread.dumpStack();
        }
    }

    default public NoSourcePosition$ error$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public boolean error$default$3() {
        return false;
    }

    default public void error(TypeError ex, SourcePosition pos) {
        this.error(() -> this.error$$anonfun$1(ex), pos, true);
        Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(((Contexts.Context)this).ctx().settings().YdebugTypeError());
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) {
            ex.printStackTrace();
        }
    }

    default public void errorOrMigrationWarning(Function0 msg, SourcePosition pos) {
        if (((Contexts.Context)this).ctx().scala2CompatMode()) {
            this.migrationWarning(msg, pos);
        } else {
            this.error(msg, pos, this.error$default$3());
        }
    }

    default public NoSourcePosition$ errorOrMigrationWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void restrictionError(Function0 msg, SourcePosition pos) {
        ((Contexts.Context)this).reporter().report(new ExtendMessage((Function0<Message>)(Function0 & Serializable)() -> (Message)msg.apply(), (Function1<String, String>)(JFunction1 & Serializable)m -> "Implementation restriction: " + m).error(Reporting.super.addInlineds(pos, ((Contexts.Context)this).ctx())), ((Contexts.Context)this).ctx());
    }

    default public NoSourcePosition$ restrictionError$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void incompleteInputError(Function0 msg, SourcePosition pos, Contexts.Context ctx) {
        ((Contexts.Context)this).reporter().incomplete(new messages.Error(msg, pos), ctx);
    }

    default public NoSourcePosition$ incompleteInputError$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void log(Function0 msg, SourcePosition pos) {
        Settings.Setting<List<String>> setting = Settings$Setting$.MODULE$.SettingDecorator(((Contexts.Context)this).settings().Ylog());
        if (Decorators$PhaseListDecorator$.MODULE$.containsPhase$extension(Decorators$.MODULE$.PhaseListDecorator(Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx())), ((Contexts.Context)this).phase())) {
            this.echo(() -> this.log$$anonfun$1(msg), pos);
        }
    }

    default public NoSourcePosition$ log$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void debuglog(Function0 msg) {
        if (((Contexts.Context)this).ctx().debug()) {
            this.log(msg, this.log$default$2());
        }
    }

    default public void informTime(Function0 msg, long start) {
        this.informProgress(() -> Reporting.informTime$$anonfun$1(msg, start));
    }

    default public void informProgress(Function0 msg) {
        this.inform(() -> Reporting.informProgress$$anonfun$1(msg), this.inform$default$2());
    }

    default public <T> T logWith(Function0<String> msg, T value) {
        this.log(() -> Reporting.logWith$$anonfun$1(msg, value), this.log$default$2());
        return value;
    }

    default public void debugwarn(Function0 msg, SourcePosition pos) {
        Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(((Contexts.Context)this).settings().Ydebug());
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) {
            this.warning(() -> Reporting.debugwarn$$anonfun$1(msg), pos);
        }
    }

    default public NoSourcePosition$ debugwarn$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    private SourcePosition addInlineds(SourcePosition pos, Contexts.Context ctx) {
        return Reporting.recur$1(ctx, pos, tpd$.MODULE$.enclosingInlineds(ctx));
    }

    private static Message echo$$anonfun$1(Function0 msg$1) {
        return Message$.MODULE$.toNoExplanation((String)msg$1.apply());
    }

    private static Message featureWarning$$anonfun$1(String msg$2) {
        return Message$.MODULE$.toNoExplanation(msg$2);
    }

    private static Message featureWarning$$anonfun$2(String msg$3) {
        return Message$.MODULE$.toNoExplanation(msg$3);
    }

    private Message error$$anonfun$1(TypeError ex$1) {
        return ex$1.toMessage(((Contexts.Context)this).ctx());
    }

    private String log$$anonfun$1(Function0 msg$6) {
        return "[log " + ((Contexts.Context)this).ctx().phasesStack().reverse().mkString(" -> ") + "] " + msg$6.apply();
    }

    private static String elapsed$1(long start$1) {
        return " in " + (System.currentTimeMillis() - start$1) + "ms";
    }

    private static String informTime$$anonfun$1(Function0 msg$7, long start$2) {
        return (String)msg$7.apply() + Reporting.elapsed$1(start$2);
    }

    private static String informProgress$$anonfun$1(Function0 msg$8) {
        return "[" + msg$8.apply() + "]";
    }

    private static String logWith$$anonfun$1(Function0 msg$9, Object value$1) {
        return (String)msg$9.apply() + " " + value$1;
    }

    private static Message debugwarn$$anonfun$1(Function0 msg$10) {
        return Message$.MODULE$.toNoExplanation((String)msg$10.apply());
    }

    private static SourcePosition recur$1(Contexts.Context ctx$1, SourcePosition pos, List inlineds) {
        SourcePosition sourcePosition;
        List list = inlineds;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            Trees.Tree inlined = (Trees.Tree)colon2.head();
            List inlineds1 = list2;
            sourcePosition = pos.withOuter(Reporting.recur$1(ctx$1, inlined.sourcePos(ctx$1), inlineds1));
        } else {
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                sourcePosition = pos;
            } else {
                throw new MatchError((Object)list);
            }
        }
        return sourcePosition;
    }
}

