/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.sbt;

import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.Message$;
import dotty.tools.dotc.sbt.ClassDependency;
import dotty.tools.dotc.sbt.ExtractDependencies$;
import dotty.tools.dotc.sbt.ExtractDependenciesCollector;
import dotty.tools.dotc.sbt.UsedNamesInClass;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.File$;
import dotty.tools.io.PlainFile;
import dotty.tools.io.ZipArchive;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.io.Codec$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import xsbti.api.DependencyContext;

public class ExtractDependencies
extends Phases.Phase {
    public static String classNameAsString(Symbols.Symbol symbol, Contexts.Context context) {
        return ExtractDependencies$.MODULE$.classNameAsString(symbol, context);
    }

    @Override
    public String phaseName() {
        return "sbt-deps";
    }

    @Override
    public boolean isRunnable(Contexts.Context ctx) {
        return super.isRunnable(ctx) && (ctx.sbtCallback() != null || ExtractDependencies.forceRun$1(ctx));
    }

    @Override
    public boolean isCheckable() {
        return false;
    }

    @Override
    public void run(Contexts.Context ctx) {
        CompilationUnit unit = ctx.compilationUnit();
        ExtractDependenciesCollector collector = new ExtractDependenciesCollector();
        collector.traverse(unit.tpdTree(), ctx);
        Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(ctx.settings().YdumpSbtInc());
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx))) {
            Object[] deps = (Object[])((IterableOnceOps)collector.dependencies().map((Function1)(JFunction1 & Serializable)_$1 -> ((Object)_$1).toString())).toArray(ClassTag$.MODULE$.apply(Object.class));
            Object[] names = (Object[])((IterableOnceOps)collector.usedNames().map((Function1)(JFunction1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Symbols.Symbol clazz = (Symbols.Symbol)tuple2._1();
                UsedNamesInClass names = (UsedNamesInClass)tuple2._2();
                return "" + clazz + ": " + names;
            })).toArray(ClassTag$.MODULE$.apply(Object.class));
            Arrays.sort(deps);
            Arrays.sort(names);
            try (PrintWriter pw = File$.MODULE$.apply(unit.source().file().jpath(), Codec$.MODULE$.fallbackSystemCodec()).changeExtension("inc").toFile().printWriter();){
                pw.println("Used Names:");
                pw.println("===========");
                Object object = Predef$.MODULE$.refArrayOps(names);
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)x$0 -> pw.println(x$0));
                pw.println();
                pw.println("Dependencies:");
                pw.println("=============");
                Object object2 = Predef$.MODULE$.refArrayOps(deps);
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)x$0 -> pw.println(x$0));
            }
        }
        if (ctx.sbtCallback() != null) {
            collector.usedNames().foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Symbols.Symbol clazz = (Symbols.Symbol)tuple2._1();
                UsedNamesInClass usedNames = (UsedNamesInClass)tuple2._2();
                String className = ExtractDependencies$.MODULE$.classNameAsString(clazz, ctx);
                usedNames.names().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Names.Name usedName = (Names.Name)tuple2._1();
                    EnumSet scopes = (EnumSet)tuple2._2();
                    ctx.sbtCallback().usedName(className, usedName.toString(), scopes);
                });
            });
            collector.dependencies().foreach((Function1)(JProcedure1 & Serializable)dep -> this.recordDependency((ClassDependency)dep, ctx));
        }
    }

    public void recordDependency(ClassDependency dep, Contexts.Context ctx) {
        block2: {
            String fromClassName;
            block4: {
                AbstractFile depFile;
                File sourceFile;
                block3: {
                    fromClassName = ExtractDependencies$.MODULE$.classNameAsString(dep.from(), ctx);
                    sourceFile = ctx.compilationUnit().source().file().file();
                    depFile = dep.to().associatedFile(ctx);
                    if (depFile == null) break block2;
                    String string = depFile.extension();
                    String string2 = "class";
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    ExtractDependencies.processExternalDependency$1(dep, ctx, fromClassName, sourceFile, depFile);
                    break block2;
                }
                if (ExtractDependencies.allowLocal$1(dep)) break block4;
                File file = depFile.file();
                File file2 = sourceFile;
                if (!(file == null ? file2 != null : !((Object)file).equals(file2))) break block2;
            }
            String toClassName = ExtractDependencies$.MODULE$.classNameAsString(dep.to(), ctx);
            ctx.sbtCallback().classDependency(toClassName, fromClassName, dep.context());
        }
    }

    private static final boolean forceRun$1(Contexts.Context ctx$1) {
        Settings.Setting<Object> setting;
        Settings.Setting<Object> setting2 = Settings$Setting$.MODULE$.SettingDecorator(ctx$1.settings().YdumpSbtInc());
        return BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2, ctx$1)) || BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting = Settings$Setting$.MODULE$.SettingDecorator(ctx$1.settings().YforceSbtPhases()), ctx$1));
    }

    private static final void binaryDependency$1(ClassDependency dep$1, Contexts.Context ctx$5, String fromClassName$1, File sourceFile$1, File file, String binaryClassName) {
        ctx$5.sbtCallback().binaryDependency(file, binaryClassName, fromClassName$1, sourceFile$1, dep$1.context());
    }

    private static final String binaryClassName$1(List classSegments) {
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(classSegments.mkString(".")), ".class");
    }

    private static final Message processExternalDependency$4$$anonfun$3(AbstractFile depFile$1) {
        return Message$.MODULE$.toNoExplanation("sbt-deps: Ignoring dependency " + depFile$1 + " of class " + depFile$1.getClass() + "}");
    }

    private static final void processExternalDependency$1(ClassDependency dep$4, Contexts.Context ctx$8, String fromClassName$4, File sourceFile$4, AbstractFile depFile) {
        block1: {
            block2: {
                AbstractFile abstractFile;
                block0: {
                    abstractFile = depFile;
                    if (!(abstractFile instanceof ZipArchive.Entry)) break block0;
                    ZipArchive.Entry ze = (ZipArchive.Entry)abstractFile;
                    ze.underlyingSource().foreach((Function1)(JProcedure1 & Serializable)zip -> Option$.MODULE$.apply((Object)zip.file()).foreach((Function1)(JProcedure1 & Serializable)zipFile -> {
                        List<String> classSegments = File$.MODULE$.apply(ze.path(), Codec$.MODULE$.fallbackSystemCodec()).segments();
                        ExtractDependencies.binaryDependency$1(dep$4, ctx$8, fromClassName$4, sourceFile$4, zipFile, ExtractDependencies.binaryClassName$1(classSegments));
                    }));
                    break block1;
                }
                if (!(abstractFile instanceof PlainFile)) break block2;
                PlainFile pf = (PlainFile)abstractFile;
                int packages = Symbols$.MODULE$.toDenot(dep$4.to(), ctx$8).ownersIterator(ctx$8).count((Function1)(JFunction1 & Serializable)x -> Symbols$.MODULE$.toDenot((Symbols.Symbol)x, ctx$8).is(Flags$.MODULE$.PackageClass(), ctx$8) && !Symbols$.MODULE$.toDenot((Symbols.Symbol)x, ctx$8).isEffectiveRoot(ctx$8));
                List classSegments = pf.givenPath().segments().takeRight(packages + 1);
                if (pf.file() == null) break block1;
                ExtractDependencies.binaryDependency$1(dep$4, ctx$8, fromClassName$4, sourceFile$4, pf.file(), ExtractDependencies.binaryClassName$1(classSegments));
                break block1;
            }
            ctx$8.warning(() -> ExtractDependencies.processExternalDependency$4$$anonfun$3(depFile), ctx$8.warning$default$2());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean allowLocal$1(ClassDependency dep$5) {
        DependencyContext dependencyContext = dep$5.context();
        DependencyContext dependencyContext2 = DependencyContext.DependencyByInheritance;
        if (dependencyContext == null) {
            if (dependencyContext2 == null) return true;
        } else if (dependencyContext.equals(dependencyContext2)) return true;
        DependencyContext dependencyContext3 = dep$5.context();
        DependencyContext dependencyContext4 = DependencyContext.LocalDependencyByInheritance;
        if (dependencyContext3 != null) {
            if (!dependencyContext3.equals(dependencyContext4)) return false;
            return true;
        }
        if (dependencyContext4 == null) return true;
        return false;
    }
}

