/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.DottyPredef$;
import dotty.tools.io.AbstractFile$;
import dotty.tools.io.File;
import dotty.tools.io.Path;
import dotty.tools.io.Path$;
import dotty.tools.io.PlainFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import scala.Char$;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class AbstractFile
implements Iterable<AbstractFile> {
    private final String extension;

    public static AbstractFile getDirectory(java.nio.file.Path path) {
        return AbstractFile$.MODULE$.getDirectory(path);
    }

    public static AbstractFile getDirectory(Path path) {
        return AbstractFile$.MODULE$.getDirectory(path);
    }

    public static AbstractFile getDirectory(String string) {
        return AbstractFile$.MODULE$.getDirectory(string);
    }

    public static AbstractFile getFile(java.nio.file.Path path) {
        return AbstractFile$.MODULE$.getFile(path);
    }

    public static AbstractFile getFile(Path path) {
        return AbstractFile$.MODULE$.getFile(path);
    }

    public static AbstractFile getFile(String string) {
        return AbstractFile$.MODULE$.getFile(string);
    }

    public static AbstractFile getResources(URL uRL) {
        return AbstractFile$.MODULE$.getResources(uRL);
    }

    public static AbstractFile getURL(URL uRL) {
        return AbstractFile$.MODULE$.getURL(uRL);
    }

    public AbstractFile() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        this.extension = Path$.MODULE$.extension(this.name());
    }

    public abstract String name();

    public abstract String path();

    public String absolutePath() {
        return this.path();
    }

    public String canonicalPath() {
        return this.jpath() == null ? this.path() : this.jpath().normalize().toString();
    }

    public boolean hasExtension(String other) {
        String string = this.extension();
        String string2 = other.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public String extension() {
        return this.extension;
    }

    public abstract AbstractFile absolute();

    public abstract AbstractFile container();

    public java.io.File file() {
        java.io.File file;
        block3: {
            try {
                if (this.jpath() == null) {
                    file = null;
                    break block3;
                }
                file = this.jpath().toFile();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                file = null;
            }
        }
        return file;
    }

    public abstract java.nio.file.Path jpath();

    public Option<AbstractFile> underlyingSource() {
        return None$.MODULE$;
    }

    public boolean exists() {
        return this.jpath() == null || Files.exists(this.jpath(), new LinkOption[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClassContainer() {
        if (this.isDirectory()) return true;
        if (this.jpath() == null) return false;
        String string = this.extension();
        String string2 = "jar";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = this.extension();
        String string4 = "zip";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public abstract void create();

    public abstract void delete();

    public abstract boolean isDirectory();

    public boolean isVirtual() {
        return false;
    }

    public abstract long lastModified();

    public abstract InputStream input();

    public abstract OutputStream output();

    public BufferedOutputStream bufferedOutput() {
        return new BufferedOutputStream(this.output());
    }

    public Option<Object> sizeOption() {
        return None$.MODULE$;
    }

    public URL toURL() {
        return this.jpath() == null ? null : this.jpath().toUri().toURL();
    }

    public char[] toCharArray() {
        return new String(this.toByteArray()).toCharArray();
    }

    public byte[] toByteArray() {
        byte[] byArray;
        InputStream in = this.input();
        Option<Object> option = this.sizeOption();
        if (option instanceof Some) {
            int size;
            int res;
            int rest;
            byte[] arr = new byte[rest];
            for (rest = size = BoxesRunTime.unboxToInt((Object)((Some)option).value()); rest > 0; rest -= res) {
                res = in.read(arr, arr.length - rest, rest);
                if (res != -1) continue;
                throw new IOException("read error");
            }
            in.close();
            byArray = arr;
        } else if (None$.MODULE$.equals(option)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = in.read();
            while (c != -1) {
                out.write(c);
                c = in.read();
            }
            in.close();
            byArray = out.toByteArray();
        } else {
            throw new MatchError(option);
        }
        return byArray;
    }

    public abstract Iterator<AbstractFile> iterator();

    public abstract AbstractFile lookupName(String var1, boolean var2);

    public abstract AbstractFile lookupNameUnchecked(String var1, boolean var2);

    public AbstractFile lookupPathUnchecked(String path, boolean directory) {
        return this.lookup((Function3<AbstractFile, String, Object, AbstractFile>)((Function3 & Serializable)AbstractFile::lookupPathUnchecked$$anonfun$adapted$1), path, directory);
    }

    private AbstractFile lookup(Function3<AbstractFile, String, Object, AbstractFile> getFile, String path0, boolean directory) {
        int length;
        char separator = java.io.File.separatorChar;
        String path = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path0)) == separator ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(path0), 1) : path0;
        if (!AbstractFile.assertion$1(separator, path, length = path.length())) {
            throw DottyPredef$.MODULE$.assertFail(() -> AbstractFile.lookup$$anonfun$1(path));
        }
        AbstractFile file = this;
        IntRef start = IntRef.create((int)0);
        while (true) {
            int n;
            int index = path.indexOf(Char$.MODULE$.char2int(separator), start.elem);
            if (!AbstractFile.assertion$2(start, index)) {
                throw DottyPredef$.MODULE$.assertFail(() -> AbstractFile.lookup$$anonfun$2(directory, path, start, index));
            }
            String name = path.substring(start.elem, index < 0 ? length : index);
            if ((file = (AbstractFile)getFile.apply((Object)file, (Object)name, (Object)(index < 0 ? BoxesRunTime.boxToBoolean((boolean)directory) : BoxesRunTime.boxToBoolean((boolean)true)))) == null || index < 0) {
                return file;
            }
            start.elem = n = index + 1;
        }
        return file;
    }

    private AbstractFile fileOrSubdirectoryNamed(String name, boolean isDir) {
        AbstractFile abstractFile;
        AbstractFile abstractFile2 = this.lookupName(name, isDir);
        if (abstractFile2 == null) {
            java.nio.file.Path path;
            try {
                path = Files.createDirectories(this.jpath(), new FileAttribute[0]);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof FileAlreadyExistsException) || !Files.isDirectory(this.jpath(), new LinkOption[0])) {
                    throw throwable;
                }
                path = BoxedUnit.UNIT;
            }
            java.nio.file.Path path2 = this.jpath().resolve(name);
            java.nio.file.Path path3 = isDir ? Files.createDirectory(path2, new FileAttribute[0]) : Files.createFile(path2, new FileAttribute[0]);
            abstractFile = new PlainFile(new File(path2, Codec$.MODULE$.fallbackSystemCodec()));
        } else {
            AbstractFile lookup;
            abstractFile = lookup = abstractFile2;
        }
        return abstractFile;
    }

    public AbstractFile fileNamed(String name) {
        if (!this.assertion$3()) {
            throw DottyPredef$.MODULE$.assertFail(() -> this.fileNamed$$anonfun$1(name));
        }
        return this.fileOrSubdirectoryNamed(name, false);
    }

    public AbstractFile subdirectoryNamed(String name) {
        if (!this.assertion$4()) {
            throw DottyPredef$.MODULE$.assertFail(() -> this.subdirectoryNamed$$anonfun$1(name));
        }
        return this.fileOrSubdirectoryNamed(name, true);
    }

    public Nothing$ unsupported() {
        return this.unsupported(null);
    }

    public Nothing$ unsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    public String toString() {
        return this.path();
    }

    private static final AbstractFile lookupPathUnchecked$$anonfun$adapted$1(Object f, Object p, Object dir) {
        return ((AbstractFile)f).lookupNameUnchecked((String)p, BoxesRunTime.unboxToBoolean((Object)dir));
    }

    private static final boolean assertion$1(char separator$1, String path$1, int length$1) {
        return length$1 > 0 && StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path$1)) != separator$1;
    }

    private static final String lookup$$anonfun$1(String path$2) {
        return path$2;
    }

    private static final boolean assertion$2(IntRef start$1, int index$1) {
        return index$1 < 0 || start$1.elem < index$1;
    }

    private static final Tuple4 message$1(boolean directory$1, String path$3, IntRef start$2, int index$2) {
        return Tuple4$.MODULE$.apply((Object)path$3, (Object)BoxesRunTime.boxToBoolean((boolean)directory$1), (Object)BoxesRunTime.boxToInteger((int)start$2.elem), (Object)BoxesRunTime.boxToInteger((int)index$2));
    }

    private static final Tuple4 lookup$$anonfun$2(boolean directory$2, String path$4, IntRef start$3, int index$3) {
        return AbstractFile.message$1(directory$2, path$4, start$3, index$3);
    }

    private final boolean assertion$3() {
        return this.isDirectory();
    }

    private final String message$2(String name$1) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tried to find '%s' in '%s' but it is not a directory"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name$1, this.path()}));
    }

    private final String fileNamed$$anonfun$1(String name$3) {
        return this.message$2(name$3);
    }

    private final boolean assertion$4() {
        return this.isDirectory();
    }

    private final String message$3(String name$2) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tried to find '%s' in '%s' but it is not a directory"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name$2, this.path()}));
    }

    private final String subdirectoryNamed$$anonfun$1(String name$4) {
        return this.message$3(name$4);
    }
}

