/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Names$;
import dotty.tools.dotc.util.NameTransformer;
import java.io.Serializable;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class NameTransformer$
implements Serializable {
    public static final NameTransformer$ MODULE$;
    private final int nops;
    private final String[] op2code;
    private final NameTransformer.OpCodes[] code2op;

    static {
        new NameTransformer$();
    }

    private NameTransformer$() {
        MODULE$ = this;
        this.nops = 128;
        int ncodes = 676;
        this.op2code = new String[this.nops];
        this.code2op = new NameTransformer.OpCodes[ncodes];
        this.enterOp('~', "$tilde");
        this.enterOp('=', "$eq");
        this.enterOp('<', "$less");
        this.enterOp('>', "$greater");
        this.enterOp('!', "$bang");
        this.enterOp('#', "$hash");
        this.enterOp('%', "$percent");
        this.enterOp('^', "$up");
        this.enterOp('&', "$amp");
        this.enterOp('|', "$bar");
        this.enterOp('*', "$times");
        this.enterOp('/', "$div");
        this.enterOp('+', "$plus");
        this.enterOp('-', "$minus");
        this.enterOp(':', "$colon");
        this.enterOp('\\', "$bslash");
        this.enterOp('?', "$qmark");
        this.enterOp('@', "$at");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NameTransformer$.class);
    }

    private void enterOp(char op, String code) {
        this.op2code[op] = code;
        int c = (code.charAt(1) - 97) * 26 + code.charAt(2) - 97;
        this.code2op[c] = new NameTransformer.OpCodes(op, code, this.code2op[c]);
    }

    public Names.SimpleName encode(Names.SimpleName name) {
        StringBuilder buf = null;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            BoxedUnit boxedUnit;
            char c = name.apply(i);
            if (c < this.nops && this.op2code[c] != null) {
                if (buf == null) {
                    buf = new StringBuilder();
                    buf.append(name.sliceToString(0, i));
                }
                boxedUnit = buf.append(this.op2code[c]);
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                if (buf == null) {
                    buf = new StringBuilder();
                    buf.append(name.sliceToString(0, i));
                }
                boxedUnit = buf.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("$u%04X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
                continue;
            }
            if (buf != null) {
                buf.append(c);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return buf == null ? name : Names$.MODULE$.termName(buf.toString());
    }

    public Names.SimpleName decode(Names.SimpleName name) {
        StringBuilder buf = null;
        int len = name.length();
        int i = 0;
        while (i < len) {
            char ch1;
            NameTransformer.OpCodes ops = null;
            boolean unicode = false;
            char c = name.apply(i);
            if (c == '$' && i + 2 < len && 'a' <= (ch1 = name.apply(i + 1)) && ch1 <= 'z') {
                char ch2 = name.apply(i + 2);
                if ('a' <= ch2 && ch2 <= 'z') {
                    for (ops = this.code2op[(ch1 - 97) * 26 + ch2 - 97]; ops != null && !name.startsWith(ops.code(), i); ops = ops.next()) {
                    }
                    if (ops != null) {
                        if (buf == null) {
                            buf = new StringBuilder();
                            buf.append(name.sliceToString(0, i));
                        }
                        buf.append(ops.op());
                        i += ops.code().length();
                    }
                } else if (len - i >= 6 && ch1 == 'u' && (Character.isDigit(ch2) || 'A' <= ch2 && ch2 <= 'F')) {
                    String hex = name.sliceToString(i + 2, i + 6);
                    try {
                        char str = (char)Integer.parseInt(hex, 16);
                        if (buf == null) {
                            buf = new StringBuilder();
                            buf.append(name.sliceToString(0, i));
                        }
                        buf.append(str);
                        i += 6;
                        unicode = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (ops != null || unicode) continue;
            if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        return buf == null ? name : Names$.MODULE$.termName(buf.toString());
    }
}

