/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$;
import dotty.tools.dotc.core.Contexts$ModeChanges$;
import dotty.tools.dotc.core.Mode$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$NoSymbol$;
import dotty.tools.dotc.interfaces.ReporterResult;
import dotty.tools.dotc.interfaces.SimpleReporter;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.Reporter$;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class Reporter
implements ReporterResult {
    private boolean _truncationOK = true;
    private Function2 incompleteHandler;
    private int _errorCount;
    private int _warningCount;
    private List<Diagnostic.Error> errors;
    private Set<Symbols.Symbol> reportedFeaturesUseSites;
    private Map unreportedWarnings;

    public static void displayPrompt(BufferedReader bufferedReader, PrintWriter printWriter) {
        Reporter$.MODULE$.displayPrompt(bufferedReader, printWriter);
    }

    public static Reporter fromSimpleReporter(SimpleReporter simpleReporter) {
        return Reporter$.MODULE$.fromSimpleReporter(simpleReporter);
    }

    public Reporter() {
        this.incompleteHandler = Reporter$.MODULE$.dotty$tools$dotc$reporting$Reporter$$$defaultIncompleteHandler;
        this._errorCount = 0;
        this._warningCount = 0;
        this.errors = package$.MODULE$.Nil();
        this.reportedFeaturesUseSites = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Symbols.Symbol[0]));
        this.unreportedWarnings = Predef$.MODULE$.Map().empty();
    }

    public abstract void doReport(Diagnostic var1, Contexts.Context var2);

    public boolean truncationOK() {
        return this._truncationOK;
    }

    public <T> T withoutTruncating(Function0<T> body) {
        Object object;
        boolean saved = this._truncationOK;
        this._truncationOK = false;
        try {
            object = body.apply();
        }
        finally {
            this._truncationOK = saved;
        }
        return (T)object;
    }

    public <T> T withIncompleteHandler(Function2<Diagnostic, Contexts.Context, BoxedUnit> handler, Function0<T> op) {
        Object object;
        Function2 saved = this.incompleteHandler;
        this.incompleteHandler = handler;
        try {
            object = op.apply();
        }
        finally {
            this.incompleteHandler = saved;
        }
        return (T)object;
    }

    public int errorCount() {
        return this._errorCount;
    }

    public int warningCount() {
        return this._warningCount;
    }

    public boolean hasErrors() {
        return this.errorCount() > 0;
    }

    public boolean hasWarnings() {
        return this.warningCount() > 0;
    }

    public List<Diagnostic.Error> allErrors() {
        return this.errors;
    }

    public boolean hasStickyErrors() {
        return false;
    }

    public boolean errorsReported() {
        return this.hasErrors();
    }

    public boolean reportsErrorsFor(Function1<Contexts.Context, BoxedUnit> op, Contexts.Context x$2) {
        int initial = this.errorCount();
        op.apply((Object)Contexts$.MODULE$.ctx(x$2));
        return this.errorCount() > initial;
    }

    public boolean isReportedFeatureUseSite(Symbols.Symbol featureTrait) {
        return featureTrait != Symbols$NoSymbol$.MODULE$ && this.reportedFeaturesUseSites.contains((Object)featureTrait);
    }

    public void reportNewFeatureUseSite(Symbols.Symbol featureTrait) {
        this.reportedFeaturesUseSites = (Set)this.reportedFeaturesUseSites.$plus((Object)featureTrait);
    }

    public Map<String, Object> unreportedWarnings() {
        return this.unreportedWarnings;
    }

    public void unreportedWarnings_$eq(Map<String, Object> x$1) {
        this.unreportedWarnings = x$1;
    }

    public void report(Diagnostic dia, Contexts.Context ctx) {
        if (!this.isHidden(dia, ctx)) {
            Diagnostic.ConditionalWarning dia2;
            Settings.Setting<Object> setting;
            this.doReport(dia, Contexts$ModeChanges$.MODULE$.addMode$extension(Contexts$.MODULE$.ModeChanges(ctx), Mode$.MODULE$.Printing()));
            Diagnostic diagnostic = dia;
            if (diagnostic instanceof Diagnostic.ConditionalWarning && !BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting = Settings$Setting$.MODULE$.SettingDecorator((dia2 = (Diagnostic.ConditionalWarning)diagnostic).enablingOption(ctx)), ctx))) {
                String key = dia2.enablingOption(ctx).name();
                this.unreportedWarnings_$eq((Map<String, Object>)((Map)this.unreportedWarnings().updated((Object)key, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.unreportedWarnings().getOrElse((Object)key, (Function0)((JFunction0.mcI.sp & Serializable)Reporter::report$$anonfun$1))) + 1)))));
            } else if (diagnostic instanceof Diagnostic.Warning) {
                Diagnostic.Warning dia3 = (Diagnostic.Warning)diagnostic;
                ++this._warningCount;
            } else if (diagnostic instanceof Diagnostic.Error) {
                Diagnostic.Error dia4 = (Diagnostic.Error)diagnostic;
                this.errors = this.errors.$colon$colon((Object)dia4);
                ++this._errorCount;
            } else if (diagnostic instanceof Diagnostic.Info) {
                Diagnostic.Info dia5 = (Diagnostic.Info)diagnostic;
            } else {
                throw new MatchError((Object)diagnostic);
            }
        }
    }

    public void incomplete(Diagnostic dia, Contexts.Context ctx) {
        this.incompleteHandler.apply((Object)dia, (Object)ctx);
    }

    public String summary() {
        ListBuffer b = new ListBuffer();
        if (this.warningCount() > 0) {
            b.$plus$eq((Object)(this.countString(this.warningCount(), "warning") + " found"));
        }
        if (this.errorCount() > 0) {
            b.$plus$eq((Object)(this.countString(this.errorCount(), "error") + " found"));
        }
        this.unreportedWarnings().withFilter((Function1)(JFunction1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String settingName = (String)tuple2._1();
                int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JFunction1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String settingName = (String)tuple2._1();
            int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return (ListBuffer)b.$plus$eq((Object)("there were " + count + " " + StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(settingName)) + " warning(s); re-run with " + settingName + " for details"));
        });
        return b.mkString("\n");
    }

    public void printSummary(Contexts.Context ctx) {
        String s;
        String string = s = this.summary();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            ctx.echo(() -> Reporter.printSummary$$anonfun$1(s), ctx.echo$default$2());
        }
    }

    public String countString(int n, String elements) {
        int n2 = n;
        return 0 == n2 ? "no " + elements + "s" : (1 == n2 ? "1 " + elements : "" + n + " " + elements + "s");
    }

    public boolean isHidden(Diagnostic dia, Contexts.Context ctx) {
        return Mode$.MODULE$.is$extension(ctx.mode(), Mode$.MODULE$.Printing());
    }

    public boolean hasUnreportedErrors() {
        return false;
    }

    public List<Diagnostic> removeBufferedMessages(Contexts.Context ctx) {
        return package$.MODULE$.Nil();
    }

    public void flush(Contexts.Context ctx) {
        Reporter reporter = ctx.reporter();
        this.removeBufferedMessages(ctx).foreach((Function1)(JProcedure1 & Serializable)dia -> reporter.report((Diagnostic)dia, ctx));
    }

    public List<Diagnostic> pendingMessages(Contexts.Context x$1) {
        return package$.MODULE$.Nil();
    }

    private static final int report$$anonfun$1() {
        return 0;
    }

    private static final String printSummary$$anonfun$1(String s$1) {
        return s$1;
    }
}

