/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core;

import dotty.DottyPredef$;
import dotty.runtime.function.JProcedure1;
import dotty.tools.dotc.core.Constraint;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$StringInterpolators$;
import dotty.tools.dotc.core.OrderingConstraint$;
import dotty.tools.dotc.core.TestReporter;
import dotty.tools.dotc.core.TyperState$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.reporting.ConsoleReporter;
import dotty.tools.dotc.reporting.ConsoleReporter$;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.reporting.StoreReporter;
import dotty.tools.dotc.util.SimpleIdentitySet;
import dotty.tools.dotc.util.SimpleIdentitySet$empty$;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import scala.Function1;
import scala.StringContext$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class TyperState {
    private final TyperState previous;
    private final int id;
    private Reporter myReporter;
    private Constraint myConstraint;
    private final Constraint previousConstraint;
    private boolean myIsCommittable;
    private boolean isShared;
    private boolean isCommitted;
    private SimpleIdentitySet myOwnedVars;
    private TestReporter testReporter;

    public TyperState(TyperState previous) {
        this.previous = previous;
        this.id = TyperState$.MODULE$.dotty$tools$dotc$core$TyperState$$$nextId;
        TyperState$ typerState$ = TyperState$.MODULE$;
        ++typerState$.dotty$tools$dotc$core$TyperState$$$nextId;
        this.myReporter = previous == null ? new ConsoleReporter(ConsoleReporter$.MODULE$.$lessinit$greater$default$1(), ConsoleReporter$.MODULE$.$lessinit$greater$default$2()) : previous.reporter();
        this.myConstraint = previous == null ? OrderingConstraint$.MODULE$.empty() : previous.constraint();
        this.previousConstraint = previous == null ? this.constraint() : previous.constraint();
        this.myIsCommittable = true;
        this.isShared = false;
        this.isCommitted = false;
        this.myOwnedVars = SimpleIdentitySet$empty$.MODULE$;
        this.testReporter = null;
    }

    private TyperState previous() {
        return this.previous;
    }

    public int id() {
        return this.id;
    }

    public Reporter reporter() {
        return this.myReporter;
    }

    public TyperState setReporter(Reporter reporter) {
        this.myReporter = reporter;
        return this;
    }

    public Constraint constraint() {
        return this.myConstraint;
    }

    public void constraint_$eq(Constraint c, Contexts.Context ctx) {
        this.myConstraint = c;
    }

    public void resetConstraintTo(Constraint c) {
        if (c != this.myConstraint) {
            this.myConstraint.markRetracted();
        }
        this.myConstraint = c;
    }

    public boolean isCommittable() {
        return this.myIsCommittable;
    }

    public TyperState setCommittable(boolean committable) {
        this.myIsCommittable = committable;
        return this;
    }

    public boolean isGlobalCommittable() {
        return this.isCommittable() && (this.previous() == null || this.previous().isGlobalCommittable());
    }

    public void markShared() {
        this.isShared = true;
    }

    public TyperState fresh() {
        return new TyperState(this).setReporter(new StoreReporter(this.reporter())).setCommittable(this.isCommittable());
    }

    public Seq<Types.TypeVar> uninstVars() {
        return this.constraint().uninstVars();
    }

    public SimpleIdentitySet ownedVars() {
        return this.myOwnedVars;
    }

    public void ownedVars_$eq(SimpleIdentitySet vs) {
        this.myOwnedVars = vs;
    }

    public TyperState uncommittedAncestor() {
        return this.isCommitted ? this.previous().uncommittedAncestor() : this;
    }

    public <T> T test(Function1<Contexts.Context, T> op, Contexts.Context ctx) {
        Object object;
        if (this.isShared) {
            object = op.apply((Object)ctx.fresh().setExploreTyperState());
        } else {
            Constraint savedConstraint = this.myConstraint;
            Reporter savedReporter = this.myReporter;
            boolean savedCommittable = this.myIsCommittable;
            boolean savedCommitted = this.isCommitted;
            this.myIsCommittable = false;
            if (this.testReporter == null || this.testReporter.inUse()) {
                this.testReporter = new TestReporter(this.reporter());
            } else {
                this.testReporter.reset();
            }
            this.testReporter.inUse_$eq(true);
            this.myReporter = this.testReporter;
            try {
                object = op.apply((Object)ctx);
            }
            finally {
                this.testReporter.inUse_$eq(false);
                this.resetConstraintTo(savedConstraint);
                this.myReporter = savedReporter;
                this.myIsCommittable = savedCommittable;
                this.isCommitted = savedCommitted;
            }
        }
        return (T)object;
    }

    public void commit(Contexts.Context ctx) {
        TyperState targetState = ctx.typerState();
        if (this.constraint() != targetState.constraint()) {
            // empty if block
        }
        if (!this.isCommittable()) {
            throw DottyPredef$.MODULE$.assertFail();
        }
        if (targetState.constraint() == this.previousConstraint) {
            targetState.constraint_$eq(this.constraint(), ctx);
        } else {
            targetState.mergeConstraintWith(this, ctx);
        }
        this.constraint().foreachTypeVar((Function1<Types.TypeVar, BoxedUnit>)(JProcedure1 & Serializable)tvar -> {
            if (tvar.owningState().get() == this) {
                tvar.owningState_$eq(new WeakReference<TyperState>(targetState));
            }
        });
        targetState.ownedVars_$eq(targetState.ownedVars().$plus$plus(this.ownedVars()));
        targetState.gc(ctx);
        this.reporter().flush(ctx);
        this.isCommitted = true;
    }

    public void mergeConstraintWith(TyperState that, Contexts.Context ctx) {
        this.constraint_$eq(this.constraint().$amp(that.constraint(), that.reporter().errorsReported(), ctx), ctx);
    }

    public void gc(Contexts.Context ctx) {
        ListBuffer toCollect = new ListBuffer();
        this.constraint().foreachTypeVar((Function1<Types.TypeVar, BoxedUnit>)(JProcedure1 & Serializable)tvar -> {
            Types.Type inst;
            if (!tvar.inst().exists() && (inst = ctx.typeComparer().instType((Types.TypeVar)tvar)).exists() && tvar.owningState().get() == this) {
                tvar.inst_$eq(inst);
                Types.TypeLambda lam = tvar.origin().binder();
                if (this.constraint().isRemovable(lam)) {
                    toCollect.$plus$eq((Object)lam);
                }
            }
        });
        toCollect.foreach((Function1)(JProcedure1 & Serializable)poly -> this.constraint_$eq(this.constraint().remove((Types.TypeLambda)poly, ctx), ctx));
    }

    public String toString() {
        return "TS[" + TyperState.ids$1(this).mkString(", ") + "]";
    }

    public String stateChainStr() {
        return "" + this + (this.previous() == null ? "" : this.previous().stateChainStr());
    }

    private final String msg$1(Contexts.Context ctx$1, TyperState targetState$1) {
        return Decorators$StringInterpolators$.MODULE$.i$extension(Decorators$.MODULE$.StringInterpolators(StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"committing ", " to ", ", fromConstr = ", ", toConstr = ", ""}))), (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this, targetState$1, this.constraint(), targetState$1.constraint()}), ctx$1);
    }

    private static final List ids$1(TyperState state) {
        String string = "" + state.id() + (state.isCommittable() ? "" : "X");
        return (state.previous() == null ? package$.MODULE$.Nil() : TyperState.ids$1(state.previous())).$colon$colon((Object)string);
    }
}

