/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.sbt;

import dotty.DottyPredef$;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.Trees$Import$;
import dotty.tools.dotc.ast.Trees$Inlined$;
import dotty.tools.dotc.ast.Trees$Match$;
import dotty.tools.dotc.ast.tpd$;
import dotty.tools.dotc.ast.untpd;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$StringInterpolators$;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.NameOps$NameDecorator$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Symbols$NoSymbol$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.dotc.sbt.ClassDependency;
import dotty.tools.dotc.sbt.ClassDependency$;
import dotty.tools.dotc.sbt.UsedNamesInClass;
import dotty.tools.dotc.transform.SymUtils$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.runtime.ScalaRunTime$;
import xsbti.UseScope;
import xsbti.api.DependencyContext;

public class ExtractDependenciesCollector
extends Trees.Instance.TreeTraverser {
    private final HashMap<Symbols.Symbol, UsedNamesInClass> _usedNames = new HashMap();
    private final HashSet<ClassDependency> _dependencies = new HashSet();
    private Symbols.Symbol _responsibleForImports;
    private Symbols.Symbol lastOwner;
    private Symbols.Symbol lastDepSource;

    public ExtractDependenciesCollector() {
        super(tpd$.MODULE$);
    }

    public Map<Symbols.Symbol, UsedNamesInClass> usedNames() {
        return this._usedNames;
    }

    public Set<ClassDependency> dependencies() {
        return this._dependencies;
    }

    private Symbols.Symbol responsibleForImports(Contexts.Context ctx) {
        if (this._responsibleForImports == null) {
            Trees.Tree tree = ctx.compilationUnit().tpdTree();
            this._responsibleForImports = this.firstClassOrModule$1(ctx, tree);
            if (!Symbols$.MODULE$.toDenot(this._responsibleForImports, ctx).exists()) {
                ctx.warning(Message$.MODULE$.toNoExplanation(ExtractDependenciesCollector::responsibleForImports$$anonfun$1), tree.sourcePos());
            }
        }
        return this._responsibleForImports;
    }

    private Symbols.Symbol resolveDependencySource(Contexts.Context ctx) {
        Symbols.Symbol symbol = this.lastOwner;
        Symbols.Symbol symbol2 = ctx.owner();
        if (symbol == null ? symbol2 != null : !symbol.equals(symbol2)) {
            this.lastOwner = ctx.owner();
            Symbols.Symbol source = ExtractDependenciesCollector.nonLocalEnclosingClass$1(ctx);
            this.lastDepSource = Symbols$.MODULE$.toDenot(source, ctx).is(Flags$.MODULE$.PackageClass(), ctx) ? this.responsibleForImports(ctx) : source;
        }
        return this.lastDepSource;
    }

    private void addUsedName(Symbols.Symbol fromClass, Names.Name name, UseScope scope) {
        UsedNamesInClass usedName = (UsedNamesInClass)this._usedNames.getOrElseUpdate((Object)fromClass, ExtractDependenciesCollector::$anonfun$1);
        usedName.update(name, scope);
    }

    public void dotty$tools$dotc$sbt$ExtractDependenciesCollector$$addUsedName(Names.Name name, UseScope scope, Contexts.Context ctx) {
        Symbols.Symbol fromClass = this.resolveDependencySource(ctx);
        if (Symbols$.MODULE$.toDenot(fromClass, ctx).exists()) {
            if (!fromClass.isClass()) {
                throw DottyPredef$.MODULE$.assertFail();
            }
            this.addUsedName(fromClass, name, scope);
        }
    }

    public Names.Name dotty$tools$dotc$sbt$ExtractDependenciesCollector$$mangledName(Symbols.Symbol sym, Contexts.Context ctx) {
        Names.Name name;
        if (Symbols$.MODULE$.toDenot(sym, ctx).isConstructor()) {
            name = ExtractDependenciesCollector.constructorName$1(sym, ctx);
        } else {
            Names.Name name2 = NameOps$.MODULE$.NameDecorator(sym.name(ctx));
            name = NameOps$NameDecorator$.MODULE$.stripModuleClassSuffix$extension(name2);
        }
        return name;
    }

    public void dotty$tools$dotc$sbt$ExtractDependenciesCollector$$addMemberRefDependency(Symbols.Symbol sym, Contexts.Context ctx) {
        if (!this.dotty$tools$dotc$sbt$ExtractDependenciesCollector$$ignoreDependency(sym, ctx)) {
            Symbols.Symbol enclOrModuleClass;
            Symbols.Symbol symbol = enclOrModuleClass = Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.ModuleVal(), ctx) ? Symbols$.MODULE$.toDenot(sym, ctx).moduleClass(ctx) : Symbols$.MODULE$.toDenot(sym, ctx).enclosingClass(ctx);
            if (!enclOrModuleClass.isClass()) {
                throw DottyPredef$.MODULE$.assertFail(() -> ExtractDependenciesCollector.addMemberRefDependency$$anonfun$1(sym, enclOrModuleClass));
            }
            Symbols.Symbol fromClass = this.resolveDependencySource(ctx);
            if (Symbols$.MODULE$.toDenot(fromClass, ctx).exists()) {
                if (!fromClass.isClass()) {
                    throw DottyPredef$.MODULE$.assertFail();
                }
                this.addUsedName(fromClass, this.dotty$tools$dotc$sbt$ExtractDependenciesCollector$$mangledName(sym, ctx), UseScope.Default);
                if (!Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Package(), ctx)) {
                    this._dependencies.$plus$eq((Object)ClassDependency$.MODULE$.apply(fromClass, enclOrModuleClass, DependencyContext.DependencyByMemberRef));
                }
            }
        }
    }

    private void addInheritanceDependencies(Trees.Template tree, Contexts.Context ctx) {
        if (tree.parents().nonEmpty()) {
            DependencyContext depContext = SymUtils$.MODULE$.isLocal$extension(SymUtils$.MODULE$.decorateSymbol(Symbols$.MODULE$.toDenot(tree.symbol(ctx), ctx).owner()), ctx) ? DependencyContext.LocalDependencyByInheritance : DependencyContext.DependencyByInheritance;
            Symbols.Symbol from = this.resolveDependencySource(ctx);
            tree.parents().foreach((Function1)(JFunction1 & Serializable)parent -> (HashSet)this._dependencies.$plus$eq((Object)ClassDependency$.MODULE$.apply(from, ((Types.Type)parent.tpe()).classSymbol(ctx), depContext)));
        }
    }

    public boolean dotty$tools$dotc$sbt$ExtractDependenciesCollector$$ignoreDependency(Symbols.Symbol sym, Contexts.Context ctx) {
        return !Symbols$.MODULE$.toDenot(sym, ctx).exists() || Symbols$.MODULE$.toDenot(sym, ctx).isAbsent(false, ctx) || Symbols$.MODULE$.toDenot(sym, ctx).isEffectiveRoot(ctx) || Symbols$.MODULE$.toDenot(sym, ctx).isAnonymousFunction(ctx) || Symbols$.MODULE$.toDenot(sym, ctx).isAnonymousClass(ctx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void traverse(Trees.Tree tree2, Contexts.Context ctx) {
        try {
            Trees.Template t;
            Trees.ValDef vd;
            Trees.Tree tree3 = tree2;
            if (tree3 instanceof Trees.Match) {
                Trees.Match match = Trees$Match$.MODULE$.unapply((Trees.Match)tree3);
                Trees.Tree tree4 = match._1();
                List list = match._2();
                Trees.Tree selector = tree4;
                this.addPatMatDependency((Types.Type)selector.tpe(), ctx);
            } else if (tree3 instanceof Trees.Import) {
                Trees.Import import_ = Trees$Import$.MODULE$.unapply((Trees.Import)tree3);
                Trees.Tree tree5 = import_._1();
                List<untpd.ImportSelector> list = import_._2();
                Trees.Tree expr = tree5;
                List<untpd.ImportSelector> selectors = list;
                selectors.withFilter((Function1)(JFunction1 & Serializable)sel -> !sel.isWildcard()).foreach((Function1)(JProcedure1 & Serializable)sel -> {
                    this.addImported$1(ctx, expr, sel.name());
                    Names.TermName termName = sel.rename();
                    Names.TermName termName2 = sel.name();
                    if (termName == null ? termName2 != null : !((Object)termName).equals(termName2)) {
                        this.dotty$tools$dotc$sbt$ExtractDependenciesCollector$$addUsedName(sel.rename(), UseScope.Default, ctx);
                    }
                });
            } else if (tree3 instanceof Trees.TypeTree) {
                Trees.TypeTree t2 = (Trees.TypeTree)tree3;
                this.addTypeDependency((Types.Type)t2.tpe(), ctx);
            } else if (tree3 instanceof Trees.RefTree) {
                Trees.RefTree ref = (Trees.RefTree)tree3;
                this.dotty$tools$dotc$sbt$ExtractDependenciesCollector$$addMemberRefDependency(ref.symbol(ctx), ctx);
                this.addTypeDependency((Types.Type)ref.tpe(), ctx);
            } else if (tree3 instanceof Trees.Template) {
                Trees.Template t3 = (Trees.Template)tree3;
                this.addInheritanceDependencies(t3, ctx);
            }
            Trees.Tree tree6 = tree2;
            if (tree6 instanceof Trees.Inlined) {
                Trees.Inlined inlined = Trees$Inlined$.MODULE$.unapply((Trees.Inlined)tree6);
                Trees.Tree tree7 = inlined._1();
                List list = inlined._2();
                Trees.Tree tree8 = inlined._3();
                Trees.Tree call = tree7;
                if (!call.isEmpty()) {
                    this.traverse(call, ctx);
                    return;
                }
            }
            if (tree6 instanceof Trees.ValDef && Symbols$.MODULE$.toDenot((vd = (Trees.ValDef)tree6).symbol(ctx), ctx).is(Flags$.MODULE$.ModuleVal(), ctx)) {
                return;
            }
            if (tree6 instanceof Trees.Template && Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot((t = (Trees.Template)tree6).symbol(ctx), ctx).owner(), ctx).is(Flags$.MODULE$.ModuleClass(), ctx)) {
                this.traverse(t.constr(), ctx);
                t.parents().foreach((Function1)(JProcedure1 & Serializable)tree -> this.traverse((Trees.Tree)tree, ctx));
                t.body(ctx).foreach((Function1)(JProcedure1 & Serializable)tree -> this.traverse((Trees.Tree)tree, ctx));
                return;
            }
            this.traverseChildren(tree2, ctx);
            return;
        }
        catch (AssertionError ex) {
            Predef$.MODULE$.println((Object)Decorators$StringInterpolators$.MODULE$.i$extension(Decorators$.MODULE$.StringInterpolators(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"asserted failed while traversing ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tree2}), ctx));
            throw ex;
        }
    }

    public void addTypeDependency(Types.Type tpe, Contexts.Context ctx) {
        TypeDependencyTraverser traverser = new TypeDependencyTraverser(ctx, this){
            private final ExtractDependenciesCollector $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(ctx$19);
            }

            public void addDependency(Symbols.Symbol symbol) {
                this.$outer.dotty$tools$dotc$sbt$ExtractDependenciesCollector$$addMemberRefDependency(symbol, this.accCtx());
            }
        };
        traverser.traverse(tpe);
    }

    public void addPatMatDependency(Types.Type tpe, Contexts.Context ctx) {
        TypeDependencyTraverser traverser = new TypeDependencyTraverser(ctx, this){
            private final ExtractDependenciesCollector $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(ctx$20);
            }

            public void addDependency(Symbols.Symbol symbol) {
                if (!this.$outer.dotty$tools$dotc$sbt$ExtractDependenciesCollector$$ignoreDependency(symbol, this.accCtx()) && Symbols$.MODULE$.toDenot(symbol, this.accCtx()).is(Flags$.MODULE$.Sealed(), this.accCtx())) {
                    Names.Name usedName = this.$outer.dotty$tools$dotc$sbt$ExtractDependenciesCollector$$mangledName(symbol, this.accCtx());
                    this.$outer.dotty$tools$dotc$sbt$ExtractDependenciesCollector$$addUsedName(usedName, UseScope.PatMatTarget, this.accCtx());
                }
            }
        };
        traverser.traverse(tpe);
    }

    private final Symbols.Symbol firstClassOrModule$1(Contexts.Context ctx$10, Trees.Tree tree) {
        Trees.Instance.TreeAccumulator acc = new Trees.Instance.TreeAccumulator(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(tpd$.MODULE$);
            }

            public Symbols.Symbol apply(Symbols.Symbol x, Trees.Tree t, Contexts.Context ctx) {
                Symbols.Symbol symbol;
                Trees.Tree tree = t;
                if (tree instanceof Trees.TypeDef) {
                    Trees.TypeDef typeDef = (Trees.TypeDef)tree;
                    symbol = typeDef.symbol(ctx);
                } else {
                    Trees.Tree other = tree;
                    symbol = this.foldOver(x, other, ctx);
                }
                return symbol;
            }
        };
        return acc.apply(Symbols$NoSymbol$.MODULE$, tree, ctx$10);
    }

    private static final String responsibleForImports$$anonfun$1() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|No class, trait or object is defined in the compilation unit.\n                         |The incremental compiler cannot record the dependency information in such case.\n                         |Some errors like unused import referring to a non-existent class might not be reported.\n                         |"));
    }

    /*
     * WARNING - void declaration
     */
    private static final Symbols.Symbol nonLocalEnclosingClass$1(Contexts.Context ctx$11) {
        void var1_1;
        Symbols.Symbol clazz;
        Symbols.Symbol owner = clazz = Symbols$.MODULE$.toDenot(ctx$11.owner(), ctx$11).enclosingClass(ctx$11);
        while (!Symbols$.MODULE$.toDenot(owner, ctx$11).is(Flags$.MODULE$.PackageClass(), ctx$11)) {
            if (owner.isTerm(ctx$11)) {
                owner = clazz = Symbols$.MODULE$.toDenot(owner, ctx$11).enclosingClass(ctx$11);
                continue;
            }
            owner = Symbols$.MODULE$.toDenot(owner, ctx$11).owner();
        }
        return var1_1;
    }

    private static final UsedNamesInClass $anonfun$1() {
        return new UsedNamesInClass();
    }

    private static final Names.Name constructorName$1(Symbols.Symbol sym$1, Contexts.Context ctx$12) {
        return Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym$1, ctx$12).owner(), ctx$12).fullName(ctx$12).$plus$plus(";init;");
    }

    private static final String addMemberRefDependency$$anonfun$1(Symbols.Symbol sym$2, Symbols.Symbol enclOrModuleClass$1) {
        return "" + enclOrModuleClass$1 + ", " + sym$2;
    }

    private static final Symbols.Symbol lookupImported$1(Contexts.Context ctx$14, Trees.Tree expr$1, Names.Name name) {
        return ((Types.Type)expr$1.tpe()).member(name, ctx$14).symbol();
    }

    private final void addImported$1(Contexts.Context ctx$15, Trees.Tree expr$2, Names.Name name) {
        this.dotty$tools$dotc$sbt$ExtractDependenciesCollector$$addMemberRefDependency(ExtractDependenciesCollector.lookupImported$1(ctx$15, expr$2, name.toTermName()), ctx$15);
        this.dotty$tools$dotc$sbt$ExtractDependenciesCollector$$addMemberRefDependency(ExtractDependenciesCollector.lookupImported$1(ctx$15, expr$2, name.toTypeName()), ctx$15);
    }

    private abstract class TypeDependencyTraverser
    extends Types.TypeTraverser {
        private final Contexts.Context ctx;
        private final HashSet seen;

        public TypeDependencyTraverser(Contexts.Context ctx) {
            this.ctx = ctx;
            super(ctx);
            this.seen = new HashSet();
        }

        public abstract void addDependency(Symbols.Symbol var1);

        public HashSet<Types.Type> seen() {
            return this.seen;
        }

        @Override
        public void traverse(Types.Type tp) {
            block7: {
                Types.Type type;
                block8: {
                    if (this.seen().contains((Object)tp)) break block7;
                    this.seen().$plus$eq((Object)tp);
                    type = tp;
                    if (!(type instanceof Types.NamedType)) break block8;
                    Types.NamedType tp2 = (Types.NamedType)type;
                    Symbols.Symbol sym = tp2.symbol(this.ctx);
                    if (Symbols$.MODULE$.toDenot(sym, this.ctx).is(Flags$.MODULE$.Package(), this.ctx)) break block7;
                    this.addDependency(sym);
                    if (!sym.isClass()) {
                        this.traverse(tp2.info(this.ctx));
                    }
                    this.traverse(tp2.prefix());
                    break block7;
                }
                if (type instanceof Types.ThisType) {
                    Types.ThisType tp3 = (Types.ThisType)type;
                    this.traverse(tp3.underlying(this.ctx));
                } else if (type instanceof Types.ConstantType) {
                    Types.ConstantType tp4 = (Types.ConstantType)type;
                    this.traverse(tp4.underlying(this.ctx));
                } else if (type instanceof Types.ParamRef) {
                    Types.ParamRef tp5 = (Types.ParamRef)type;
                    this.traverse(tp5.underlying(this.ctx));
                } else {
                    this.traverseChildren(tp);
                }
            }
        }
    }
}

