/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.decompiler;

import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.core.tasty.TastyPrinter;
import dotty.tools.dotc.tastyreflect.ReflectionImpl$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.File$;
import java.io.OutputStream;
import java.io.PrintStream;
import scala.Predef$;
import scala.Tuple2;
import scala.io.Codec$;
import scala.runtime.BoxesRunTime;

public class DecompilationPrinter
extends Phases.Phase {
    @Override
    public String phaseName() {
        return "decompilationPrinter";
    }

    @Override
    public void run(Contexts.Context x$1) {
        Settings.Setting<AbstractFile> setting = Settings$Setting$.MODULE$.SettingDecorator(x$1.settings().outputDir());
        if (Settings$Setting$SettingDecorator$.MODULE$.isDefault$extension(setting, x$1)) {
            this.printToOutput(System.out, x$1);
        } else {
            Settings.Setting<AbstractFile> setting2 = Settings$Setting$.MODULE$.SettingDecorator(x$1.settings().outputDir());
            AbstractFile outputDir = Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2, x$1);
            OutputStream os = null;
            PrintStream ps = null;
            try {
                os = File$.MODULE$.apply(outputDir.fileNamed("decompiled.scala").path(), Codec$.MODULE$.UTF8()).outputStream(true);
                ps = new PrintStream(os, false, "UTF-8");
                this.printToOutput(ps, x$1);
            }
            finally {
                if (os != null) {
                    os.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private void printToOutput(PrintStream out, Contexts.Context x$2) {
        CompilationUnit unit = x$2.compilationUnit();
        Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(x$2.settings().printTasty());
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, x$2))) {
            Predef$.MODULE$.println((Object)new TastyPrinter((byte[])((Tuple2)unit.pickled().head())._2(), x$2).printContents());
        } else {
            String unitFile = unit.source().toString().replace("\\", "/").replace(".class", ".tasty");
            out.println("/** Decompiled from " + unitFile + " */");
            out.println(ReflectionImpl$.MODULE$.showTree(unit.tpdTree(), x$2));
        }
    }
}

