/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.runtime.function.JProcedure1;
import dotty.tools.dotc.ast.Positioned;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Annotations;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$PreNamedString$;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.tasty.TastyPickler;
import dotty.tools.dotc.core.tasty.TreePickler;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.dotc.util.NoSource$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.Spans$;
import dotty.tools.dotc.util.Spans$Span$;
import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyBuffer$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.mutable.BitSet;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Null$;

public class PositionPickler {
    private final TastyPickler pickler;
    private final Function1<Trees.Tree<Null$>, TastyBuffer.Addr> addrOfTree;
    private final TastyBuffer buf;
    private final BitSet pickledIndices;

    public PositionPickler(TastyPickler pickler, Function1<Trees.Tree<Null$>, TastyBuffer.Addr> addrOfTree) {
        this.pickler = pickler;
        this.addrOfTree = addrOfTree;
        this.buf = new TastyBuffer(5000);
        pickler.newSection("Positions", this.buf());
        this.pickledIndices = new BitSet();
    }

    public TastyBuffer buf() {
        return this.buf;
    }

    public int header(int addrDelta, boolean hasStartDelta, boolean hasEndDelta, boolean hasPoint) {
        return addrDelta << 3 | PositionPickler.toInt$1(hasStartDelta) << 2 | PositionPickler.toInt$1(hasEndDelta) << 1 | PositionPickler.toInt$1(hasPoint);
    }

    public void picklePositions(List<Trees.Tree<Types.Type>> roots, Contexts.Context x$2) {
        IntRef lastIndex = IntRef.create((int)0);
        LongRef lastSpan = LongRef.create((long)Spans$.MODULE$.Span(0, 0));
        roots.foreach((Function1)(JProcedure1 & Serializable)root -> this.traverse$1(x$2, lastIndex, lastSpan, root, NoSource$.MODULE$));
    }

    private static final int toInt$1(boolean b) {
        return b ? 1 : 0;
    }

    private final BitSet pickleDeltas$1(IntRef lastIndex$1, LongRef lastSpan$1, int index, long span) {
        long l;
        int n;
        int addrDelta = index - lastIndex$1.elem;
        int startDelta = Spans$Span$.MODULE$.start$extension(span) - Spans$Span$.MODULE$.start$extension(lastSpan$1.elem);
        int endDelta = Spans$Span$.MODULE$.end$extension(span) - Spans$Span$.MODULE$.end$extension(lastSpan$1.elem);
        this.buf().writeInt(this.header(addrDelta, startDelta != 0, endDelta != 0, !Spans$Span$.MODULE$.isSynthetic$extension(span)));
        if (startDelta != 0) {
            this.buf().writeInt(startDelta);
        }
        if (endDelta != 0) {
            this.buf().writeInt(endDelta);
        }
        if (!Spans$Span$.MODULE$.isSynthetic$extension(span)) {
            this.buf().writeInt(Spans$Span$.MODULE$.pointDelta$extension(span));
        }
        lastIndex$1.elem = n = index;
        lastSpan$1.elem = l = span;
        return (BitSet)this.pickledIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)index));
    }

    private static final String $anonfun$1(Path originalPath$1) {
        return "Could not relativize path for pickling: " + originalPath$1;
    }

    private final void pickleSource$1(Contexts.Context x$2$1, SourceFile source) {
        Path path;
        this.buf().writeInt(4);
        String pathName = source.path();
        Path originalPath = Paths.get(pathName.toString(), new String[0]).normalize();
        if (originalPath.isAbsolute()) {
            Path path2 = originalPath.toAbsolutePath().normalize();
            Path cwd = Paths.get("", new String[0]).toAbsolutePath().normalize();
            try {
                path = cwd.relativize(path2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                report$.MODULE$.warning(Message$.MODULE$.toNoExplanation(() -> PositionPickler.$anonfun$1(originalPath)), report$.MODULE$.warning$default$2(), x$2$1);
                path = originalPath;
            }
        } else {
            path = originalPath;
        }
        Path pickledPath = path;
        this.buf().writeInt(this.pickler.nameBuffer().nameIndex(Decorators$PreNamedString$.MODULE$.extension_toTermName(pickledPath.toString())));
    }

    private static final boolean alwaysNeedsPos$1(Positioned x) {
        Positioned positioned = x;
        return positioned instanceof Trees.WithLazyField || positioned instanceof Trees.DefTree || positioned instanceof Trees.PackageDef || positioned instanceof TreePickler.Hole;
    }

    private final void traverse$1(Contexts.Context x$2$2, IntRef lastIndex$2, LongRef lastSpan$2, Object x, SourceFile current) {
        Object object = x;
        while (true) {
            Object object2;
            if ((object2 = object) instanceof Trees.Tree) {
                Trees.Tree tree;
                Trees.Tree x2 = (Trees.Tree)object2;
                if (Spans$Span$.MODULE$.exists$extension(x2.span())) {
                    int addr;
                    Object object3 = this.addrOfTree.apply((Object)x2);
                    int n = addr = object3 == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.Addr)object3).index();
                    if (TastyBuffer.Addr$.MODULE$.$bang$eq$extension(addr, TastyBuffer$.MODULE$.NoAddr())) {
                        SourceFile sourceFile = x2.source();
                        SourceFile sourceFile2 = current;
                        if (sourceFile == null ? sourceFile2 != null : !((Object)sourceFile).equals(sourceFile2)) {
                            this.pickleDeltas$1(lastIndex$2, lastSpan$2, addr, x2.span());
                            this.pickleSource$1(x$2$2, x2.source());
                        } else if (!this.pickledIndices.contains(addr) && (Spans$Span$.MODULE$.$bang$eq$extension(Spans$Span$.MODULE$.toSynthetic$extension(x2.span()), x2.envelope(x2.source(), x2.envelope$default$2())) || PositionPickler.alwaysNeedsPos$1(x2))) {
                            this.pickleDeltas$1(lastIndex$2, lastSpan$2, addr, x2.span());
                        }
                    }
                }
                if ((tree = x2) instanceof Trees.MemberDef) {
                    Trees.MemberDef x3 = (Trees.MemberDef)tree;
                    this.traverse$1(x$2$2, lastIndex$2, lastSpan$2, Symbols$.MODULE$.toDenot(x3.symbol(x$2$2), x$2$2).annotations(x$2$2), x3.source());
                }
                int limit = x2.productArity();
                for (int n = 0; n < limit; ++n) {
                    this.traverse$1(x$2$2, lastIndex$2, lastSpan$2, x2.productElement(n), x2.source());
                }
                break;
            }
            if (object2 instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)object2;
                List list = colon2.next$access$1();
                Object y = colon2.head();
                List ys = list;
                this.traverse$1(x$2$2, lastIndex$2, lastSpan$2, y, current);
                object = ys;
                continue;
            }
            if (!(object2 instanceof Annotations.Annotation)) break;
            Annotations.Annotation x4 = (Annotations.Annotation)object2;
            object = x4.tree(x$2$2);
        }
    }
}

