/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.runtime.function.JFunction1;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$StringInterpolators$;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.NameOps$NameDecorator$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.ParamInfo;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$NoSymbol$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.reporting.ErrorMessageID$;
import dotty.tools.dotc.reporting.SyntaxMsg;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class WrongNumberOfTypeArgs
extends SyntaxMsg {
    private final Types.Type fntpe;
    private final List<ParamInfo> expectedArgs;
    private final List<Trees.Tree<Null$>> actual;
    private final Contexts.Context x$4;
    private final int expectedCount;
    private final int actualCount;
    private final String msgPrefix;

    public WrongNumberOfTypeArgs(Types.Type fntpe, List<ParamInfo> expectedArgs, List<Trees.Tree<Null$>> actual, Contexts.Context x$4) {
        this.fntpe = fntpe;
        this.expectedArgs = expectedArgs;
        this.actual = actual;
        this.x$4 = x$4;
        super(ErrorMessageID$.WrongNumberOfTypeArgsID);
        this.expectedCount = expectedArgs.length();
        this.actualCount = actual.length();
        this.msgPrefix = this.actualCount > this.expectedCount ? "Too many" : "Not enough";
    }

    @Override
    public String msg() {
        String string;
        String expectedArgString = this.expectedArgs.map((Function1)(JFunction1 & Serializable)_$4 -> {
            Names.Name name = NameOps$.MODULE$.NameDecorator(_$4.paramName(this.x$4));
            return NameOps$NameDecorator$.MODULE$.unexpandedName$extension(name).show(this.x$4);
        }).mkString("[", ", ", "]");
        String actualArgString = this.actual.map((Function1)(JFunction1 & Serializable)_$5 -> _$5.show(this.x$4)).mkString("[", ", ", "]");
        try {
            Symbols.Symbol symbol = this.fntpe.termSymbol(this.x$4);
            if (Symbols$NoSymbol$.MODULE$.equals(symbol)) {
                string = this.fntpe.show(this.x$4);
            } else {
                Symbols.Symbol symbol2 = symbol;
                string = symbol2.showFullName(this.x$4);
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                string = this.fntpe.show(this.x$4);
            }
            throw throwable;
        }
        String prettyName = string;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(Decorators$StringInterpolators$.MODULE$.em$extension(Decorators$.MODULE$.StringInterpolators(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|", " type arguments for ", "", "\n           |expected: ", "\n           |actual:   ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.msgPrefix, prettyName, expectedArgString, expectedArgString, actualArgString}), this.x$4)));
    }

    @Override
    public String explain() {
        String tooManyTypeParams = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|val tuple2: (Int, String) = (1, \"one\")\n           |val list: List[(Int, String)] = List(tuple2)"));
        return this.actualCount > this.expectedCount ? Decorators$StringInterpolators$.MODULE$.em$extension(Decorators$.MODULE$.StringInterpolators(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|You have supplied too many type parameters\n             |\n             |For example List takes a single type parameter (List[A])\n             |If you need to hold more types in a list then you need to combine them\n             |into another data type that can contain the number of types you need,\n             |In this example one solution would be to use a Tuple:\n             |\n             |", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tooManyTypeParams}), this.x$4) : Decorators$StringInterpolators$.MODULE$.em$extension(Decorators$.MODULE$.StringInterpolators(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|You have not supplied enough type parameters\n             |If you specify one type parameter then you need to specify every type parameter."}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), this.x$4);
    }
}

