/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.repl;

import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.repl.InteractiveReader;
import dotty.tools.dotc.repl.Interpreter;
import dotty.tools.dotc.repl.Interpreter$Success$;
import dotty.tools.dotc.repl.ManifestInfo$;
import dotty.tools.dotc.repl.REPL;
import dotty.tools.dotc.reporting.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JProcedure1;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public class InterpreterLoop {
    private final REPL.Config config;
    private final Contexts.Context ctx;
    private final Interpreter interpreter;
    private InteractiveReader in;
    private final ClassLoader originalClassLoader;
    private List replayCommandsRev;
    private final String gitHash;
    private final String version;

    public InterpreterLoop(Compiler compiler, REPL.Config config, Contexts.Context ctx) {
        this.config = config;
        this.ctx = ctx;
        this.interpreter = (Interpreter)((Object)compiler);
        this.in = config.input(this.interpreter(), ctx);
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        this.replayCommandsRev = package$.MODULE$.Nil();
        this.gitHash = (String)ManifestInfo$.MODULE$.attributes().getOrElse((Object)"Git-Hash", InterpreterLoop::$init$$$anonfun$63);
        this.version = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".next (pre-alpha, git-hash: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.gitHash()}));
    }

    public Interpreter interpreter() {
        return this.interpreter;
    }

    private InteractiveReader in() {
        return this.in;
    }

    private void in_$eq(InteractiveReader x$1) {
        this.in = x$1;
    }

    public ClassLoader originalClassLoader() {
        return this.originalClassLoader;
    }

    public List replayCommandsRev() {
        return this.replayCommandsRev;
    }

    public void replayCommandsRev_$eq(List x$1) {
        this.replayCommandsRev = x$1;
    }

    public List replayCommands() {
        return this.replayCommandsRev().reverse();
    }

    public void addReplay(String cmd) {
        String string = cmd;
        this.replayCommandsRev_$eq(this.replayCommandsRev().$colon$colon((Object)string));
    }

    public void closeInterpreter(Contexts.Context ctx) {
        ctx.reporter().flush(ctx);
        Thread.currentThread().setContextClassLoader(this.originalClassLoader());
    }

    public void printHelp() {
        this.printWelcome();
        this.config.output().println("Type :load followed by a filename to load a Scala file.");
        this.config.output().println("Type :replay to reset execution and replay all previous commands.");
        this.config.output().println("Type :quit to exit the interpreter.");
    }

    public void printWelcome() {
        this.config.output().println(new StringBuilder().append((Object)StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Welcome to Scala", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.version()}))).append((Object)" (").append((Object)System.getProperty("java.vm.name")).append((Object)", Java ").append((Object)System.getProperty("java.version")).append((Object)").").toString());
        this.config.output().println("Type in expressions to have them evaluated.");
        this.config.output().println("Type :help for more information.");
        this.config.output().flush();
    }

    public String gitHash() {
        return this.gitHash;
    }

    public String version() {
        return this.version;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void repl(String line) {
        String string = line;
        InterpreterLoop interpreterLoop = this;
        while (string != null) {
            Tuple2 tuple2 = interpreterLoop.command(string);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean keepGoing = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
            Option finalLineOpt = (Option)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)keepGoing), (Object)finalLineOpt);
            boolean keepGoing2 = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
            Option finalLineOpt2 = (Option)tuple22._2();
            if (!keepGoing2) {
                return;
            }
            finalLineOpt2.foreach((Function1)((JProcedure1)arg_0 -> InterpreterLoop.$anonfun$494(interpreterLoop, arg_0)));
            interpreterLoop.config.output().flush();
            string = interpreterLoop.repl$default$1();
        }
    }

    public String repl$default$1() {
        return this.in().readLine(this.config.prompt());
    }

    public void interpretAllFrom(String filename) {
        try {
            String lines = JavaConversions$.MODULE$.asScalaBuffer(Files.readAllLines(Paths.get(filename, new String[0]))).mkString("\n");
            this.config.output().println(new StringBuilder().append((Object)"Loading ").append((Object)filename).append((Object)"...").toString());
            this.config.output().flush();
            this.interpreter().interpret(lines, this.ctx);
        }
        catch (IOException iOException) {
            this.config.output().println(new StringBuilder().append((Object)"Error opening file: ").append((Object)filename).toString());
        }
    }

    public void replay() {
        this.replayCommands().foreach((Function1)((JProcedure1)this::replay$$anonfun$1));
    }

    public Tuple2 command(String line) {
        String helpRegexp = ":h(e(l(p)?)?)?";
        String quitRegexp = ":q(u(i(t)?)?)?";
        String loadRegexp = ":l(o(a(d)?)?)?.*";
        String replayRegexp = ":r(e(p(l(a(y)?)?)?)?)?.*";
        Seq lastOutput = this.interpreter().lastOutput();
        ObjectRef shouldReplay = ObjectRef.create((Object)None$.MODULE$);
        if (line.matches(helpRegexp)) {
            this.printHelp();
        } else {
            if (line.matches(quitRegexp)) {
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$);
            }
            if (line.matches(loadRegexp)) {
                this.withFile$1(line, (Function1)((JProcedure1)arg_0 -> this.command$$anonfun$1(line, shouldReplay, arg_0)));
            } else if (line.matches(replayRegexp)) {
                this.replay();
            } else if (line.startsWith(":")) {
                this.config.output().println("Unknown command.  Type :help for help.");
            } else {
                Option option;
                Seq seq = lastOutput;
                Nil$ nil$ = package$.MODULE$.Nil();
                Seq seq2 = seq;
                if (!(nil$ == null ? seq2 != null : !nil$.equals(seq2))) {
                    option = this.interpretStartingWith(line);
                } else {
                    Seq oldRes = seq;
                    PrintWriter $627$ = this.config.output();
                    oldRes.foreach((Function1)((JProcedure1)arg_0 -> InterpreterLoop.command$$anonfun$2($627$, arg_0)));
                    option = Some$.MODULE$.apply((Object)line);
                }
                Option option2 = option;
                shouldReplay.elem = option2;
            }
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)((Option)shouldReplay.elem));
    }

    public void silentlyRun(List cmds) {
        cmds.foreach((Function1)((JFunction1)this::silentlyRun$$anonfun$1));
    }

    public void silentlyBind(Tuple2[] values) {
        Predef$.MODULE$.refArrayOps((Object[])values).foreach((Function1)((JFunction1)this::silentlyBind$$anonfun$1));
    }

    public Option interpretStartingWith(String code) {
        Interpreter.Result result = this.interpreter().interpret(code, this.ctx);
        return ((Object)Interpreter$Success$.MODULE$).equals(result) ? Some$.MODULE$.apply((Object)code) : None$.MODULE$;
    }

    public Reporter run() {
        try {
            if (!this.ctx.reporter().hasErrors()) {
                this.printWelcome();
                this.silentlyRun(this.config.initialCommands());
                this.silentlyBind(this.config.boundValues());
                this.repl(this.in().readLine(this.config.prompt()));
                this.silentlyRun(this.config.cleanupCommands());
            }
        }
        finally {
            this.closeInterpreter(this.ctx);
        }
        return this.ctx.reporter();
    }

    private static String $init$$$anonfun$63() {
        return "unknown";
    }

    private static void $anonfun$494(InterpreterLoop $this$52, String cmd) {
        $this$52.addReplay(cmd);
    }

    private void replay$$anonfun$1(String cmd) {
        this.config.output().println(new StringBuilder().append((Object)"Replaying: ").append((Object)cmd).toString());
        this.config.output().flush();
        this.command(cmd);
        this.config.output().println();
    }

    private void withFile$1(String command, Function1 action) {
        int spaceIdx = command.indexOf(32);
        if (spaceIdx <= 0) {
            this.config.output().println("That command requires a filename to be specified.");
            return;
        }
        String filename = command.substring(spaceIdx).trim();
        if (!new File(filename).exists()) {
            this.config.output().println("That file does not exist");
            return;
        }
        action.apply((Object)filename);
    }

    private void command$$anonfun$1(String line$2, ObjectRef shouldReplay$1, String f) {
        this.interpretAllFrom(f);
        Some some = Some$.MODULE$.apply((Object)line$2);
        shouldReplay$1.elem = some;
    }

    private static void command$$anonfun$2(PrintWriter $627$$1, String x$0) {
        $627$$1.print(x$0);
    }

    private Interpreter.Result silentlyRun$$anonfun$1$$anonfun$1(String cmd$1) {
        return this.interpreter().interpret(cmd$1, this.ctx);
    }

    private Interpreter.Result silentlyRun$$anonfun$1(String cmd) {
        return (Interpreter.Result)this.interpreter().beQuietDuring(() -> this.silentlyRun$$anonfun$1$$anonfun$1(cmd));
    }

    private Interpreter.Result silentlyBind$$anonfun$1$$anonfun$1(String id$1, Object value$3) {
        return this.interpreter().bind(id$1, value$3.getClass().getName(), value$3, this.ctx);
    }

    private Interpreter.Result silentlyBind$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        Object value = tuple2._2();
        return (Interpreter.Result)this.interpreter().beQuietDuring(() -> this.silentlyBind$$anonfun$1$$anonfun$1(id, value));
    }
}

