/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Directory;
import dotty.tools.io.File;
import dotty.tools.io.Path;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import scala.Function1;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JProcedure1;

public class JarWriter {
    private final File file;
    private final Manifest manifest;
    private JarOutputStream out$lzy1;
    private boolean outbitmap$1;

    public JarWriter(File file, Manifest manifest) {
        this.file = file;
        this.manifest = manifest;
    }

    public File file() {
        return this.file;
    }

    public Manifest manifest() {
        return this.manifest;
    }

    private JarOutputStream out() {
        JarOutputStream jarOutputStream;
        if (this.outbitmap$1) {
            jarOutputStream = this.out$lzy1;
        } else {
            this.outbitmap$1 = true;
            jarOutputStream = this.out$lzy1 = new JarOutputStream((OutputStream)this.file().outputStream(this.file().outputStream$default$1()), this.manifest());
        }
        return jarOutputStream;
    }

    public DataOutputStream newOutputStream(String path) {
        JarEntry entry = new JarEntry(path);
        this.out().putNextEntry(entry);
        return new DataOutputStream(this.out());
    }

    public void writeAllFrom(Directory dir) {
        try {
            dir.list().foreach((Function1)((JProcedure1)this::writeAllFrom$$anonfun$1));
        }
        finally {
            this.out().close();
        }
    }

    public void addStream(JarEntry entry, InputStream in) {
        this.out().putNextEntry(entry);
        try {
            this.transfer(in, this.out());
        }
        finally {
            this.out().closeEntry();
        }
    }

    public void addFile(File file, String prefix) {
        JarEntry entry = new JarEntry(new StringBuilder().append((Object)prefix).append((Object)file.name()).toString());
        this.addStream(entry, file.inputStream());
    }

    public void addEntry(Path entry, String prefix) {
        if (entry.isFile()) {
            this.addFile(entry.toFile(), prefix);
        } else {
            this.addDirectory(entry.toDirectory(), new StringBuilder().append((Object)prefix).append((Object)entry.name()).append((Object)"/").toString());
        }
    }

    public void addDirectory(Directory entry, String prefix) {
        entry.list().foreach((Function1)((JProcedure1)arg_0 -> this.addDirectory$$anonfun$1(prefix, arg_0)));
    }

    private void transfer(InputStream in, OutputStream out) {
        byte[] buf = new byte[10240];
        JarWriter.loop$24(in, out, buf);
    }

    public void close() {
        this.out().close();
    }

    private void writeAllFrom$$anonfun$1(Path x) {
        this.addEntry(x, "");
    }

    private void addDirectory$$anonfun$1(String prefix$43, Path p) {
        this.addEntry(p, prefix$43);
    }

    private static void loop$24(InputStream in$2, OutputStream out$34, byte[] buf$50) {
        while (true) {
            int n;
            if (-1 == (n = in$2.read(buf$50, 0, buf$50.length))) break;
            int n2 = n;
            out$34.write(buf$50, 0, n2);
        }
        in$2.close();
    }
}

