/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core;

import dotty.DottyPredef$;
import dotty.tools.dotc.core.Constraint;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.OrderingConstraint;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.Types$NoType$;
import dotty.tools.dotc.printing.Printer;
import dotty.tools.dotc.printing.Showable;
import dotty.tools.dotc.printing.Texts;
import dotty.tools.dotc.reporting.ConsoleReporter;
import dotty.tools.dotc.reporting.ConsoleReporter$;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.reporting.StoreReporter;
import dotty.tools.dotc.util.DotClass;
import dotty.tools.dotc.util.SimpleIdentityMap$;
import java.lang.ref.WeakReference;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JProcedure1;
import scala.runtime.BoxesRunTime;

public class TyperState
extends DotClass
implements Showable {
    private final TyperState previous;
    private Reporter myReporter;
    private Constraint myConstraint;
    private final Constraint previousConstraint;
    private boolean myEphemeral;
    private boolean myIsCommittable;
    private boolean isCommitted;
    private StoreReporter testReporter;

    public TyperState(TyperState previous) {
        this.previous = previous;
        this.myReporter = previous == null ? new ConsoleReporter(ConsoleReporter$.MODULE$.$lessinit$greater$default$1(), ConsoleReporter$.MODULE$.$lessinit$greater$default$2()) : previous.reporter();
        this.myConstraint = previous == null ? new OrderingConstraint(SimpleIdentityMap$.MODULE$.Empty(), SimpleIdentityMap$.MODULE$.Empty(), SimpleIdentityMap$.MODULE$.Empty()) : previous.constraint();
        this.previousConstraint = previous == null ? this.constraint() : previous.constraint();
        this.myEphemeral = previous == null ? false : previous.ephemeral();
        this.myIsCommittable = true;
        this.isCommitted = false;
        this.testReporter = null;
    }

    public Reporter reporter() {
        return this.myReporter;
    }

    public TyperState setReporter(Reporter reporter) {
        this.myReporter = reporter;
        return this;
    }

    public Constraint constraint() {
        return this.myConstraint;
    }

    public void constraint_$eq(Constraint c, Contexts.Context ctx) {
        this.myConstraint = c;
    }

    private Constraint previousConstraint() {
        return this.previousConstraint;
    }

    public boolean ephemeral() {
        return this.myEphemeral;
    }

    public void ephemeral_$eq(boolean x) {
        this.myEphemeral = x;
    }

    public boolean isCommittable() {
        return this.myIsCommittable;
    }

    public TyperState setCommittable(boolean committable) {
        this.myIsCommittable = committable;
        return this;
    }

    public boolean isGlobalCommittable() {
        return this.isCommittable() && (this.previous == null || this.previous.isGlobalCommittable());
    }

    public TyperState fresh() {
        return new TyperState(this).setReporter(new StoreReporter(this.reporter())).setCommittable(this.isCommittable());
    }

    public Seq uninstVars() {
        return this.constraint().uninstVars();
    }

    public Types.Type instType(Types.TypeVar tvar, Contexts.Context ctx) {
        Types.Type type;
        Types.Type type2 = this.constraint().entry(tvar.origin());
        if (type2 instanceof Types.TypeBounds) {
            Types.TypeBounds typeBounds = (Types.TypeBounds)type2;
            type = Types$NoType$.MODULE$;
        } else if (type2 instanceof Types.TypeParamRef) {
            Types.TypeParamRef typeParamRef;
            Types.TypeParamRef tp = typeParamRef = (Types.TypeParamRef)type2;
            Types.Type tvar1 = this.constraint().typeVarOfParam(tp);
            type = tvar1.exists() ? tvar1 : tp;
        } else {
            Types.Type tp = type2;
            type = tp;
        }
        return type;
    }

    public TyperState uncommittedAncestor() {
        return this.isCommitted ? this.previous.uncommittedAncestor() : this;
    }

    public boolean test(Function0 op) {
        boolean bl;
        Reporter savedReporter = this.myReporter;
        Constraint savedConstraint = this.myConstraint;
        boolean savedCommittable = this.myIsCommittable;
        boolean savedCommitted = this.isCommitted;
        this.myIsCommittable = false;
        if (this.testReporter == null) {
            this.testReporter = new StoreReporter(this.reporter());
        } else {
            this.testReporter.reset();
        }
        this.myReporter = this.testReporter;
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)op.apply());
        }
        finally {
            this.myReporter = savedReporter;
            this.myConstraint = savedConstraint;
            this.myIsCommittable = savedCommittable;
            this.isCommitted = savedCommitted;
        }
        return bl;
    }

    public void commit(Contexts.Context ctx) {
        TyperState targetState = ctx.typerState();
        boolean assertion = this.isCommittable();
        if (!assertion) {
            DottyPredef$.MODULE$.assertFail();
        }
        targetState.constraint_$eq(targetState.constraint() == this.previousConstraint() ? this.constraint() : targetState.constraint().$amp(this.constraint(), ctx), ctx);
        this.constraint().foreachTypeVar((Function1)((JProcedure1)arg_0 -> this.commit$$anonfun$1(targetState, arg_0)));
        targetState.ephemeral_$eq(targetState.ephemeral() | this.ephemeral());
        targetState.gc(ctx);
        this.reporter().flush(ctx);
        this.isCommitted = true;
    }

    public void gc(Contexts.Context ctx) {
        ListBuffer toCollect = new ListBuffer();
        this.constraint().foreachTypeVar((Function1)((JProcedure1)arg_0 -> this.gc$$anonfun$2(ctx, toCollect, arg_0)));
        toCollect.foreach((Function1)((JProcedure1)arg_0 -> this.gc$$anonfun$1(ctx, arg_0)));
    }

    @Override
    public Texts.Text toText(Printer printer) {
        return this.constraint().toText(printer);
    }

    public String hashesStr() {
        return this.previous == null ? "" : new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)this.hashCode())).toString()).append((Object)" -> ").append((Object)this.previous.hashesStr()).toString();
    }

    private void commit$$anonfun$1(TyperState targetState$1, Types.TypeVar tvar) {
        block0: {
            if (tvar.owningState().get() != this) break block0;
            tvar.owningState_$eq(new WeakReference<TyperState>(targetState$1));
        }
    }

    private void gc$$anonfun$2(Contexts.Context ctx$466, ListBuffer toCollect$1, Types.TypeVar tvar) {
        block1: {
            Types.Type inst;
            if (tvar.inst().exists() || !(inst = this.instType(tvar, ctx$466)).exists() || tvar.owningState().get() != this) break block1;
            tvar.inst_$eq(inst);
            Types.TypeLambda lam = tvar.origin().binder();
            if (this.constraint().isRemovable(lam)) {
                toCollect$1.$plus$eq((Object)lam);
            }
        }
    }

    private void gc$$anonfun$1(Contexts.Context ctx$467, Types.TypeLambda poly) {
        this.constraint_$eq(this.constraint().remove(poly, ctx$467), ctx$467);
    }
}

