/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$Context$;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$StringInterpolators$;
import dotty.tools.dotc.printing.Highlighting;
import dotty.tools.dotc.printing.Highlighting$Blue$;
import dotty.tools.dotc.printing.Highlighting$Red$;
import dotty.tools.dotc.printing.SyntaxHighlighting$;
import dotty.tools.dotc.reporting.diagnostic.ErrorMessageID;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.reporting.diagnostic.messages;
import dotty.tools.dotc.util.SourcePosition;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.StringBuilder$;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JFunction2;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public interface MessageRendering {
    default public void $init$() {
    }

    default public String stripColor(String str) {
        return str.replaceAll("\u001b\\[.*?m", "");
    }

    default public List outer(SourcePosition pos, String prefix, Contexts.Context ctx) {
        Nil$ nil$;
        if (pos.outer().exists()) {
            String string = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "| This location is in code that was inlined at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, pos.outer()}));
            nil$ = this.outer(pos.outer(), prefix, ctx).$colon$colon((Object)string);
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    default public Tuple3 sourceLines(SourcePosition pos, Contexts.Context ctx) {
        IntRef maxLen = IntRef.create((int)Integer.MIN_VALUE);
        Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase(ctx).settings().color());
        Object object = Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx);
        String string = "never";
        char[] syntax = (object == null ? string != null : !object.equals(string)) ? (char[])SyntaxHighlighting$.MODULE$.apply((Iterable)Predef$.MODULE$.wrapCharArray(pos.linesSlice())).toArray(ClassTag$.MODULE$.apply(Character.TYPE)) : pos.linesSlice();
        List lines = MessageRendering.dotty$tools$dotc$reporting$MessageRendering$sourceLines$$linesFrom$1(syntax);
        Tuple2 tuple2 = pos.beforeAndAfterPoint();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List before = (List)tuple2._1();
        List after = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)before, (Object)after);
        List before2 = (List)tuple22._1();
        List after2 = (List)tuple22._2();
        return Tuple3$.MODULE$.apply(((List)before2.zip((GenIterable)lines, List$.MODULE$.canBuildFrom())).map((Function1)((JFunction1)arg_0 -> MessageRendering.sourceLines$$anonfun$2(pos, ctx, maxLen, arg_0)), List$.MODULE$.canBuildFrom()), ((List)after2.zip((GenIterable)lines.drop(before2.length()), List$.MODULE$.canBuildFrom())).map((Function1)((JFunction1)arg_0 -> MessageRendering.sourceLines$$anonfun$1(pos, ctx, maxLen, arg_0)), List$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToInteger((int)maxLen.elem));
    }

    default public String columnMarker(SourcePosition pos, int offset, Contexts.Context ctx) {
        String prefix = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(offset - 1);
        String padding = pos.startColumnPadding();
        Highlighting.Red carets = Highlighting$Red$.MODULE$.apply(pos.startLine() == pos.endLine() ? new StringOps(Predef$.MODULE$.augmentString("^")).$times(scala.math.package$.MODULE$.max(1, pos.endColumn() - pos.startColumn())) : "^");
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "|", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, padding, carets.show(ctx)}));
    }

    default public String errorMsg(SourcePosition pos, String msg, int offset, Contexts.Context ctx) {
        String padding = (String)new StringOps(Predef$.MODULE$.augmentString(msg)).lines().foldLeft((Object)pos.startColumnPadding(), (Function2)((JFunction2)(arg_0, arg_1) -> this.$anonfun$1(offset, ctx, arg_0, arg_1)));
        return new StringOps(Predef$.MODULE$.augmentString(msg)).lines().map((Function1)((JFunction1)arg_0 -> MessageRendering.errorMsg$$anonfun$1(offset, padding, arg_0))).mkString((String)scala.sys.package$.MODULE$.props().apply((Object)"line.separator"));
    }

    default public String posStr(SourcePosition pos, String diagnosticLevel, Message message, Contexts.Context ctx) {
        String string;
        if (pos.exists()) {
            String string2;
            String file = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pos.source().file().toString(), BoxesRunTime.boxToInteger((int)(pos.line() + 1)), BoxesRunTime.boxToInteger((int)pos.column())}));
            if (message.errorId() != ErrorMessageID.NoExplanationID) {
                int errorNumber = message.errorId().errorNumber();
                string2 = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[E", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("0")).$times(3 - ((Object)BoxesRunTime.boxToInteger((int)errorNumber)).toString().length())).append((Object)BoxesRunTime.boxToInteger((int)errorNumber)).toString()}));
            } else {
                string2 = "";
            }
            String errId = string2;
            String string3 = message.kind();
            String string4 = "";
            String kind = !(string3 != null ? !string3.equals(string4) : string4 != null) ? diagnosticLevel : StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.kind(), diagnosticLevel}));
            String prefix = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-- ", "", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errId, kind, file}));
            Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase(ctx).settings().pageWidth());
            string = Highlighting$Blue$.MODULE$.apply(new StringBuilder().append((Object)prefix).append((Object)new StringOps(Predef$.MODULE$.augmentString("-")).$times(scala.math.package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx)) - this.stripColor(prefix).length(), 0))).toString()).show(ctx);
        } else {
            string = "";
        }
        return string;
    }

    default public String explanation(Message m, Contexts.Context ctx) {
        StringBuilder sb = new StringBuilder(Decorators$StringInterpolators$.MODULE$.hl$extension(Decorators$.MODULE$.StringInterpolators(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n           |", "\n           |", ""}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Highlighting$Blue$.MODULE$.apply("Explanation"), Highlighting$Blue$.MODULE$.apply("===========")}), ctx));
        sb.append('\n').append(m.explanation());
        Option option = new StringOps(Predef$.MODULE$.augmentString(m.explanation())).lastOption();
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\n'));
        Object object = (option == null ? some != null : !option.equals(some)) ? sb.append('\n') : BoxedUnit.UNIT;
        return sb.toString();
    }

    default public String messageAndPos(Message msg, SourcePosition pos, String diagnosticLevel, Contexts.Context ctx) {
        StringBuilder stringBuilder;
        StringBuilder sb = StringBuilder$.MODULE$.newBuilder();
        sb.append(this.posStr(pos, diagnosticLevel, msg, ctx)).append('\n');
        if (pos.exists()) {
            Tuple3 tuple3 = this.sourceLines(pos, ctx);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            List srcBefore = (List)tuple3._1();
            List srcAfter = (List)tuple3._2();
            int offset = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)srcBefore, (Object)srcAfter, (Object)BoxesRunTime.boxToInteger((int)offset));
            List srcBefore2 = (List)tuple32._1();
            List srcAfter2 = (List)tuple32._2();
            int offset2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
            String marker = this.columnMarker(pos, offset2, ctx);
            String err = this.errorMsg(pos, msg.msg(), offset2, ctx);
            List list = srcBefore2;
            String string = marker;
            String string2 = err;
            List list2 = this.outer(pos, new StringOps(Predef$.MODULE$.augmentString(" ")).$times(offset2 - 1), ctx);
            stringBuilder = sb.append(srcAfter2.$colon$colon$colon(list2).$colon$colon((Object)string2).$colon$colon((Object)string).$colon$colon$colon(list).mkString("\n"));
        } else {
            stringBuilder = sb.append(msg.msg());
        }
        return sb.toString();
    }

    default public String diagnosticLevel(MessageContainer cont) {
        String string;
        MessageContainer messageContainer = cont;
        if (messageContainer instanceof messages.Error) {
            messages.Error error;
            messages.Error m = error = (messages.Error)messageContainer;
            string = "Error";
        } else if (messageContainer instanceof messages.FeatureWarning) {
            messages.FeatureWarning featureWarning;
            messages.FeatureWarning m = featureWarning = (messages.FeatureWarning)messageContainer;
            string = "Feature Warning";
        } else if (messageContainer instanceof messages.DeprecationWarning) {
            messages.DeprecationWarning deprecationWarning;
            messages.DeprecationWarning m = deprecationWarning = (messages.DeprecationWarning)messageContainer;
            string = "Deprecation Warning";
        } else if (messageContainer instanceof messages.UncheckedWarning) {
            messages.UncheckedWarning uncheckedWarning;
            messages.UncheckedWarning m = uncheckedWarning = (messages.UncheckedWarning)messageContainer;
            string = "Unchecked Warning";
        } else if (messageContainer instanceof messages.MigrationWarning) {
            messages.MigrationWarning migrationWarning;
            messages.MigrationWarning m = migrationWarning = (messages.MigrationWarning)messageContainer;
            string = "Migration Warning";
        } else if (messageContainer instanceof messages.Warning) {
            messages.Warning warning;
            messages.Warning m = warning = (messages.Warning)messageContainer;
            string = "Warning";
        } else if (messageContainer instanceof messages.Info) {
            messages.Info info;
            messages.Info m = info = (messages.Info)messageContainer;
            string = "Info";
        } else {
            throw new MatchError((Object)messageContainer);
        }
        return string;
    }

    public static String dotty$tools$dotc$reporting$MessageRendering$sourceLines$$render$1(SourcePosition pos$18, Contexts.Context ctx$932, IntRef maxLen$2, Tuple2 offsetAndLine) {
        int n;
        Tuple2 tuple2 = offsetAndLine;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int offset = BoxesRunTime.unboxToInt((Object)tuple2._1());
        String line = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)offset), (Object)line);
        int offset2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        String line2 = (String)tuple22._2();
        int lineNbr = pos$18.source().offsetToLine(offset2);
        String prefix = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(lineNbr + 1))}));
        maxLen$2.elem = n = scala.math.package$.MODULE$.max(maxLen$2.elem, prefix.length());
        String lnum = Highlighting$Red$.MODULE$.apply(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(scala.math.package$.MODULE$.max(0, maxLen$2.elem - prefix.length()))).append((Object)prefix).toString()).show(ctx$932);
        return new StringBuilder().append((Object)lnum).append((Object)new StringOps(Predef$.MODULE$.augmentString(line2)).stripLineEnd()).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean dotty$tools$dotc$reporting$MessageRendering$linesFrom$1$$pred$1(char c) {
        char c2 = c;
        switch (c2) {
            case '\n': {
                return true;
            }
            case '\r': {
                return true;
            }
            case '\f': {
                return true;
            }
            case '\u001a': {
                return true;
            }
            default: {
                return false;
            }
        }
    }

    public static boolean dotty$tools$dotc$reporting$MessageRendering$_$$619$$$anonfun$3(char _$517) {
        return !MessageRendering.dotty$tools$dotc$reporting$MessageRendering$linesFrom$1$$pred$1(_$517);
    }

    public static boolean dotty$tools$dotc$reporting$MessageRendering$_$_$x10750$$$anonfun$adapted$2(Object _$517) {
        return MessageRendering.dotty$tools$dotc$reporting$MessageRendering$_$$619$$$anonfun$3(BoxesRunTime.unboxToChar((Object)_$517));
    }

    public static boolean dotty$tools$dotc$reporting$MessageRendering$_$rest$$$anonfun$2(char c) {
        return MessageRendering.dotty$tools$dotc$reporting$MessageRendering$linesFrom$1$$pred$1(c);
    }

    public static boolean dotty$tools$dotc$reporting$MessageRendering$_$_$x10753$$$anonfun$adapted$1(Object c) {
        return MessageRendering.dotty$tools$dotc$reporting$MessageRendering$_$rest$$$anonfun$2(BoxesRunTime.unboxToChar((Object)c));
    }

    public static List dotty$tools$dotc$reporting$MessageRendering$sourceLines$$linesFrom$1(char[] arr) {
        Tuple2 tuple2 = new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(arr)).span((Function1)((JFunction1)MessageRendering::dotty$tools$dotc$reporting$MessageRendering$_$_$x10750$$$anonfun$adapted$2));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        char[] line = (char[])tuple2._1();
        char[] rest0 = (char[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)line, (Object)rest0);
        char[] line2 = (char[])tuple22._1();
        char[] rest02 = (char[])tuple22._2();
        Tuple2 tuple23 = new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(rest02)).span((Function1)((JFunction1)MessageRendering::dotty$tools$dotc$reporting$MessageRendering$_$_$x10753$$$anonfun$adapted$1));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        char[] rest = (char[])tuple23._2();
        char[] rest2 = rest;
        String string = new String(line2);
        return (new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(rest2)).isEmpty() ? package$.MODULE$.Nil() : MessageRendering.dotty$tools$dotc$reporting$MessageRendering$sourceLines$$linesFrom$1(rest2)).$colon$colon((Object)string);
    }

    private static String sourceLines$$anonfun$2(SourcePosition pos$19, Contexts.Context ctx$934, IntRef maxLen$3, Tuple2 offsetAndLine) {
        return MessageRendering.dotty$tools$dotc$reporting$MessageRendering$sourceLines$$render$1(pos$19, ctx$934, maxLen$3, offsetAndLine);
    }

    private static String sourceLines$$anonfun$1(SourcePosition pos$20, Contexts.Context ctx$935, IntRef maxLen$4, Tuple2 offsetAndLine) {
        return MessageRendering.dotty$tools$dotc$reporting$MessageRendering$sourceLines$$render$1(pos$20, ctx$935, maxLen$4, offsetAndLine);
    }

    private String $anonfun$1(int offset$2, Contexts.Context ctx$933, String pad, String line) {
        int lineLength = this.stripColor(line).length();
        Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase(ctx$933).settings().pageWidth());
        int maxPad = scala.math.package$.MODULE$.max(0, BoxesRunTime.unboxToInt((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx$933)) - offset$2 - lineLength) - offset$2;
        return maxPad < pad.length() ? new StringOps(Predef$.MODULE$.augmentString(" ")).$times(maxPad) : pad;
    }

    private static String errorMsg$$anonfun$1(int offset$3, String padding$1, String line) {
        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(offset$3 - 1)).append((Object)"|").append((Object)padding$1).append((Object)line).toString();
    }
}

