/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.DottyPredef$;
import dotty.tools.io.AbstractFile$;
import dotty.tools.io.File;
import dotty.tools.io.Path;
import dotty.tools.io.Path$;
import dotty.tools.io.PlainFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import scala.Char$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.compat.java8.JFunction3;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;

public abstract class AbstractFile
implements Iterable {
    private final String extension;

    public static AbstractFile getDirectory(File file) {
        return AbstractFile$.MODULE$.getDirectory(file);
    }

    public static AbstractFile getDirectory(Path path) {
        return AbstractFile$.MODULE$.getDirectory(path);
    }

    public static AbstractFile getURL(URL uRL) {
        return AbstractFile$.MODULE$.getURL(uRL);
    }

    public static AbstractFile getResources(URL uRL) {
        return AbstractFile$.MODULE$.getResources(uRL);
    }

    public static AbstractFile getFile(File file) {
        return AbstractFile$.MODULE$.getFile(file);
    }

    public static AbstractFile getFile(Path path) {
        return AbstractFile$.MODULE$.getFile(path);
    }

    public static AbstractFile getFile(String string) {
        return AbstractFile$.MODULE$.getFile(string);
    }

    public AbstractFile() {
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Parallelizable.$init$((Parallelizable)this);
        TraversableLike.$init$((TraversableLike)this);
        GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
        GenTraversable.$init$((GenTraversable)this);
        Traversable.$init$((Traversable)this);
        GenIterable.$init$((GenIterable)this);
        IterableLike.$init$((IterableLike)this);
        Iterable.$init$((Iterable)this);
        this.extension = Path$.MODULE$.extension(this.name());
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    public List reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.size$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1 p) {
        return TraversableOnce.count$((TraversableOnce)this, (Function1)p);
    }

    public Option collectFirst(PartialFunction pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, (PartialFunction)pf);
    }

    public Object $div$colon(Object z, Function2 op) {
        return TraversableOnce.$div$colon$((TraversableOnce)this, (Object)z, (Function2)op);
    }

    public Object $colon$bslash(Object z, Function2 op) {
        return TraversableOnce.$colon$bslash$((TraversableOnce)this, (Object)z, (Function2)op);
    }

    public Object foldLeft(Object z, Function2 op) {
        return TraversableOnce.foldLeft$((TraversableOnce)this, (Object)z, (Function2)op);
    }

    public Object reduceLeft(Function2 op) {
        return TraversableOnce.reduceLeft$((TraversableOnce)this, (Function2)op);
    }

    public Option reduceLeftOption(Function2 op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, (Function2)op);
    }

    public Option reduceRightOption(Function2 op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, (Function2)op);
    }

    public Object reduce(Function2 op) {
        return TraversableOnce.reduce$((TraversableOnce)this, (Function2)op);
    }

    public Option reduceOption(Function2 op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, (Function2)op);
    }

    public Object fold(Object z, Function2 op) {
        return TraversableOnce.fold$((TraversableOnce)this, (Object)z, (Function2)op);
    }

    public Object aggregate(Function0 z, Function2 seqop, Function2 combop) {
        return TraversableOnce.aggregate$((TraversableOnce)this, (Function0)z, (Function2)seqop, (Function2)combop);
    }

    public Object sum(Numeric num) {
        return TraversableOnce.sum$((TraversableOnce)this, (Numeric)num);
    }

    public Object product(Numeric num) {
        return TraversableOnce.product$((TraversableOnce)this, (Numeric)num);
    }

    public AbstractFile min(Ordering cmp) {
        return (AbstractFile)TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public AbstractFile max(Ordering cmp) {
        return (AbstractFile)TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public AbstractFile maxBy(Function1 f, Ordering cmp) {
        return (AbstractFile)TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public AbstractFile minBy(Function1 f, Ordering cmp) {
        return (AbstractFile)TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public void copyToBuffer(Buffer dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, (Buffer)dest);
    }

    public void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public Object toArray(ClassTag evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, (ClassTag)evidence$1);
    }

    public List toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Seq toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public Buffer toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public Set toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public Map toMap(Predef.$less$colon$less ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, (Predef.$less$colon$less)ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public ParIterable par() {
        return (ParIterable)Parallelizable.par$((Parallelizable)this);
    }

    public Iterable repr() {
        return (Iterable)TraversableLike.repr$((TraversableLike)this);
    }

    public final boolean isTraversableAgain() {
        return TraversableLike.isTraversableAgain$((TraversableLike)this);
    }

    public Combiner parCombiner() {
        return TraversableLike.parCombiner$((TraversableLike)this);
    }

    public boolean hasDefiniteSize() {
        return TraversableLike.hasDefiniteSize$((TraversableLike)this);
    }

    public Object $plus$plus(GenTraversableOnce that, CanBuildFrom bf) {
        return TraversableLike.$plus$plus$((TraversableLike)this, (GenTraversableOnce)that, (CanBuildFrom)bf);
    }

    public Object $plus$plus$colon(TraversableOnce that, CanBuildFrom bf) {
        return TraversableLike.$plus$plus$colon$((TraversableLike)this, (TraversableOnce)that, (CanBuildFrom)bf);
    }

    public Object $plus$plus$colon(Traversable that, CanBuildFrom bf) {
        return TraversableLike.$plus$plus$colon$((TraversableLike)this, (Traversable)that, (CanBuildFrom)bf);
    }

    public Object map(Function1 f, CanBuildFrom bf) {
        return TraversableLike.map$((TraversableLike)this, (Function1)f, (CanBuildFrom)bf);
    }

    public Object flatMap(Function1 f, CanBuildFrom bf) {
        return TraversableLike.flatMap$((TraversableLike)this, (Function1)f, (CanBuildFrom)bf);
    }

    public Iterable filterImpl(Function1 p, boolean isFlipped) {
        return (Iterable)TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
    }

    public Iterable filter(Function1 p) {
        return (Iterable)TraversableLike.filter$((TraversableLike)this, (Function1)p);
    }

    public Iterable filterNot(Function1 p) {
        return (Iterable)TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
    }

    public Object collect(PartialFunction pf, CanBuildFrom bf) {
        return TraversableLike.collect$((TraversableLike)this, (PartialFunction)pf, (CanBuildFrom)bf);
    }

    public Tuple2 partition(Function1 p) {
        return TraversableLike.partition$((TraversableLike)this, (Function1)p);
    }

    public Map groupBy(Function1 f) {
        return TraversableLike.groupBy$((TraversableLike)this, (Function1)f);
    }

    public Object scan(Object z, Function2 op, CanBuildFrom cbf) {
        return TraversableLike.scan$((TraversableLike)this, (Object)z, (Function2)op, (CanBuildFrom)cbf);
    }

    public Object scanLeft(Object z, Function2 op, CanBuildFrom bf) {
        return TraversableLike.scanLeft$((TraversableLike)this, (Object)z, (Function2)op, (CanBuildFrom)bf);
    }

    public Object scanRight(Object z, Function2 op, CanBuildFrom bf) {
        return TraversableLike.scanRight$((TraversableLike)this, (Object)z, (Function2)op, (CanBuildFrom)bf);
    }

    public Option headOption() {
        return TraversableLike.headOption$((TraversableLike)this);
    }

    public Iterable tail() {
        return (Iterable)TraversableLike.tail$((TraversableLike)this);
    }

    public AbstractFile last() {
        return (AbstractFile)TraversableLike.last$((TraversableLike)this);
    }

    public Option lastOption() {
        return TraversableLike.lastOption$((TraversableLike)this);
    }

    public Iterable init() {
        return (Iterable)TraversableLike.init$((TraversableLike)this);
    }

    public Iterable sliceWithKnownDelta(int from, int until, int delta) {
        return (Iterable)TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
    }

    public Iterable sliceWithKnownBound(int from, int until) {
        return (Iterable)TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
    }

    public Iterable dropWhile(Function1 p) {
        return (Iterable)TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
    }

    public Tuple2 span(Function1 p) {
        return TraversableLike.span$((TraversableLike)this, (Function1)p);
    }

    public Tuple2 splitAt(int n) {
        return TraversableLike.splitAt$((TraversableLike)this, (int)n);
    }

    public Iterator tails() {
        return TraversableLike.tails$((TraversableLike)this);
    }

    public Iterator inits() {
        return TraversableLike.inits$((TraversableLike)this);
    }

    public Traversable toTraversable() {
        return TraversableLike.toTraversable$((TraversableLike)this);
    }

    public Object to(CanBuildFrom cbf) {
        return TraversableLike.to$((TraversableLike)this, (CanBuildFrom)cbf);
    }

    public String stringPrefix() {
        return TraversableLike.stringPrefix$((TraversableLike)this);
    }

    public FilterMonadic withFilter(Function1 p) {
        return TraversableLike.withFilter$((TraversableLike)this, (Function1)p);
    }

    public Builder newBuilder() {
        return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
    }

    public Builder genericBuilder() {
        return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
    }

    public Tuple2 unzip(Function1 asPair) {
        return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, (Function1)asPair);
    }

    public Tuple3 unzip3(Function1 asTriple) {
        return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, (Function1)asTriple);
    }

    public Iterable flatten(Function1 asTraversable) {
        return (Iterable)GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
    }

    public Iterable transpose(Function1 asTraversable) {
        return (Iterable)GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
    }

    public Iterable thisCollection() {
        return IterableLike.thisCollection$((IterableLike)this);
    }

    public Iterable toCollection(Iterable repr) {
        return IterableLike.toCollection$((IterableLike)this, (Object)repr);
    }

    public void foreach(Function1 f) {
        IterableLike.foreach$((IterableLike)this, (Function1)f);
    }

    public boolean forall(Function1 p) {
        return IterableLike.forall$((IterableLike)this, (Function1)p);
    }

    public boolean exists(Function1 p) {
        return IterableLike.exists$((IterableLike)this, (Function1)p);
    }

    public Option find(Function1 p) {
        return IterableLike.find$((IterableLike)this, (Function1)p);
    }

    public boolean isEmpty() {
        return IterableLike.isEmpty$((IterableLike)this);
    }

    public Object foldRight(Object z, Function2 op) {
        return IterableLike.foldRight$((IterableLike)this, (Object)z, (Function2)op);
    }

    public Object reduceRight(Function2 op) {
        return IterableLike.reduceRight$((IterableLike)this, (Function2)op);
    }

    public Iterable toIterable() {
        return IterableLike.toIterable$((IterableLike)this);
    }

    public Iterator toIterator() {
        return IterableLike.toIterator$((IterableLike)this);
    }

    public AbstractFile head() {
        return (AbstractFile)IterableLike.head$((IterableLike)this);
    }

    public Iterable slice(int from, int until) {
        return (Iterable)IterableLike.slice$((IterableLike)this, (int)from, (int)until);
    }

    public Iterable take(int n) {
        return (Iterable)IterableLike.take$((IterableLike)this, (int)n);
    }

    public Iterable drop(int n) {
        return (Iterable)IterableLike.drop$((IterableLike)this, (int)n);
    }

    public Iterable takeWhile(Function1 p) {
        return (Iterable)IterableLike.takeWhile$((IterableLike)this, (Function1)p);
    }

    public Iterator grouped(int size) {
        return IterableLike.grouped$((IterableLike)this, (int)size);
    }

    public Iterator sliding(int size) {
        return IterableLike.sliding$((IterableLike)this, (int)size);
    }

    public Iterator sliding(int size, int step) {
        return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
    }

    public Iterable takeRight(int n) {
        return (Iterable)IterableLike.takeRight$((IterableLike)this, (int)n);
    }

    public Iterable dropRight(int n) {
        return (Iterable)IterableLike.dropRight$((IterableLike)this, (int)n);
    }

    public void copyToArray(Object xs, int start, int len) {
        IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
    }

    public Object zip(GenIterable that, CanBuildFrom bf) {
        return IterableLike.zip$((IterableLike)this, (GenIterable)that, (CanBuildFrom)bf);
    }

    public Object zipAll(GenIterable that, Object thisElem, Object thatElem, CanBuildFrom bf) {
        return IterableLike.zipAll$((IterableLike)this, (GenIterable)that, (Object)thisElem, (Object)thatElem, (CanBuildFrom)bf);
    }

    public Object zipWithIndex(CanBuildFrom bf) {
        return IterableLike.zipWithIndex$((IterableLike)this, (CanBuildFrom)bf);
    }

    public boolean sameElements(GenIterable that) {
        return IterableLike.sameElements$((IterableLike)this, (GenIterable)that);
    }

    public Stream toStream() {
        return IterableLike.toStream$((IterableLike)this);
    }

    public boolean canEqual(Object that) {
        return IterableLike.canEqual$((IterableLike)this, (Object)that);
    }

    public IterableView view() {
        return IterableLike.view$((IterableLike)this);
    }

    public IterableView view(int from, int until) {
        return IterableLike.view$((IterableLike)this, (int)from, (int)until);
    }

    public GenericCompanion companion() {
        return Iterable.companion$((Iterable)this);
    }

    public Iterable seq() {
        return Iterable.seq$((Iterable)this);
    }

    public abstract String name();

    public abstract String path();

    public String canonicalPath() {
        return this.file() == null ? this.path() : this.file().getCanonicalPath();
    }

    public boolean hasExtension(String other) {
        String string = this.extension();
        String string2 = other.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private String extension() {
        return this.extension;
    }

    public abstract AbstractFile absolute();

    public abstract AbstractFile container();

    public abstract java.io.File file();

    public Option underlyingSource() {
        return None$.MODULE$;
    }

    public boolean exists() {
        return this.file() == null || this.file().exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClassContainer() {
        if (this.isDirectory()) return true;
        if (this.file() == null) return false;
        String string = this.extension();
        String string2 = "jar";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = this.extension();
        String string4 = "zip";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public abstract void create();

    public abstract void delete();

    public abstract boolean isDirectory();

    public boolean isVirtual() {
        return false;
    }

    public abstract long lastModified();

    public abstract InputStream input();

    public abstract OutputStream output();

    public BufferedOutputStream bufferedOutput() {
        return new BufferedOutputStream(this.output());
    }

    public Option sizeOption() {
        return None$.MODULE$;
    }

    public URL toURL() {
        return this.file() == null ? null : this.file().toURI().toURL();
    }

    public char[] toCharArray() {
        return new String(this.toByteArray()).toCharArray();
    }

    public byte[] toByteArray() {
        byte[] byArray;
        InputStream in = this.input();
        Option option = this.sizeOption();
        if (option instanceof Some) {
            int size;
            int res;
            int rest;
            Some some = (Some)option;
            byte[] arr = new byte[rest];
            for (rest = size = BoxesRunTime.unboxToInt((Object)some.value()); rest > 0; rest -= res) {
                res = in.read(arr, arr.length - rest, rest);
                if (res != -1) continue;
                throw new IOException("read error");
            }
            in.close();
            byArray = arr;
        } else if (None$.MODULE$.equals(option)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = in.read();
            while (c != -1) {
                out.write(c);
                c = in.read();
            }
            in.close();
            byArray = out.toByteArray();
        } else {
            throw new MatchError((Object)option);
        }
        return byArray;
    }

    public abstract Iterator iterator();

    public abstract AbstractFile lookupName(String var1, boolean var2);

    public abstract AbstractFile lookupNameUnchecked(String var1, boolean var2);

    public AbstractFile lookupPathUnchecked(String path, boolean directory) {
        return this.lookup((Function3)((JFunction3)AbstractFile::lookupPathUnchecked$$anonfun$adapted$1), path, directory);
    }

    private AbstractFile lookup(Function3 getFile, String path0, boolean directory) {
        boolean assertion;
        char separator = java.io.File.separatorChar;
        String path = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(path0)).last()) == separator ? (String)new StringOps(Predef$.MODULE$.augmentString(path0)).dropRight(1) : path0;
        int length = path.length();
        boolean bl = assertion = length > 0 && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(path)).last()) != separator;
        if (!assertion) {
            DottyPredef$.MODULE$.assertFail(() -> AbstractFile.lookup$$anonfun$1(path));
        }
        AbstractFile file = this;
        IntRef start = IntRef.create((int)0);
        while (true) {
            int n;
            String name;
            int index;
            boolean assertion2;
            boolean bl2 = assertion2 = (index = path.indexOf(Char$.MODULE$.char2int(separator), start.elem)) < 0 || start.elem < index;
            if (!assertion2) {
                DottyPredef$.MODULE$.assertFail(() -> AbstractFile.$anonfun$1(directory, path, start, index));
            }
            if ((file = (AbstractFile)getFile.apply((Object)file, (Object)(name = path.substring(start.elem, index < 0 ? length : index)), (Object)(index < 0 ? BoxesRunTime.boxToBoolean((boolean)directory) : BoxesRunTime.boxToBoolean((boolean)true)))) == null || index < 0) {
                return file;
            }
            start.elem = n = index + 1;
        }
    }

    private AbstractFile fileOrSubdirectoryNamed(String name, boolean isDir) {
        AbstractFile abstractFile;
        AbstractFile lookup = this.lookupName(name, isDir);
        if (lookup != null) {
            abstractFile = lookup;
        } else {
            java.io.File jfile = new java.io.File(this.file(), name);
            boolean bl = isDir ? jfile.mkdirs() : jfile.createNewFile();
            abstractFile = new PlainFile(Path$.MODULE$.jfile2path(jfile));
        }
        return abstractFile;
    }

    public AbstractFile fileNamed(String name) {
        block0: {
            boolean assertion = this.isDirectory();
            if (assertion) break block0;
            DottyPredef$.MODULE$.assertFail(() -> this.fileNamed$$anonfun$1(name));
        }
        return this.fileOrSubdirectoryNamed(name, false);
    }

    public AbstractFile subdirectoryNamed(String name) {
        block0: {
            boolean assertion = this.isDirectory();
            if (assertion) break block0;
            DottyPredef$.MODULE$.assertFail(() -> this.subdirectoryNamed$$anonfun$1(name));
        }
        return this.fileOrSubdirectoryNamed(name, true);
    }

    public Nothing$ unsupported() {
        return this.unsupported(null);
    }

    public Nothing$ unsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    public String toString() {
        return this.path();
    }

    public static AbstractFile dotty$tools$io$AbstractFile$lookupPathUnchecked$$lookupPathUnchecked$$anonfun$1$1(AbstractFile f, String p, boolean dir) {
        return f.lookupNameUnchecked(p, dir);
    }

    private static AbstractFile lookupPathUnchecked$$anonfun$adapted$1(Object f, Object p, Object dir) {
        return AbstractFile.dotty$tools$io$AbstractFile$lookupPathUnchecked$$lookupPathUnchecked$$anonfun$1$1((AbstractFile)f, (String)p, BoxesRunTime.unboxToBoolean((Object)dir));
    }

    private static String lookup$$anonfun$1(String path$4) {
        return path$4;
    }

    public static Tuple4 dotty$tools$io$AbstractFile$_$while$$$message$3(boolean directory$1, String path$5, IntRef start$49, int index$18) {
        return Tuple4$.MODULE$.apply((Object)path$5, (Object)BoxesRunTime.boxToBoolean((boolean)directory$1), (Object)BoxesRunTime.boxToInteger((int)start$49.elem), (Object)BoxesRunTime.boxToInteger((int)index$18));
    }

    private static Tuple4 $anonfun$1(boolean directory$2, String path$6, IntRef start$50, int index$19) {
        return AbstractFile.dotty$tools$io$AbstractFile$_$while$$$message$3(directory$2, path$6, start$50, index$19);
    }

    private String message$2(String name$181) {
        return new StringOps(Predef$.MODULE$.augmentString("Tried to find '%s' in '%s' but it is not a directory")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name$181, this.path()}));
    }

    private String fileNamed$$anonfun$1(String name$183) {
        return this.message$2(name$183);
    }

    private String message$1(String name$182) {
        return new StringOps(Predef$.MODULE$.augmentString("Tried to find '%s' in '%s' but it is not a directory")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name$182, this.path()}));
    }

    private String subdirectoryNamed$$anonfun$1(String name$184) {
        return this.message$1(name$184);
    }
}

