/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.runtime.LazyVals$;
import dotty.tools.io.File$;
import dotty.tools.io.Path$;
import dotty.tools.io.ZipArchive;
import dotty.tools.io.ZipArchive$;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileZipArchive
extends ZipArchive {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(FileZipArchive.class, "bitmap$0");
    public long bitmap$0;
    private Tuple2 $230$$lzy1;

    public FileZipArchive(File file) {
        super(file);
    }

    public File dotty$tools$io$FileZipArchive$$file() {
        return super.file();
    }

    public ZipFile dotty$tools$io$FileZipArchive$$openZipFile() {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(this.dotty$tools$io$FileZipArchive$$file());
        }
        catch (IOException ioe) {
            throw new IOException(new StringBuilder().append((Object)"Error accessing ").append((Object)this.dotty$tools$io$FileZipArchive$$file().getPath()).toString(), ioe);
        }
        return zipFile;
    }

    private Tuple2 $1$() {
        Tuple2 tuple2 = null;
        boolean bl = true;
        long l = 0L;
        block8: while (bl) {
            l = LazyVals$.MODULE$.get((Object)this, OFFSET$0);
            switch ((int)LazyVals$.MODULE$.STATE(l, 0)) {
                case 0: {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue block8;
                    try {
                        ZipArchive.DirEntry root = new ZipArchive.DirEntry(this, "/");
                        Object[] objectArray = new Tuple2[1];
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)"/");
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)root);
                        HashMap dirs = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(objectArray));
                        ZipFile zipFile = this.dotty$tools$io$FileZipArchive$$openZipFile();
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        this.liftedTree11$1(dirs, zipFile, entries);
                        tuple2 = Tuple2$.MODULE$.apply((Object)root, (Object)dirs);
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                    this.$230$$lzy1 = tuple2;
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    bl = false;
                    break;
                }
                case 1: {
                    LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
                    break;
                }
                case 2: {
                    LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
                    break;
                }
                case 3: {
                    bl = false;
                    tuple2 = this.$230$$lzy1;
                    break;
                }
            }
        }
        return tuple2;
    }

    public ZipArchive.DirEntry root() {
        return (ZipArchive.DirEntry)this.$1$()._1();
    }

    public HashMap allDirs() {
        return (HashMap)this.$1$()._2();
    }

    @Override
    public Iterator iterator() {
        return this.root().iterator();
    }

    @Override
    public String name() {
        return this.dotty$tools$io$FileZipArchive$$file().getName();
    }

    @Override
    public String path() {
        return this.dotty$tools$io$FileZipArchive$$file().getPath();
    }

    @Override
    public InputStream input() {
        return File$.MODULE$.apply(Path$.MODULE$.jfile2path(this.dotty$tools$io$FileZipArchive$$file()), Codec$.MODULE$.fallbackSystemCodec()).inputStream();
    }

    @Override
    public long lastModified() {
        return this.dotty$tools$io$FileZipArchive$$file().lastModified();
    }

    @Override
    public Option sizeOption() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.dotty$tools$io$FileZipArchive$$file().length())));
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof FileZipArchive;
    }

    public int hashCode() {
        return this.dotty$tools$io$FileZipArchive$$file().hashCode();
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof FileZipArchive) {
            FileZipArchive fileZipArchive;
            FileZipArchive x = fileZipArchive = (FileZipArchive)object;
            File file = this.dotty$tools$io$FileZipArchive$$file().getAbsoluteFile();
            File file2 = x.file().getAbsoluteFile();
            bl = !(file != null ? !((Object)file).equals(file2) : file2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    private void liftedTree11$1(HashMap dirs$1, ZipFile zipFile$4, Enumeration entries$9) {
        try {
            while (entries$9.hasMoreElements()) {
                ZipArchive.DirEntry dirEntry;
                ZipEntry zipEntry = (ZipEntry)entries$9.nextElement();
                ZipArchive.DirEntry dir = this.getDir((Map)dirs$1, zipEntry);
                if (zipEntry.isDirectory()) {
                    dirEntry = dir;
                    continue;
                }
                ZipArchive.Entry f = ZipArchive$.MODULE$.closeZipFile() ? new LazyEntry(this, zipEntry.getName(), zipEntry.getTime(), (int)zipEntry.getSize()) : new LeakyEntry(this, zipFile$4, zipEntry);
                dir.entries().update((Object)f.name(), (Object)f);
                dirEntry = BoxedUnit.UNIT;
            }
        }
        finally {
            if (ZipArchive$.MODULE$.closeZipFile()) {
                zipFile$4.close();
            }
        }
    }

    private static class LazyEntry
    extends ZipArchive.Entry {
        private final String name;
        private final long time;
        private final int size;
        private final FileZipArchive $outer;

        public LazyEntry(FileZipArchive $outer, String name, long time, int size) {
            this.name = name;
            this.time = time;
            this.size = size;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, name);
        }

        @Override
        public long lastModified() {
            return this.time;
        }

        @Override
        public InputStream input() {
            ZipFile zipFile = this.dotty$tools$io$FileZipArchive$LazyEntry$$$outer().dotty$tools$io$FileZipArchive$$openZipFile();
            ZipEntry entry = zipFile.getEntry(this.name);
            InputStream delegate = zipFile.getInputStream(entry);
            return new FilterInputStream(zipFile, delegate){
                private final ZipFile zipFile$1;
                {
                    this.zipFile$1 = zipFile$2;
                    super(delegate$1);
                }

                public void close() {
                    this.zipFile$1.close();
                }
            };
        }

        @Override
        public Option sizeOption() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.size));
        }

        private FileZipArchive $outer() {
            return this.$outer;
        }

        public final FileZipArchive dotty$tools$io$FileZipArchive$LazyEntry$$$outer() {
            return this.$outer();
        }
    }

    private static class LeakyEntry
    extends ZipArchive.Entry {
        private final ZipFile zipFile;
        private final ZipEntry zipEntry;
        private final FileZipArchive $outer;

        public LeakyEntry(FileZipArchive $outer, ZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, zipEntry.getName());
        }

        @Override
        public long lastModified() {
            return this.zipEntry.getTime();
        }

        @Override
        public InputStream input() {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        @Override
        public Option sizeOption() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.zipEntry.getSize())));
        }

        private FileZipArchive $outer() {
            return this.$outer;
        }

        public final FileZipArchive dotty$tools$io$FileZipArchive$LeakyEntry$$$outer() {
            return this.$outer();
        }
    }
}

